/*
 * Decompiled with CFR 0.152.
 */
package love.kill.methodcache.controller;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import love.kill.methodcache.datahelper.CacheStatisticsModel;
import love.kill.methodcache.datahelper.DataHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ConditionalOnProperty(prefix="methodcache", name={"enable-endpoint"}, havingValue="true")
@RestController
@RequestMapping(value={"/methodcache/statistics"})
public class Statistics {
    @Autowired
    private DataHelper dataHelper;

    @GetMapping
    public Map<String, Map<String, Object>> get(@RequestParam(value="match", required=false) String match, @RequestParam(value="order_by", required=false) String orderBy, @RequestParam(value="order_type", required=false) String orderType) {
        Map<String, CacheStatisticsModel> statistics = this.dataHelper.getStatistics(match);
        if (statistics == null) {
            return new HashMap<String, Map<String, Object>>();
        }
        TreeMap<String, Map<String, Object>> resultMap = new TreeMap<String, Map<String, Object>>((situationKey1, situationKey2) -> this.compare((CacheStatisticsModel)statistics.get(situationKey1), (CacheStatisticsModel)statistics.get(situationKey2), StringUtils.isEmpty((Object)orderBy) ? "-1" : orderBy, StringUtils.isEmpty((Object)orderType) ? "0" : orderType));
        return this.transferStatistics(statistics, resultMap);
    }

    @DeleteMapping
    public Map<String, Map<String, Object>> delete(@RequestParam(value="id", required=false) String id, @RequestParam(value="method", required=false) String methodSignature) {
        if (StringUtils.isEmpty((Object)id) && StringUtils.isEmpty((Object)methodSignature)) {
            return new HashMap<String, Map<String, Object>>();
        }
        Map<String, CacheStatisticsModel> wipeStatistics = this.dataHelper.wipeStatistics(id, methodSignature);
        TreeMap<String, Map<String, Object>> resultMap = new TreeMap<String, Map<String, Object>>((situationKey1, situationKey2) -> this.compare((CacheStatisticsModel)wipeStatistics.get(situationKey1), (CacheStatisticsModel)wipeStatistics.get(situationKey2), "-1", "0"));
        return this.transferStatistics(wipeStatistics, resultMap);
    }

    @DeleteMapping(value={"/all"})
    public Map<String, Map<String, Object>> deleteAll() {
        Map<String, CacheStatisticsModel> wipeStatistics = this.dataHelper.wipeStatisticsAll();
        TreeMap<String, Map<String, Object>> resultMap = new TreeMap<String, Map<String, Object>>((situationKey1, situationKey2) -> this.compare((CacheStatisticsModel)wipeStatistics.get(situationKey1), (CacheStatisticsModel)wipeStatistics.get(situationKey2), "-1", "0"));
        return this.transferStatistics(wipeStatistics, resultMap);
    }

    private Map<String, Map<String, Object>> transferStatistics(Map<String, CacheStatisticsModel> statistics, Map<String, Map<String, Object>> targetMap) {
        for (String methodSignature : statistics.keySet()) {
            CacheStatisticsModel statisticsModel = statistics.get(methodSignature);
            HashMap<String, String> statisticsInfo = new HashMap<String, String>();
            statisticsInfo.put("id", statisticsModel.getId());
            statisticsInfo.put("remark", statisticsModel.getRemark());
            statisticsInfo.put("times", statisticsModel.printTimes());
            statisticsInfo.put("hit", statisticsModel.printHit());
            statisticsInfo.put("avgOfHitSpend", statisticsModel.printAvgOfHitSpend());
            statisticsInfo.put("totalOfHitSpend", statisticsModel.printTotalOfHitSpend());
            statisticsInfo.put("minHitSpend", statisticsModel.printMinHitSpend());
            statisticsInfo.put("timeOfMinHitSpend", statisticsModel.printTimeOfMinHitSpend());
            statisticsInfo.put("argsOfMinHitSpend", statisticsModel.printArgsOfMinHitSpend());
            statisticsInfo.put("maxHitSpend", statisticsModel.printMaxHitSpend());
            statisticsInfo.put("timeOfMaxHitSpend", statisticsModel.printTimeOfMaxHitSpend());
            statisticsInfo.put("argsOfMaxHitSpend", statisticsModel.printArgsOfMaxHitSpend());
            statisticsInfo.put("failure", statisticsModel.printFailure());
            statisticsInfo.put("avgOfFailureSpend", statisticsModel.printAvgOfFailureSpend());
            statisticsInfo.put("totalOfFailureSpend", statisticsModel.printTotalOfFailureSpend());
            statisticsInfo.put("minFailureSpend", statisticsModel.printMinFailureSpend());
            statisticsInfo.put("timeOfMinFailureSpend", statisticsModel.printTimeOfMinFailureSpend());
            statisticsInfo.put("argsOfMinFailureSpend", statisticsModel.printArgsOfMinFailureSpend());
            statisticsInfo.put("maxFailureSpend", statisticsModel.printMaxFailureSpend());
            statisticsInfo.put("timeOfMaxFailureSpend", statisticsModel.printTimeOfMaxFailureSpend());
            statisticsInfo.put("argsOfMaxFailureSpend", statisticsModel.printArgsOfMaxFailureSpend());
            statisticsInfo.put("exception", statisticsModel.printException());
            statisticsInfo.put("argsOfLastException", statisticsModel.printArgsOfLastException());
            statisticsInfo.put("stackTraceOfLastException", statisticsModel.printStackTraceOfLastException());
            statisticsInfo.put("timeOfLastException", statisticsModel.printTimeOfLastException());
            targetMap.put(methodSignature, statisticsInfo);
        }
        return targetMap;
    }

    private int compare(CacheStatisticsModel model1, CacheStatisticsModel model2, String orderBy, String orderType) {
        switch (orderBy) {
            case "0": {
                return this.doSort(model1.getId(), model2.getId(), orderType);
            }
            case "1": {
                return this.doSort(model1.getTimes(), model2.getTimes(), orderType);
            }
            case "2": {
                return this.doSort(model1.getHit(), model2.getHit(), orderType);
            }
            case "3": {
                return this.doSort(model1.getFailure(), model2.getFailure(), orderType);
            }
            case "4": {
                return this.doSort(model1.getAvgOfHitSpend(), model2.getAvgOfHitSpend(), orderType);
            }
            case "5": {
                return this.doSort(model1.getAvgOfFailureSpend(), model2.getAvgOfFailureSpend(), orderType);
            }
        }
        return this.doSort(model1.getMethodSignature(), model2.getMethodSignature(), orderType);
    }

    private int doSort(Object o1, Object o2, String orderType) {
        int c;
        if (o1.getClass() != o2.getClass() || !(o1 instanceof Comparable)) {
            return -1;
        }
        int n = c = "0".equals(orderType) ? ((Comparable)o1).compareTo(o2) : ((Comparable)o2).compareTo(o1);
        if (c == 0) {
            c = -1;
        }
        return c;
    }
}

