/*
 * Decompiled with CFR 0.152.
 */
package love.kill.methodcache.datahelper;

import com.carrotsearch.sizeof.RamUsageEstimator;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import love.kill.methodcache.datahelper.DataHelper;

public class CacheDataModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static SimpleDateFormat outPrintSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String applicationName;
    private String methodSignature;
    private String args;
    private int cacheHashCode;
    private Object data;
    private Long cacheTime = new Date().getTime();
    private long expireTime;
    private String remark;
    private String id;
    private long instanceSize = 0L;

    public CacheDataModel(String applicationName, String methodSignature, String args, int cacheHashCode, Object data, long expireTime) {
        this.applicationName = applicationName;
        this.methodSignature = methodSignature;
        this.args = args;
        this.cacheHashCode = cacheHashCode;
        this.data = data;
        this.expireTime = expireTime;
        this.refreshInstanceSize();
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public String getArgs() {
        return this.args;
    }

    public int getCacheHashCode() {
        return this.cacheHashCode;
    }

    public Object getData() {
        if (this.data instanceof DataHelper.NullObject) {
            return null;
        }
        return this.data;
    }

    public long getCacheTime() {
        return this.cacheTime;
    }

    public String getFormatCacheTime() {
        return this.formatDate(this.cacheTime);
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public String getFormatExpireTime() {
        return this.formatDate(this.expireTime);
    }

    public synchronized boolean isExpired() {
        return this.expireTime >= 0L && new Date().getTime() >= this.expireTime;
    }

    public synchronized void expired() {
        this.expireTime = new Date().getTime();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public long getInstanceSize() {
        return this.instanceSize;
    }

    public void setInstanceSize(long instanceSize) {
        this.instanceSize = instanceSize;
    }

    public String toString() {
        return "CacheDataModel{methodSignature='" + this.methodSignature + '\'' + ", args='" + this.args + '\'' + ", data=" + this.data + ", cacheTime=" + this.formatDate(this.cacheTime) + ", expireTime=" + this.formatDate(this.expireTime) + ", remark=" + this.remark + ", id=" + this.id + ", instanceSize=" + this.instanceSize + '}';
    }

    private String formatDate(long timeStamp) {
        try {
            return outPrintSimpleDateFormat.format(new Date(timeStamp));
        }
        catch (Exception e) {
            return String.valueOf(timeStamp);
        }
    }

    private void refreshInstanceSize() {
        this.instanceSize = RamUsageEstimator.sizeOf((Object)this);
    }
}

