/*
 * Decompiled with CFR 0.152.
 */
package love.kill.methodcache.datahelper;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;

public class CacheStatisticsModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static SimpleDateFormat outPrintSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String cacheKey;
    private String methodSignature;
    private int methodSignatureHashCode;
    private String id;
    private String remark;
    private volatile int hit = -1;
    private volatile long totalOfHitSpend = -1L;
    private long minHitSpend = -1L;
    private long timeOfMinHitSpend = -1L;
    private String argsOfMinHitSpend = "";
    private long maxHitSpend = -1L;
    private long timeOfMaxHitSpend = -1L;
    private String argsOfMaxHitSpend = "";
    private volatile int failure = -1;
    private long totalOfFailureSpend = -1L;
    private long minFailureSpend = -1L;
    private long timeOfMinFailureSpend = -1L;
    private String argsOfMinFailureSpend = "";
    private long maxFailureSpend = -1L;
    private long timeOfMaxFailureSpend = -1L;
    private String argsOfMaxFailureSpend = "";
    private volatile int exception = -1;
    private long timeOfLastException = -1L;
    private String argsOfLastException = "";
    private String stackTraceOfLastException = "";

    public CacheStatisticsModel(String cacheKey, String methodSignature, int methodSignatureHashCode, String id, String remark) {
        this.cacheKey = cacheKey;
        this.methodSignature = methodSignature;
        this.methodSignatureHashCode = methodSignatureHashCode;
        this.id = id;
        this.remark = remark;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public String getMethodSignature() {
        return this.methodSignature;
    }

    public int getMethodSignatureHashCode() {
        return this.methodSignatureHashCode;
    }

    public String getId() {
        return this.id;
    }

    public String getRemark() {
        return this.remark;
    }

    public int getHit() {
        return this.hit == -1 ? 0 : this.hit;
    }

    public String printHit() {
        return String.valueOf(this.getHit());
    }

    public long getTotalOfHitSpend() {
        return this.totalOfHitSpend == -1L ? 0L : this.totalOfHitSpend;
    }

    public String printTotalOfHitSpend() {
        if (this.totalOfHitSpend == -1L) {
            return "";
        }
        return String.valueOf(this.totalOfHitSpend);
    }

    public void incrementHit(long spend) {
        this.hit = this.getHit() + 1;
        this.totalOfHitSpend = this.getTotalOfHitSpend() + spend;
    }

    public long getAvgOfHitSpend() {
        if (this.hit == -1 || this.totalOfHitSpend == -1L) {
            return -1L;
        }
        if (this.hit == 0) {
            return 0L;
        }
        return new BigDecimal(this.totalOfHitSpend).divide(new BigDecimal(this.hit), 0, 4).longValue();
    }

    public String printAvgOfHitSpend() {
        if (this.getAvgOfHitSpend() == -1L) {
            return "";
        }
        return String.valueOf(this.getAvgOfHitSpend());
    }

    public String printMinHitSpend() {
        if (this.minHitSpend == -1L) {
            return "";
        }
        return String.valueOf(this.minHitSpend);
    }

    public void setMinHitSpend(long minHitSpend, long timeOfMinHitSpend, String args) {
        if (this.minHitSpend == -1L || this.minHitSpend > minHitSpend) {
            this.minHitSpend = minHitSpend;
            this.timeOfMinHitSpend = timeOfMinHitSpend;
            this.argsOfMinHitSpend = args;
        }
    }

    public String printTimeOfMinHitSpend() {
        if (this.timeOfMinHitSpend == -1L) {
            return "";
        }
        return outPrintSimpleDateFormat.format(new Date(this.timeOfMinHitSpend));
    }

    public String printArgsOfMinHitSpend() {
        return Objects.toString(this.argsOfMinHitSpend);
    }

    public String printMaxHitSpend() {
        if (this.maxHitSpend == -1L) {
            return "";
        }
        return String.valueOf(this.maxHitSpend);
    }

    public void setMaxHitSpend(long maxHitSpend, long timeOfMaxHitSpend, String args) {
        if (this.maxHitSpend == -1L || this.maxHitSpend < maxHitSpend) {
            this.maxHitSpend = maxHitSpend;
            this.timeOfMaxHitSpend = timeOfMaxHitSpend;
            this.argsOfMaxHitSpend = args;
        }
    }

    public String printTimeOfMaxHitSpend() {
        if (this.timeOfMaxHitSpend == -1L) {
            return "";
        }
        return outPrintSimpleDateFormat.format(new Date(this.timeOfMaxHitSpend));
    }

    public String printArgsOfMaxHitSpend() {
        return Objects.toString(this.argsOfMaxHitSpend);
    }

    public int getFailure() {
        return this.failure == -1 ? 0 : this.failure;
    }

    public String printFailure() {
        return String.valueOf(this.getFailure());
    }

    public long getTotalOfFailureSpend() {
        return this.totalOfFailureSpend == -1L ? 0L : this.totalOfFailureSpend;
    }

    public String printTotalOfFailureSpend() {
        if (this.totalOfFailureSpend == -1L) {
            return "";
        }
        return String.valueOf(this.totalOfFailureSpend);
    }

    public void incrementFailure(long spend) {
        this.failure = this.getFailure() + 1;
        this.totalOfFailureSpend = this.getTotalOfFailureSpend() + spend;
    }

    public long getAvgOfFailureSpend() {
        if (this.failure == -1 || this.totalOfFailureSpend == -1L) {
            return -1L;
        }
        if (this.failure == 0) {
            return 0L;
        }
        return new BigDecimal(this.totalOfFailureSpend).divide(new BigDecimal(this.failure), 0, 4).longValue();
    }

    public String printAvgOfFailureSpend() {
        if (this.getAvgOfFailureSpend() == -1L) {
            return "";
        }
        return String.valueOf(this.getAvgOfFailureSpend());
    }

    public String printMinFailureSpend() {
        if (this.minFailureSpend == -1L) {
            return "";
        }
        return String.valueOf(this.minFailureSpend);
    }

    public void setMinFailureSpend(long minFailureSpend, long timeOfMinFailureSpend, String args) {
        if (this.minFailureSpend == -1L || this.minFailureSpend > minFailureSpend) {
            this.minFailureSpend = minFailureSpend;
            this.timeOfMinFailureSpend = timeOfMinFailureSpend;
            this.argsOfMinFailureSpend = args;
        }
    }

    public String printTimeOfMinFailureSpend() {
        if (this.timeOfMinFailureSpend == -1L) {
            return "";
        }
        return outPrintSimpleDateFormat.format(new Date(this.timeOfMinFailureSpend));
    }

    public String printArgsOfMinFailureSpend() {
        return Objects.toString(this.argsOfMinFailureSpend);
    }

    public String printMaxFailureSpend() {
        if (this.maxFailureSpend == -1L) {
            return "";
        }
        return String.valueOf(this.maxFailureSpend);
    }

    public void setMaxFailureSpend(long maxFailureSpend, long timeOfMaxFailureSpend, String args) {
        if (this.maxFailureSpend < maxFailureSpend) {
            this.maxFailureSpend = maxFailureSpend;
            this.timeOfMaxFailureSpend = timeOfMaxFailureSpend;
            this.argsOfMaxFailureSpend = args;
        }
    }

    public String printTimeOfMaxFailureSpend() {
        if (this.timeOfMaxFailureSpend == -1L) {
            return "";
        }
        return outPrintSimpleDateFormat.format(new Date(this.timeOfMaxFailureSpend));
    }

    public String printArgsOfMaxFailureSpend() {
        return Objects.toString(this.argsOfMaxFailureSpend);
    }

    public int getTimes() {
        return this.getHit() + this.getFailure();
    }

    public String printTimes() {
        return String.valueOf(this.getTimes());
    }

    public int getException() {
        return this.exception == -1 ? 0 : this.exception;
    }

    public String printException() {
        return String.valueOf(this.getException());
    }

    public void incrementTimesOfException(String args, String stackTrace, long time) {
        this.exception = this.getException() + 1;
        this.argsOfLastException = args;
        this.stackTraceOfLastException = stackTrace;
        this.timeOfLastException = time;
    }

    public String printArgsOfLastException() {
        return Objects.toString(this.argsOfLastException);
    }

    public String printStackTraceOfLastException() {
        return this.stackTraceOfLastException;
    }

    public String printTimeOfLastException() {
        if (this.timeOfLastException == -1L) {
            return "";
        }
        return outPrintSimpleDateFormat.format(new Date(this.timeOfLastException));
    }

    public String toString() {
        return "CacheStatisticsModel{methodSignature='" + this.methodSignature + '\'' + ", methodSignatureHashCode=" + this.methodSignatureHashCode + ", id='" + this.id + '\'' + ", remark='" + this.remark + '\'' + ", hit=" + this.printHit() + ", avgOfHitSpend=" + this.getAvgOfHitSpend() + ", totalOfHitSpend=" + this.getTotalOfHitSpend() + ", minHitSpend=" + this.minHitSpend + ", timeOfMinHitSpend=" + this.timeOfMinHitSpend + ", maxHitSpend=" + this.maxHitSpend + ", timeOfMaxHitSpend=" + this.timeOfMaxHitSpend + ", failure=" + this.failure + ", avgOfFailureSpend=" + this.getAvgOfFailureSpend() + ", totalOfFailureSpend=" + this.getTotalOfFailureSpend() + ", minFailureSpend=" + this.minFailureSpend + ", timeOfMinFailureSpend=" + this.timeOfMinFailureSpend + ", maxFailureSpend=" + this.maxFailureSpend + ", timeOfMaxFailureSpend=" + this.timeOfMaxFailureSpend + ", exception=" + this.exception + ", argsOfLastException=" + this.argsOfLastException + ", stackTraceOfLastException=" + this.stackTraceOfLastException + ", timeOfLastException=" + this.timeOfLastException + '}';
    }
}

