/*
 * Decompiled with CFR 0.152.
 */
package love.kill.methodcache.datahelper;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import love.kill.methodcache.datahelper.CacheDataModel;
import love.kill.methodcache.datahelper.CacheStatisticsModel;
import love.kill.methodcache.util.DataUtil;
import love.kill.methodcache.util.ThreadPoolBuilder;
import org.springframework.util.StringUtils;

public interface DataHelper {
    public static final SimpleDateFormat formatDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final String METHOD_CACHE_DATA = "METHOD_CACHE_DATA";
    public static final String METHOD_CACHE_STATISTICS = "METHOD_CACHE_STATISTICS";
    public static final String KEY_SEPARATION_CHARACTER = "@";
    public static final ExecutorService recordStatisticsExecutorService = ThreadPoolBuilder.buildDefaultThreadPool();
    public static final ThreadLocal<String> threadLocal = new ThreadLocal();
    public static final Map<String, Map<Integer, WeakReference<CacheDataModel>>> sharedCacheData = new ConcurrentHashMap<String, Map<Integer, WeakReference<CacheDataModel>>>();
    public static final ReentrantReadWriteLock sharedCacheDataLock = new ReentrantReadWriteLock();
    public static final BlockingQueue<CacheStatisticsNode> cacheStatisticsInfoQueue = new LinkedBlockingQueue<CacheStatisticsNode>();

    public Object getData(Object var1, Method var2, Object[] var3, String var4, boolean var5, ActualDataFunctional var6, String var7, String var8, boolean var9, boolean var10) throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheDataModel getSharedData(String methodSignature, Integer cacheHashCode) {
        if (StringUtils.isEmpty((Object)methodSignature) || StringUtils.isEmpty((Object)cacheHashCode)) {
            return null;
        }
        try {
            WeakReference<CacheDataModel> cacheDataModelWeakReference;
            sharedCacheDataLock.readLock().lock();
            Map<Integer, WeakReference<CacheDataModel>> cacheDataModelMap = sharedCacheData.get(methodSignature);
            if (cacheDataModelMap != null && (cacheDataModelWeakReference = cacheDataModelMap.get(cacheHashCode)) != null) {
                CacheDataModel cacheDataModel = (CacheDataModel)cacheDataModelWeakReference.get();
                return cacheDataModel;
            }
        }
        finally {
            sharedCacheDataLock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CacheDataModel setSharedData(CacheDataModel cacheDataModel) {
        try {
            sharedCacheDataLock.writeLock().lock();
            String methodSignature = cacheDataModel.getMethodSignature();
            int cacheHashCode = cacheDataModel.getCacheHashCode();
            Map cacheDataModelMap = sharedCacheData.computeIfAbsent(methodSignature, k -> new HashMap());
            cacheDataModelMap.put(cacheHashCode, new WeakReference<CacheDataModel>(cacheDataModel));
        }
        finally {
            sharedCacheDataLock.writeLock().unlock();
        }
        return cacheDataModel;
    }

    public static CacheDataModel decisionCacheDataModel(CacheDataModel cacheDataModel) {
        CacheDataModel sharedData = DataHelper.getSharedData(cacheDataModel.getMethodSignature(), cacheDataModel.getCacheHashCode());
        if (sharedData == null || cacheDataModel.getCacheTime() != sharedData.getCacheTime()) {
            return DataHelper.setSharedData(cacheDataModel);
        }
        cacheDataModel = null;
        return sharedData;
    }

    public Map<String, Map<String, Object>> getCaches(String var1);

    public Map<String, Map<String, Object>> wipeCache(String var1, String var2);

    public Map<String, CacheStatisticsModel> getCacheStatistics();

    public CacheStatisticsModel getCacheStatistics(String var1);

    public void setCacheStatistics(String var1, CacheStatisticsModel var2);

    public void wipeStatistics(CacheStatisticsModel var1);

    public Map<String, CacheStatisticsModel> wipeStatisticsAll();

    default public int getCacheHashCode(String applicationName, int methodSignatureHashCode, int argsHashCode, String extensionStr) {
        StringBuilder s = new StringBuilder(String.valueOf(methodSignatureHashCode) + String.valueOf(argsHashCode));
        if (!StringUtils.isEmpty((Object)applicationName)) {
            s.insert(0, applicationName);
        }
        if (!StringUtils.isEmpty((Object)extensionStr)) {
            s.append(extensionStr);
        }
        return DataUtil.hash(s.toString());
    }

    default public String getCacheKey(String applicationName, String methodSignature, int cacheHashCode, String id) {
        StringBuilder cacheKey = new StringBuilder(methodSignature + KEY_SEPARATION_CHARACTER + cacheHashCode + KEY_SEPARATION_CHARACTER + id);
        if (!StringUtils.isEmpty((Object)applicationName)) {
            cacheKey.insert(0, KEY_SEPARATION_CHARACTER).insert(0, applicationName);
        }
        return cacheKey.toString();
    }

    default public void filterDataModel(Map<String, Map<String, Object>> cacheMap, CacheDataModel cacheDataModel, String select) {
        String args;
        if (!(StringUtils.isEmpty((Object)select) || StringUtils.isEmpty((Object)(args = cacheDataModel.getArgs())) || args.contains(select))) {
            return;
        }
        Map keyMap = cacheMap.computeIfAbsent(cacheDataModel.getMethodSignature(), k -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", cacheDataModel.getId());
            map.put("remark", cacheDataModel.getRemark());
            return map;
        });
        List cacheInfoList = (List)keyMap.computeIfAbsent("cache", k -> new ArrayList());
        HashMap<String, Object> cacheInfo = new HashMap<String, Object>();
        cacheInfo.put("hashCode", cacheDataModel.getCacheHashCode());
        cacheInfo.put("args", cacheDataModel.getArgs());
        cacheInfo.put("data", Objects.toString(cacheDataModel.getData()));
        cacheInfo.put("cacheTime", cacheDataModel.getFormatCacheTime());
        cacheInfo.put("expireTime", cacheDataModel.getFormatExpireTime());
        cacheInfoList.add(cacheInfo);
    }

    default public Map<String, CacheStatisticsModel> getStatistics(String match) {
        Map<String, CacheStatisticsModel> cacheStatistics = this.getCacheStatistics();
        if (cacheStatistics == null) {
            return null;
        }
        HashMap<String, CacheStatisticsModel> resultMap = new HashMap<String, CacheStatisticsModel>();
        for (String methodSignature : cacheStatistics.keySet()) {
            CacheStatisticsModel situationModel = cacheStatistics.get(methodSignature);
            String id = situationModel.getId();
            if (!StringUtils.isEmpty((Object)match) && !methodSignature.contains(match) && (StringUtils.isEmpty((Object)id) || !id.equals(match))) continue;
            resultMap.put(methodSignature, situationModel);
        }
        return resultMap;
    }

    default public CacheStatisticsModel increaseStatistics(CacheStatisticsModel cacheStatisticsModel, CacheStatisticsNode cacheStatisticsNode) {
        if (cacheStatisticsModel == null) {
            cacheStatisticsModel = new CacheStatisticsModel(cacheStatisticsNode.getCacheKey(), cacheStatisticsNode.getMethodSignature(), cacheStatisticsNode.getMethodSignatureHashCode(), cacheStatisticsNode.getId(), cacheStatisticsNode.getRemark());
        }
        boolean hit = cacheStatisticsNode.isHit();
        boolean invokeException = cacheStatisticsNode.isInvokeException();
        String stackTraceOfException = cacheStatisticsNode.getStackTraceOfException();
        long startTimestamp = cacheStatisticsNode.getStartTimestamp();
        long endTimestamp = cacheStatisticsNode.getEndTimestamp();
        long spend = endTimestamp - startTimestamp;
        String args = cacheStatisticsNode.getArgs();
        if (invokeException) {
            cacheStatisticsModel.incrementTimesOfException(args, stackTraceOfException, startTimestamp);
        } else if (hit) {
            cacheStatisticsModel.incrementHit(spend);
            cacheStatisticsModel.setMinHitSpend(spend, startTimestamp, args);
            cacheStatisticsModel.setMaxHitSpend(spend, startTimestamp, args);
        } else {
            cacheStatisticsModel.incrementFailure(spend);
            cacheStatisticsModel.setMinFailureSpend(spend, startTimestamp, args);
            cacheStatisticsModel.setMaxFailureSpend(spend, startTimestamp, args);
        }
        return cacheStatisticsModel;
    }

    default public void recordStatistics(String cacheKey, String methodSignature, int methodSignatureHashCode, String args, int argsHashCode, int cacheHashCode, String id, String remark, boolean hit, boolean invokeException, String stackTraceOfException, long startTimestamp, long endTimestamp) {
        recordStatisticsExecutorService.execute(() -> {
            try {
                cacheStatisticsInfoQueue.put(new CacheStatisticsNode(cacheKey, methodSignature, methodSignatureHashCode, args, argsHashCode, cacheHashCode, id, remark, hit, invokeException, stackTraceOfException, startTimestamp, endTimestamp));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        });
    }

    default public Map<String, CacheStatisticsModel> wipeStatistics(String id, String methodSignature) {
        Map<String, CacheStatisticsModel> cacheStatistics = this.getCacheStatistics();
        if (cacheStatistics.isEmpty()) {
            return new HashMap<String, CacheStatisticsModel>();
        }
        HashMap<String, CacheStatisticsModel> resultMap = new HashMap<String, CacheStatisticsModel>();
        for (String key : cacheStatistics.keySet()) {
            CacheStatisticsModel statisticsModel = cacheStatistics.get(key);
            if ((StringUtils.isEmpty((Object)id) || !id.equals(statisticsModel.getId())) && (StringUtils.isEmpty((Object)methodSignature) || !methodSignature.equals(key))) continue;
            resultMap.put(key, statisticsModel);
        }
        if (resultMap.isEmpty()) {
            return new HashMap<String, CacheStatisticsModel>();
        }
        for (CacheStatisticsModel statisticsModel : resultMap.values()) {
            this.wipeStatistics(statisticsModel);
        }
        return resultMap;
    }

    default public String formatDate(long timeStamp) {
        try {
            return formatDate.format(new Date(timeStamp));
        }
        catch (Exception e) {
            e.printStackTrace();
            return String.valueOf(timeStamp);
        }
    }

    default public String printStackTrace(Object[] stackTrace) {
        if (stackTrace == null) {
            return "";
        }
        int iMax = stackTrace.length - 1;
        if (iMax == -1) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        int i = 0;
        while (true) {
            b.append(String.valueOf(stackTrace[i])).append("\n");
            if (i == iMax) {
                return b.toString();
            }
            ++i;
        }
    }

    default public String printStackTrace(Throwable throwable, String uuid) {
        return "UUID=[" + uuid + "];message=[" + throwable.getMessage() + "];stackTrace=" + Arrays.toString(throwable.getStackTrace()) + "]";
    }

    default public boolean isNotNull(Object o, boolean nullable) {
        return o != null || nullable;
    }

    public static class CacheStatisticsNode {
        private String cacheKey;
        private String methodSignature;
        private int methodSignatureHashCode;
        private String args;
        private int argsHashCode;
        private int cacheHashCode;
        private String id;
        private String remark;
        private boolean hit;
        private boolean invokeException;
        private String stackTraceOfException;
        private long startTimestamp;
        private long endTimestamp;

        public CacheStatisticsNode(String cacheKey, String methodSignature, int methodSignatureHashCode, String args, int argsHashCode, int cacheHashCode, String id, String remark, boolean hit, boolean invokeException, String stackTraceOfException, long startTimestamp, long endTimestamp) {
            this.cacheKey = cacheKey;
            this.methodSignature = methodSignature;
            this.methodSignatureHashCode = methodSignatureHashCode;
            this.args = args;
            this.argsHashCode = argsHashCode;
            this.cacheHashCode = cacheHashCode;
            this.id = id;
            this.remark = remark;
            this.hit = hit;
            this.invokeException = invokeException;
            this.stackTraceOfException = stackTraceOfException;
            this.startTimestamp = startTimestamp;
            this.endTimestamp = endTimestamp;
        }

        public String getCacheKey() {
            return this.cacheKey;
        }

        public void setCacheKey(String cacheKey) {
            this.cacheKey = cacheKey;
        }

        public String getMethodSignature() {
            return this.methodSignature;
        }

        public void setMethodSignature(String methodSignature) {
            this.methodSignature = methodSignature;
        }

        public int getMethodSignatureHashCode() {
            return this.methodSignatureHashCode;
        }

        public void setMethodSignatureHashCode(int methodSignatureHashCode) {
            this.methodSignatureHashCode = methodSignatureHashCode;
        }

        public String getArgs() {
            return this.args;
        }

        public void setArgs(String args) {
            this.args = args;
        }

        public int getArgsHashCode() {
            return this.argsHashCode;
        }

        public void setArgsHashCode(int argsHashCode) {
            this.argsHashCode = argsHashCode;
        }

        public int getCacheHashCode() {
            return this.cacheHashCode;
        }

        public void setCacheHashCode(int cacheHashCode) {
            this.cacheHashCode = cacheHashCode;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getRemark() {
            return this.remark;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public boolean isHit() {
            return this.hit;
        }

        public void setHit(boolean hit) {
            this.hit = hit;
        }

        public boolean isInvokeException() {
            return this.invokeException;
        }

        public long getStartTimestamp() {
            return this.startTimestamp;
        }

        public String getStackTraceOfException() {
            return this.stackTraceOfException;
        }

        public void setStackTraceOfException(String stackTraceOfException) {
            this.stackTraceOfException = stackTraceOfException;
        }

        public void setStartTimestamp(long startTimestamp) {
            this.startTimestamp = startTimestamp;
        }

        public long getEndTimestamp() {
            return this.endTimestamp;
        }

        public void setEndTimestamp(long endTimestamp) {
            this.endTimestamp = endTimestamp;
        }
    }

    public static class NullObject
    implements Serializable {
        private static final long serialVersionUID = 1L;
    }

    public static interface ActualDataFunctional {
        public Object getActualData() throws Throwable;

        public long getExpirationTime();
    }
}

