/*
 * Decompiled with CFR 0.152.
 */
package love.kill.methodcache.datahelper.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import love.kill.methodcache.MemoryMonitor;
import love.kill.methodcache.MethodcacheProperties;
import love.kill.methodcache.SpringApplicationProperties;
import love.kill.methodcache.datahelper.CacheDataModel;
import love.kill.methodcache.datahelper.CacheStatisticsModel;
import love.kill.methodcache.datahelper.DataHelper;
import love.kill.methodcache.util.DataUtil;
import love.kill.methodcache.util.SerializeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class MemoryDataHelper
implements DataHelper {
    private static Logger logger = LoggerFactory.getLogger(MemoryDataHelper.class);
    private static final ExecutorService executorService = Executors.newFixedThreadPool(10);
    private static final Map<String, Map<Integer, String>> cacheData = new ConcurrentHashMap<String, Map<Integer, String>>();
    private static final Map<Long, Map<String, Set<Integer>>> dataExpireInfo = new ConcurrentHashMap<Long, Map<String, Set<Integer>>>();
    private static final Map<String, CacheStatisticsModel> cacheStatistics = new ConcurrentHashMap<String, CacheStatisticsModel>();
    private final MethodcacheProperties methodcacheProperties;
    private String applicationName;
    private static ReentrantLock cacheDataLock = new ReentrantLock();
    private static AtomicLong cacheDataSize = new AtomicLong(0L);
    private static AtomicInteger cacheDataCount = new AtomicInteger(0);
    private final double gcThreshold;

    public MemoryDataHelper(MethodcacheProperties methodcacheProperties, SpringApplicationProperties springApplicationProperties, MemoryMonitor memoryMonitor) {
        this.methodcacheProperties = methodcacheProperties;
        this.applicationName = methodcacheProperties.getName();
        if (StringUtils.isEmpty((Object)this.applicationName)) {
            this.applicationName = springApplicationProperties.getName();
        }
        this.gcThreshold = new BigDecimal(methodcacheProperties.getGcThreshold()).divide(new BigDecimal(100), 2, 4).doubleValue();
        Executors.newSingleThreadExecutor().execute(() -> {
            block10: while (true) {
                try {
                    cacheDataLock.lock();
                    ArrayList<Long> expireTimeStampKeyList = new ArrayList<Long>(dataExpireInfo.keySet());
                    if (expireTimeStampKeyList.size() <= 0) continue;
                    expireTimeStampKeyList.sort((l1, l2) -> (int)(l1 - l2));
                    long nowTimeStamp = new Date().getTime();
                    Iterator iterator = expireTimeStampKeyList.iterator();
                    while (true) {
                        long expireTimeStamp;
                        if (!iterator.hasNext() || (expireTimeStamp = ((Long)iterator.next()).longValue()) > nowTimeStamp) continue block10;
                        Map<String, Set<Integer>> methodArgsHashCodeMap = dataExpireInfo.get(expireTimeStamp);
                        for (String methodSignature : new HashSet<String>(methodArgsHashCodeMap.keySet())) {
                            Set<Integer> cacheHashCodeSet = methodArgsHashCodeMap.get(methodSignature);
                            for (Integer cacheHashCode : cacheHashCodeSet) {
                                this.doRemoveData(methodSignature, cacheHashCode);
                            }
                            methodArgsHashCodeMap.remove(methodSignature);
                        }
                        dataExpireInfo.remove(expireTimeStamp);
                    }
                }
                finally {
                    cacheDataLock.unlock();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                break;
            }
        });
        if (methodcacheProperties.isEnableStatistics()) {
            Executors.newSingleThreadExecutor().execute(() -> {
                while (true) {
                    try {
                        while (true) {
                            DataHelper.CacheStatisticsNode statisticsNode = (DataHelper.CacheStatisticsNode)cacheStatisticsInfoQueue.take();
                            Map<String, CacheStatisticsModel> map = cacheStatistics;
                            synchronized (map) {
                                String methodSignature = statisticsNode.getMethodSignature();
                                CacheStatisticsModel statisticsModel = this.increaseStatistics(this.getCacheStatistics(methodSignature), statisticsNode);
                                this.setCacheStatistics(methodSignature, statisticsModel);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            });
        }
        if (memoryMonitor != null) {
            memoryMonitor.sub(this::gc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(Object proxy, Method method, Object[] args, String isolationSignal, boolean refreshData, DataHelper.ActualDataFunctional actualDataFunctional, String id, String remark, boolean nullable, boolean shared) throws Throwable {
        long startTime = new Date().getTime();
        String methodSignature = method.toGenericString();
        int methodSignatureHashCode = methodSignature.hashCode();
        int argsHashCode = DataUtil.getArgsHashCode(args);
        String argsStr = Arrays.toString(args);
        int cacheHashCode = this.getCacheHashCode(this.applicationName, methodSignatureHashCode, argsHashCode, isolationSignal);
        if (StringUtils.isEmpty((Object)id)) {
            id = String.valueOf(methodSignature.hashCode());
        }
        String cacheKey = this.getCacheKey(this.applicationName, methodSignature, cacheHashCode, id);
        CacheDataModel cacheDataModel = MemoryDataHelper.getDataFromMemory(methodSignature, cacheHashCode, shared);
        boolean hit = cacheDataModel != null && !cacheDataModel.isExpired();
        this.log(String.format("\n ************* CacheData *************\n **--------- \u4ece\u5185\u5b58\u4e2d\u83b7\u53d6\u7f13\u5b58 ------- **\n ** \u6267\u884c\u5bf9\u8c61\uff1a%s\n ** \u65b9\u6cd5\u7b7e\u540d\uff1a%s\n ** \u65b9\u6cd5\u5165\u53c2\uff1a%s\n ** \u7f13\u5b58\u547d\u4e2d\uff1a%s\n ** \u8fc7\u671f\u65f6\u95f4\uff1a%s\n *************************************", proxy, methodSignature, argsStr, hit ? "\u662f" : "\u5426", hit ? this.formatDate(cacheDataModel.getExpireTime()) : "\u65e0"));
        if (!hit) {
            try {
                cacheDataLock.lock();
                cacheDataModel = MemoryDataHelper.getDataFromMemory(methodSignature, cacheHashCode, shared);
            }
            finally {
                cacheDataLock.unlock();
            }
            hit = cacheDataModel != null && !cacheDataModel.isExpired();
            this.log(String.format("\n ************* CacheData *************\n **------- \u4ece\u5185\u5b58\u83b7\u53d6\u7f13\u5b58(\u52a0\u9501) ----- **\n ** \u6267\u884c\u5bf9\u8c61\uff1a%s\n ** \u65b9\u6cd5\u7b7e\u540d\uff1a%s\n ** \u65b9\u6cd5\u5165\u53c2\uff1a%s\n ** \u7f13\u5b58\u547d\u4e2d\uff1a%s\n ** \u8fc7\u671f\u65f6\u95f4\uff1a%s\n *************************************", proxy, methodSignature, argsStr, hit ? "\u662f" : "\u5426", hit ? this.formatDate(cacheDataModel.getExpireTime()) : "\u65e0"));
            if (!hit) {
                Object data;
                try {
                    data = actualDataFunctional.getActualData();
                    this.log(String.format("\n ************* CacheData *************\n ** ----------- \u53d1\u8d77\u8bf7\u6c42 ----------- **\n ** \u6267\u884c\u5bf9\u8c61\uff1a%s\n ** \u65b9\u6cd5\u7b7e\u540d\uff1a%s\n ** \u65b9\u6cd5\u5165\u53c2\uff1a%s\n ** \u8fd4\u56de\u6570\u636e\uff1a%s\n *************************************", proxy, methodSignature, argsStr, data));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    String uuid = UUID.randomUUID().toString().trim().replaceAll("-", "");
                    logger.info("\n ************* CacheData *************\n ** -------- \u83b7\u53d6\u6570\u636e\u53d1\u751f\u5f02\u5e38 ------- **\n ** \u5f02\u5e38\u4fe1\u606f(UUID=" + uuid + ")\uff1a" + throwable.getMessage() + "\n" + this.printStackTrace(throwable.getStackTrace()) + "\n *************************************");
                    if (this.methodcacheProperties.isEnableStatistics()) {
                        this.recordStatistics(cacheKey, methodSignature, methodSignatureHashCode, argsStr, argsHashCode, cacheHashCode, id, remark, hit, true, this.printStackTrace(throwable, uuid), startTime, new Date().getTime());
                    }
                    throw throwable;
                }
                if (this.methodcacheProperties.isEnableStatistics()) {
                    this.recordStatistics(cacheKey, methodSignature, methodSignatureHashCode, argsStr, argsHashCode, cacheHashCode, id, remark, hit, false, "", startTime, new Date().getTime());
                }
                if (this.isNotNull(data, nullable)) {
                    long expirationTime = actualDataFunctional.getExpirationTime();
                    this.refreshData(proxy, data, expirationTime, this.applicationName, actualDataFunctional, nullable, methodSignature, argsStr, cacheHashCode, id, remark);
                }
                return data;
            }
        }
        if (this.methodcacheProperties.isEnableStatistics()) {
            this.recordStatistics(cacheKey, methodSignature, methodSignatureHashCode, argsStr, argsHashCode, cacheHashCode, id, remark, hit, false, "", startTime, new Date().getTime());
        }
        if (refreshData) {
            this.refreshData(proxy, null, -1L, this.applicationName, actualDataFunctional, nullable, methodSignature, argsStr, cacheHashCode, id, remark);
        }
        return cacheDataModel.getData();
    }

    @Override
    public Map<String, Map<String, Object>> getCaches(String match) {
        HashMap<String, Map<String, Object>> cacheMap = new HashMap<String, Map<String, Object>>();
        HashSet<Map<Integer, String>> dataModelMapSet = new HashSet<Map<Integer, String>>(cacheData.values());
        for (Map map : dataModelMapSet) {
            CacheDataModel cacheDataModel;
            HashSet<CacheDataModel> dataModelSet;
            if (map.isEmpty()) continue;
            if (StringUtils.isEmpty((Object)match)) {
                dataModelSet = new HashSet<CacheDataModel>();
                for (String s : map.values()) {
                    cacheDataModel = MemoryDataHelper.string2CacheDataModel(s);
                    if (cacheDataModel == null || cacheDataModel.isExpired()) continue;
                    dataModelSet.add(cacheDataModel);
                }
            } else {
                dataModelSet = new HashSet();
                for (Integer cacheHashCode : new HashSet(map.keySet())) {
                    cacheDataModel = MemoryDataHelper.string2CacheDataModel((String)map.get(cacheHashCode));
                    if (cacheDataModel == null || cacheDataModel.isExpired()) continue;
                    String methodSignature = cacheDataModel.getMethodSignature();
                    String id = cacheDataModel.getId();
                    if (!match.equals(String.valueOf(cacheHashCode)) && !methodSignature.contains(match) && !id.contains(match)) continue;
                    dataModelSet.add(cacheDataModel);
                }
            }
            for (CacheDataModel dataModel : dataModelSet) {
                if (dataModel == null || dataModel.isExpired()) continue;
                this.filterDataModel(cacheMap, dataModel, null);
            }
        }
        return cacheMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map<String, Object>> wipeCache(String id, String cacheHashCode) {
        HashMap<String, Map<String, Object>> delCacheMap = new HashMap<String, Map<String, Object>>();
        try {
            cacheDataLock.lock();
            HashSet<Integer> removeCacheHashCode = new HashSet<Integer>();
            for (Map<Integer, String> dataModelMap : new HashSet<Map<Integer, String>>(cacheData.values())) {
                if (dataModelMap.isEmpty()) continue;
                Iterator<Integer> iterator = dataModelMap.keySet().iterator();
                while (iterator.hasNext()) {
                    Integer key = iterator.next();
                    CacheDataModel cacheDataModel = MemoryDataHelper.string2CacheDataModel(dataModelMap.get(key));
                    if (cacheDataModel == null || cacheDataModel.isExpired()) continue;
                    String dataModelId = cacheDataModel.getId();
                    String dataModelCacheHashCode = String.valueOf(cacheDataModel.getCacheHashCode());
                    if ((!StringUtils.isEmpty((Object)id) || !StringUtils.isEmpty((Object)cacheHashCode)) && !dataModelId.equals(id) && !dataModelCacheHashCode.equals(cacheHashCode)) continue;
                    cacheDataModel.expired();
                    removeCacheHashCode.add(cacheDataModel.getCacheHashCode());
                    this.filterDataModel(delCacheMap, cacheDataModel, "");
                    iterator.remove();
                }
            }
            if (removeCacheHashCode.size() > 0) {
                Iterator<Map<String, Set<Integer>>> dataExpireInfoValuesIterator = dataExpireInfo.values().iterator();
                while (dataExpireInfoValuesIterator.hasNext()) {
                    Map<String, Set<Integer>> dataExpireInfoValue = dataExpireInfoValuesIterator.next();
                    Iterator<Set<Integer>> dataExpireInfoValueIterator = dataExpireInfoValue.values().iterator();
                    while (dataExpireInfoValueIterator.hasNext()) {
                        Set<Integer> cacheHashCodeInDataExpireInfo = dataExpireInfoValueIterator.next();
                        cacheHashCodeInDataExpireInfo.removeAll(removeCacheHashCode);
                        if (!cacheHashCodeInDataExpireInfo.isEmpty()) continue;
                        dataExpireInfoValueIterator.remove();
                    }
                    if (!dataExpireInfoValue.isEmpty()) continue;
                    dataExpireInfoValuesIterator.remove();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            cacheDataLock.unlock();
        }
        return delCacheMap;
    }

    @Override
    public Map<String, CacheStatisticsModel> getCacheStatistics() {
        return cacheStatistics;
    }

    @Override
    public CacheStatisticsModel getCacheStatistics(String methodSignature) {
        return cacheStatistics.get(methodSignature);
    }

    @Override
    public void setCacheStatistics(String methodSignature, CacheStatisticsModel statisticsModel) {
        cacheStatistics.put(methodSignature, statisticsModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wipeStatistics(CacheStatisticsModel cacheStatisticsModel) {
        Map<String, CacheStatisticsModel> map = cacheStatistics;
        synchronized (map) {
            cacheStatistics.remove(cacheStatisticsModel.getMethodSignature());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, CacheStatisticsModel> wipeStatisticsAll() {
        ConcurrentHashMap<String, CacheStatisticsModel> resultMap = new ConcurrentHashMap<String, CacheStatisticsModel>(cacheStatistics);
        Map<String, CacheStatisticsModel> map = cacheStatistics;
        synchronized (map) {
            cacheStatistics.clear();
        }
        return resultMap;
    }

    private void refreshData(Object proxy, Object data, long expirationTime, String applicationName, DataHelper.ActualDataFunctional actualDataFunctional, boolean nullable, String methodSignature, String argsStr, int cacheHashCode, String id, String remark) {
        executorService.execute(() -> {
            long saveExpirationTime;
            Object saveData;
            if (data != null) {
                saveData = data;
                saveExpirationTime = expirationTime;
            } else {
                saveData = new DataHelper.NullObject();
                saveExpirationTime = actualDataFunctional.getExpirationTime();
                try {
                    saveData = actualDataFunctional.getActualData();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    String uuid = UUID.randomUUID().toString().trim().replaceAll("-", "");
                    logger.info("\n ************* CacheData *************\n ** ----- \u66f4\u65b0\u6570\u636e\u81f3\u5185\u5b58\u53d1\u751f\u5f02\u5e38 ----- **\n \u5f02\u5e38\u4fe1\u606f(UUID=" + uuid + ")\uff1a" + throwable.getMessage() + "\n" + this.printStackTrace(throwable.getStackTrace()) + "\n *************************************");
                }
            }
            if (this.isNotNull(saveData, nullable)) {
                try {
                    cacheDataLock.lock();
                    this.setDataToMemory(applicationName, methodSignature, argsStr, cacheHashCode, saveData != null ? saveData : new DataHelper.NullObject(), saveExpirationTime, id, remark);
                    this.log(String.format("\n ************* CacheData *************\n ** --------- \u5237\u65b0\u7f13\u5b58\u81f3\u5185\u5b58 -------- **\n ** \u6267\u884c\u5bf9\u8c61\uff1a%s\n ** \u65b9\u6cd5\u7b7e\u540d\uff1a%s\n ** \u65b9\u6cd5\u5165\u53c2\uff1a%s\n ** \u7f13\u5b58\u6570\u636e\uff1a%s\n ** \u8fc7\u671f\u65f6\u95f4\uff1a%s\n *************************************", proxy, methodSignature, argsStr, saveData, this.formatDate(saveExpirationTime)));
                }
                finally {
                    cacheDataLock.unlock();
                }
            }
        });
    }

    private static CacheDataModel getDataFromMemory(String methodSignature, Integer cacheHashCode, boolean shared) {
        Map<Integer, String> cacheDataModelMap = cacheData.get(methodSignature);
        if (cacheDataModelMap == null) {
            return null;
        }
        CacheDataModel cacheDataModel = MemoryDataHelper.string2CacheDataModel(cacheDataModelMap.get(cacheHashCode));
        if (!shared) {
            return cacheDataModel;
        }
        return DataHelper.decisionCacheDataModel(cacheDataModel);
    }

    private void setDataToMemory(String applicationName, String methodSignature, String args, int cacheHashCode, Object data, long expireTime, String id, String remark) {
        CacheDataModel cacheDataModel = new CacheDataModel(applicationName, methodSignature, args, cacheHashCode, data, expireTime);
        if (!StringUtils.isEmpty((Object)id)) {
            cacheDataModel.setId(id);
        }
        if (!StringUtils.isEmpty((Object)remark)) {
            cacheDataModel.setRemark(remark);
        }
        this.setDataToMemory(cacheDataModel);
    }

    private void setDataToMemory(CacheDataModel cacheDataModel) {
        String methodSignature = cacheDataModel.getMethodSignature();
        int cacheHashCode = cacheDataModel.getCacheHashCode();
        Map cacheDataModelMap = cacheData.computeIfAbsent(methodSignature, k -> new HashMap());
        cacheDataModelMap.put(cacheHashCode, SerializeUtil.byteArray2String(SerializeUtil.serizlize(cacheDataModel)));
        long expireTime = cacheDataModel.getExpireTime();
        if (expireTime > 0L) {
            Map methodArgsHashCodeMap = dataExpireInfo.computeIfAbsent(expireTime, k -> new HashMap());
            methodArgsHashCodeMap.computeIfAbsent(methodSignature, k -> new HashSet()).add(cacheHashCode);
        }
        cacheDataSize.addAndGet(cacheDataModel.getInstanceSize());
        cacheDataCount.incrementAndGet();
    }

    private void doRemoveData(String methodSignature, Integer cacheHashCode) {
        try {
            CacheDataModel cacheDataModel = MemoryDataHelper.getDataFromMemory(methodSignature, cacheHashCode, false);
            if (cacheDataModel != null && cacheDataModel.isExpired()) {
                this.doRemoveData(cacheDataModel);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("\n ************* CacheData *************\n ** \u79fb\u9664\u6570\u636e\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage() + "\n" + this.printStackTrace(e.getStackTrace()) + "\n *************************************");
        }
    }

    private void doRemoveData(CacheDataModel cacheDataModel) {
        String methodSignature = cacheDataModel.getMethodSignature();
        int cacheHashCode = cacheDataModel.getCacheHashCode();
        this.log(String.format("\n ************* CacheData *************\n ** ------------ \u79fb\u9664\u7f13\u5b58 ---------- **\n ** \u65b9\u6cd5\u7b7e\u540d\uff1a%s\n ** \u65b9\u6cd5\u5165\u53c2\uff1a%s\n *************************************", methodSignature, cacheDataModel.getArgs()));
        Map<Integer, String> cacheDataModelMap = cacheData.get(methodSignature);
        CacheDataModel removed = MemoryDataHelper.string2CacheDataModel(cacheDataModelMap.remove(cacheHashCode));
        if (removed != null) {
            cacheDataSize.addAndGet(-removed.getInstanceSize());
            cacheDataCount.decrementAndGet();
        }
        if (cacheDataModelMap.isEmpty()) {
            cacheData.remove(methodSignature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gc(MemoryUsage memUsage) {
        if (memUsage == null && (memUsage = this.getMemoryOldGenUsage()) == null) {
            logger.error("[methodcache]\u83b7\u53d6\u5185\u5b58\u4fe1\u606f\u5931\u8d25");
            return;
        }
        try {
            cacheDataLock.lock();
            long used = memUsage.getUsed();
            long max = memUsage.getMax();
            long cacheDataSize = this.getCacheDataSize();
            if (!this.isAlarmed(cacheDataSize, used, this.gcThreshold)) {
                logger.info("[methodcache]\u7f13\u5b58\u6570\u636e\u672a\u8fbe\u5230GC\u9608\u503c\uff0c\u672c\u6b21\u4e0d\u56de\u6536\u3002\u6570\u636e\u5927\u5c0f\uff1a" + cacheDataSize + "\uff1b\u5185\u5b58\u4f7f\u7528\uff1a" + used + "\uff1bGC\u9608\u503c=" + this.gcThreshold);
                return;
            }
            this.doGC(cacheDataSize, used, max);
        }
        finally {
            cacheDataLock.unlock();
        }
    }

    private MemoryUsage getMemoryOldGenUsage() {
        List<MemoryPoolMXBean> memPools = ManagementFactory.getMemoryPoolMXBeans();
        if (memPools != null) {
            for (MemoryPoolMXBean mp : memPools) {
                if (!mp.getName().toLowerCase().endsWith("old gen")) continue;
                return mp.getUsage();
            }
        }
        return null;
    }

    private long assertGCCapacity(long size, long used, long max) {
        BigDecimal biSize = new BigDecimal(size);
        BigDecimal biUsed = new BigDecimal(used);
        BigDecimal biMax = new BigDecimal(max);
        if (biSize.compareTo(biUsed.multiply(new BigDecimal(0.9))) >= 0 || biSize.compareTo(biMax.multiply(new BigDecimal(0.4))) >= 0) {
            return biSize.multiply(new BigDecimal(0.3)).longValue();
        }
        return biSize.multiply(new BigDecimal(0.5)).longValue();
    }

    private boolean isAlarmed(long used, long limit, double cordon) {
        BigDecimal bigUsed = new BigDecimal(used);
        BigDecimal bigLimit = new BigDecimal(limit);
        return bigUsed.compareTo(bigLimit.multiply(new BigDecimal(cordon))) >= 0;
    }

    private void doGC(long size, long used, long max) {
        long gcCapacity = this.assertGCCapacity(size, used, max);
        logger.info("[methodcache]\u5f00\u59cbGC\uff1a\u6570\u636e\u6761\u6570=" + this.getCacheDataCount() + "\uff0c\u6570\u636e\u5927\u5c0f=" + size + "\uff0c\u8ba1\u5212\u56de\u6536=" + gcCapacity + "(" + (gcCapacity >> 10) + "K)");
        long startAt = new Date().getTime();
        AssertRemoveData removeData = this.removeData(gcCapacity);
        System.gc();
        logger.info("[methodcache]GC\u5b8c\u6210\uff1a\u6570\u636e\u6761\u6570=" + this.getCacheDataCount() + "\uff0c\u6570\u636e\u5927\u5c0f=" + this.getCacheDataSize() + "\uff0c\u5b9e\u9645\u56de\u6536=" + removeData.getSize() + "(" + (removeData.getSize() >> 10) + "K)\uff0c\u56de\u6536\u6761\u6570=" + removeData.getCount() + "\uff0c\u8017\u65f6=" + (new Date().getTime() - startAt));
    }

    private AssertRemoveData removeData(long targetCapacity) {
        AssertRemoveData removeDataModel = new AssertRemoveData();
        ArrayList<Long> expireTimeStampKeyList = new ArrayList<Long>(dataExpireInfo.keySet());
        if (expireTimeStampKeyList.size() <= 0) {
            return removeDataModel;
        }
        long deleteInstanceSize = 0L;
        expireTimeStampKeyList.sort((l1, l2) -> (int)(l1 - l2));
        Iterator iterator = expireTimeStampKeyList.iterator();
        while (iterator.hasNext()) {
            long eachExpireTimeStamp = (Long)iterator.next();
            Map<String, Set<Integer>> dataExpireInfoMethodSignatureCacheHashCodeMap = dataExpireInfo.get(eachExpireTimeStamp);
            for (String dataExpireInfoMethodSignature : new HashSet<String>(dataExpireInfoMethodSignatureCacheHashCodeMap.keySet())) {
                Map<Integer, String> cacheDataCacheHashCodeModelMap = cacheData.get(dataExpireInfoMethodSignature);
                Set<Integer> dataExpireInfoCacheHashCodeSet = dataExpireInfoMethodSignatureCacheHashCodeMap.get(dataExpireInfoMethodSignature);
                Iterator<Integer> dataExpireInfoCacheHashCodeIterator = dataExpireInfoCacheHashCodeSet.iterator();
                while (dataExpireInfoCacheHashCodeIterator.hasNext()) {
                    Integer dataExpireInfoCacheHashCode = dataExpireInfoCacheHashCodeIterator.next();
                    CacheDataModel cacheDataModel = MemoryDataHelper.string2CacheDataModel(cacheDataCacheHashCodeModelMap.remove(dataExpireInfoCacheHashCode));
                    if (cacheDataModel == null) continue;
                    long instanceSize = cacheDataModel.getInstanceSize();
                    cacheDataSize.addAndGet(-instanceSize);
                    cacheDataCount.decrementAndGet();
                    dataExpireInfoCacheHashCodeIterator.remove();
                    removeDataModel.addCount(1);
                    if (removeDataModel.addSize(instanceSize) < targetCapacity) continue;
                    break;
                }
                if (dataExpireInfoCacheHashCodeSet.isEmpty()) {
                    dataExpireInfoMethodSignatureCacheHashCodeMap.remove(dataExpireInfoMethodSignature);
                }
                if (deleteInstanceSize < targetCapacity) continue;
                break;
            }
            if (dataExpireInfoMethodSignatureCacheHashCodeMap.isEmpty()) {
                dataExpireInfo.remove(eachExpireTimeStamp);
            }
            if (deleteInstanceSize < targetCapacity) continue;
            break;
        }
        return removeDataModel;
    }

    private long getCacheDataSize() {
        return cacheDataSize.get();
    }

    private int getCacheDataCount() {
        return cacheDataCount.get();
    }

    private static CacheDataModel string2CacheDataModel(String str) {
        CacheDataModel cacheDataModel = null;
        if (!StringUtils.isEmpty((Object)str)) {
            cacheDataModel = (CacheDataModel)SerializeUtil.deserialize(SerializeUtil.string2ByteArray(str));
        }
        return cacheDataModel;
    }

    private void log(String info) {
        if (this.methodcacheProperties.isEnableLog()) {
            logger.info(info);
        }
    }

    private class AssertRemoveData {
        private AtomicLong size = new AtomicLong(0L);
        private AtomicInteger count = new AtomicInteger(0);

        AssertRemoveData() {
        }

        long getSize() {
            return this.size.get();
        }

        int getCount() {
            return this.count.get();
        }

        long addSize(long size) {
            return this.size.addAndGet(size);
        }

        int addCount(int count) {
            return this.count.addAndGet(count);
        }
    }
}

