/*
 * Decompiled with CFR 0.152.
 */
package love.kill.methodcache.datahelper.impl;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import love.kill.methodcache.MethodcacheProperties;
import love.kill.methodcache.SpringApplicationProperties;
import love.kill.methodcache.datahelper.CacheDataModel;
import love.kill.methodcache.datahelper.CacheStatisticsModel;
import love.kill.methodcache.datahelper.DataHelper;
import love.kill.methodcache.util.DataUtil;
import love.kill.methodcache.util.RedisUtil;
import love.kill.methodcache.util.SerializeUtil;
import love.kill.methodcache.util.ThreadPoolBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class RedisDataHelper
implements DataHelper {
    private static Logger logger = LoggerFactory.getLogger(RedisDataHelper.class);
    private final MethodcacheProperties methodcacheProperties;
    private String applicationName;
    private RedisUtil redisUtil;
    private static final String REDIS_LOCK_PREFIX = "REDIS_LOCK_";
    private static final ExecutorService executorService = ThreadPoolBuilder.buildDefaultThreadPool();

    public RedisDataHelper(MethodcacheProperties methodcacheProperties, SpringApplicationProperties springApplicationProperties, RedisUtil redisUtil) {
        this.redisUtil = redisUtil;
        this.methodcacheProperties = methodcacheProperties;
        this.applicationName = methodcacheProperties.getName();
        if (StringUtils.isEmpty((Object)this.applicationName)) {
            this.applicationName = springApplicationProperties.getName();
        }
        if (methodcacheProperties.isEnableStatistics()) {
            Executors.newSingleThreadExecutor().execute(() -> this.lambda$new$0(redisUtil, methodcacheProperties));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(Object proxy, Method method, Object[] args, String isolationSignal, boolean refreshData, DataHelper.ActualDataFunctional actualDataFunctional, String id, String remark, boolean nullable, boolean shared) throws Throwable {
        long startTime = new Date().getTime();
        String methodSignature = method.toGenericString();
        int methodSignatureHashCode = methodSignature.hashCode();
        int argsHashCode = DataUtil.getArgsHashCode(args);
        String argsInfo = Arrays.toString(args);
        int cacheHashCode = this.getCacheHashCode(this.applicationName, methodSignatureHashCode, argsHashCode, isolationSignal);
        if (StringUtils.isEmpty((Object)id)) {
            id = String.valueOf(methodSignature.hashCode());
        }
        String cacheKey = this.getCacheKey(this.applicationName, methodSignature, cacheHashCode, id);
        String dataLockKey = RedisDataHelper.getIntactDataLockKey(cacheKey);
        CacheDataModel cacheDataModel = this.getDataFromRedis(cacheKey, false, shared);
        boolean hit = cacheDataModel != null && !cacheDataModel.isExpired();
        this.log(String.format("\n ************* CacheData *************\n ** ------- \u4eceRedis\u83b7\u53d6\u7f13\u5b58 -------- **\n ** \u6267\u884c\u5bf9\u8c61\uff1a%s\n ** \u65b9\u6cd5\u7b7e\u540d\uff1a%s\n ** \u65b9\u6cd5\u5165\u53c2\uff1a%s\n ** \u7f13\u5b58\u547d\u4e2d\uff1a%s\n ** \u8fc7\u671f\u65f6\u95f4\uff1a%s\n *************************************", proxy, methodSignature, argsInfo, hit ? "\u662f" : "\u5426", hit ? this.formatDate(cacheDataModel.getExpireTime()) : "\u65e0"));
        if (!hit) {
            try {
                this.redisUtil.lock(dataLockKey, this.methodcacheProperties.getRedisLockTimeout(), true);
                cacheDataModel = this.getDataFromRedis(cacheKey, false, shared);
            }
            finally {
                this.redisUtil.unlock(dataLockKey);
            }
            hit = cacheDataModel != null && !cacheDataModel.isExpired();
            this.log(String.format("\n ************* CacheData *************\n ** ------ \u4eceRedis\u83b7\u53d6\u7f13\u5b58(\u52a0\u9501) ---- **\n ** \u6267\u884c\u5bf9\u8c61\uff1a%s\n ** \u65b9\u6cd5\u7b7e\u540d\uff1a%s\n ** \u65b9\u6cd5\u5165\u53c2\uff1a%s\n ** \u7f13\u5b58\u547d\u4e2d\uff1a%s\n ** \u8fc7\u671f\u65f6\u95f4\uff1a%s\n *************************************", proxy, methodSignature, argsInfo, hit ? "\u662f" : "\u5426", hit ? this.formatDate(cacheDataModel.getExpireTime()) : "\u65e0"));
            if (!hit) {
                Object actualData;
                try {
                    actualData = actualDataFunctional.getActualData();
                    this.log(String.format("\n ************* CacheData *************\n ** ----------- \u53d1\u8d77\u8bf7\u6c42 ----------- **\n ** \u6267\u884c\u5bf9\u8c61\uff1a%s\n ** \u65b9\u6cd5\u7b7e\u540d\uff1a%s\n ** \u65b9\u6cd5\u5165\u53c2\uff1a%s\n ** \u8fd4\u56de\u6570\u636e\uff1a%s\n *************************************", proxy, methodSignature, argsInfo, actualData));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    String uuid = UUID.randomUUID().toString().trim().replaceAll("-", "");
                    logger.info("\n ************* CacheData *************\n ** ------- \u83b7\u53d6\u6570\u636e\u53d1\u751f\u5f02\u5e38 -------- **\n ** \u5f02\u5e38\u4fe1\u606f(UUID=" + uuid + ")\uff1a" + throwable.getMessage() + "\n" + this.printStackTrace(throwable.getStackTrace()) + "\n *************************************");
                    if (this.methodcacheProperties.isEnableStatistics()) {
                        this.recordStatistics(cacheKey, methodSignature, methodSignatureHashCode, argsInfo, argsHashCode, cacheHashCode, id, remark, false, true, this.printStackTrace(throwable, uuid), startTime, new Date().getTime());
                    }
                    throw throwable;
                }
                if (this.methodcacheProperties.isEnableStatistics()) {
                    this.recordStatistics(cacheKey, methodSignature, methodSignatureHashCode, argsInfo, argsHashCode, cacheHashCode, id, remark, hit, false, "", startTime, new Date().getTime());
                }
                if (this.isNotNull(actualData, nullable)) {
                    long expirationTime = actualDataFunctional.getExpirationTime();
                    this.refreshData(proxy, actualData, expirationTime, this.applicationName, dataLockKey, actualDataFunctional, nullable, cacheKey, methodSignature, argsInfo, cacheHashCode, id, remark);
                }
                return actualData;
            }
        }
        if (this.methodcacheProperties.isEnableStatistics()) {
            this.recordStatistics(cacheKey, methodSignature, methodSignatureHashCode, argsInfo, argsHashCode, cacheHashCode, id, remark, hit, false, "", startTime, new Date().getTime());
        }
        if (refreshData) {
            this.refreshData(proxy, null, -1L, this.applicationName, dataLockKey, actualDataFunctional, nullable, cacheKey, methodSignature, argsInfo, cacheHashCode, id, remark);
        }
        return cacheDataModel.getData();
    }

    @Override
    public Map<String, Map<String, Object>> getCaches(String match) {
        HashMap<String, Map<String, Object>> cacheMap = new HashMap<String, Map<String, Object>>();
        HashSet<String> cacheKeys = new HashSet<String>();
        if (StringUtils.isEmpty((Object)match)) {
            cacheKeys.addAll(this.redisUtil.keys(this.buildCacheKeyPattern(this.applicationName, null, null, null)));
        } else {
            cacheKeys.addAll(this.redisUtil.keys(this.buildCacheKeyPattern(this.applicationName, match, null, null)));
            cacheKeys.addAll(this.redisUtil.keys(this.buildCacheKeyPattern(this.applicationName, null, match, null)));
            cacheKeys.addAll(this.redisUtil.keys(this.buildCacheKeyPattern(this.applicationName, null, null, match)));
        }
        Set<CacheDataModel> dataModelSet = this.getCacheDataModel(cacheKeys);
        for (CacheDataModel dataModel : dataModelSet) {
            if (dataModel == null || dataModel.isExpired()) continue;
            this.filterDataModel(cacheMap, dataModel, null);
        }
        return cacheMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map<String, Object>> wipeCache(String id, String cacheHashCode) {
        HashMap<String, Map<String, Object>> delCacheMap = new HashMap<String, Map<String, Object>>();
        HashSet<String> cacheKeys = new HashSet<String>();
        if (StringUtils.isEmpty((Object)id) && StringUtils.isEmpty((Object)cacheHashCode)) {
            cacheKeys.addAll(this.redisUtil.keys(this.buildCacheKeyPattern(this.applicationName, null, null, null)));
        } else {
            if (!StringUtils.isEmpty((Object)id)) {
                cacheKeys.addAll(this.redisUtil.keys(this.buildCacheKeyPattern(this.applicationName, null, null, id)));
            }
            if (!StringUtils.isEmpty((Object)cacheHashCode)) {
                cacheKeys.addAll(this.redisUtil.keys(this.buildCacheKeyPattern(this.applicationName, null, cacheHashCode, null)));
            }
        }
        Set<CacheDataModel> dataModelSet = this.getCacheDataModel(cacheKeys);
        for (CacheDataModel dataModel : dataModelSet) {
            if (dataModel == null || dataModel.isExpired()) continue;
            String cacheKey = this.getCacheKey(dataModel.getApplicationName(), dataModel.getMethodSignature(), dataModel.getCacheHashCode(), dataModel.getId());
            String redisDataLockKey = RedisDataHelper.getIntactDataLockKey(cacheKey);
            try {
                this.redisUtil.lock(redisDataLockKey, this.methodcacheProperties.getRedisLockTimeout(), true);
                if (!dataModel.isExpired()) {
                    dataModel.expired();
                }
                this.filterDataModel(delCacheMap, dataModel, "");
                this.deleteDataFromRedis(cacheKey);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            finally {
                this.redisUtil.unlock(redisDataLockKey);
            }
        }
        return delCacheMap;
    }

    @Override
    public Map<String, CacheStatisticsModel> getCacheStatistics() {
        return this.getStatisticsFromRedis();
    }

    @Override
    public CacheStatisticsModel getCacheStatistics(String methodSignature) {
        Map<String, CacheStatisticsModel> statisticsFromRedis = this.getStatisticsFromRedis();
        if (statisticsFromRedis == null) {
            return null;
        }
        return statisticsFromRedis.get(methodSignature);
    }

    @Override
    public void setCacheStatistics(String methodSignature, CacheStatisticsModel cacheStatisticsModel) {
        this.setStatisticsToRedis(methodSignature, cacheStatisticsModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wipeStatistics(CacheStatisticsModel statisticsModel) {
        String statisticsLockKey = RedisDataHelper.getIntactCacheStatisticsLockKey(statisticsModel.getCacheKey());
        try {
            this.redisUtil.lock(statisticsLockKey, this.methodcacheProperties.getRedisLockTimeout(), true);
            this.deleteStatisticsFromRedis(statisticsModel.getMethodSignature());
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.redisUtil.unlock(statisticsLockKey);
        }
    }

    @Override
    public Map<String, CacheStatisticsModel> wipeStatisticsAll() {
        Map<String, CacheStatisticsModel> resultMap = this.getCacheStatistics();
        this.deleteStatisticsAllFromRedis();
        return resultMap;
    }

    private void refreshData(Object proxy, Object data, long expirationTime, String applicationName, String redisDataLockKey, DataHelper.ActualDataFunctional actualDataFunctional, boolean nullable, String cacheKey, String methodSignature, String argsStr, int cacheHashCode, String id, String remark) {
        executorService.execute(() -> {
            long saveExpirationTime;
            Object saveData;
            if (data != null) {
                saveData = data;
                saveExpirationTime = expirationTime;
            } else {
                saveData = new DataHelper.NullObject();
                saveExpirationTime = actualDataFunctional.getExpirationTime();
                try {
                    saveData = actualDataFunctional.getActualData();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    logger.info("\n ************* CacheData *************\n ** ---- \u66f4\u65b0\u6570\u636e\u81f3Redis\u53d1\u751f\u5f02\u5e38 ---- **\n ** \u5f02\u5e38\u4fe1\u606f\uff1a" + throwable.getMessage() + "\n *************************************");
                }
            }
            if (this.isNotNull(saveData, nullable)) {
                try {
                    this.redisUtil.lock(redisDataLockKey, this.methodcacheProperties.getRedisLockTimeout(), true);
                    this.log(String.format("\n ************* CacheData *************\n ** -------- \u5237\u65b0\u7f13\u5b58\u81f3Redis ------- **\n \u6267\u884c\u5bf9\u8c61\uff1a%s\n \u65b9\u6cd5\u7b7e\u540d\uff1a%s\n \u65b9\u6cd5\u5165\u53c2\uff1a%s\n \u7f13\u5b58\u6570\u636e\uff1a%s\n \u8fc7\u671f\u65f6\u95f4\uff1a%s\n *************************************", proxy, methodSignature, argsStr, saveData, this.formatDate(saveExpirationTime)));
                    this.setDataToRedis(applicationName, cacheKey, methodSignature, argsStr, cacheHashCode, saveData != null ? saveData : new DataHelper.NullObject(), saveExpirationTime, id, remark);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    this.redisUtil.unlock(redisDataLockKey);
                }
            }
        });
    }

    private String buildCacheKeyPattern(String applicationName, String methodSignature, String cacheHashCode, String id) {
        String cacheKeyPattern = "%{methodSignature}%@%{cacheHashCode}%@%{id}%";
        if (!StringUtils.isEmpty((Object)applicationName)) {
            cacheKeyPattern = applicationName + "@" + cacheKeyPattern;
        }
        cacheKeyPattern = "METHOD_CACHE_DATA@" + cacheKeyPattern;
        cacheKeyPattern = !StringUtils.isEmpty((Object)methodSignature) ? cacheKeyPattern.replace("%{methodSignature}%", "*" + methodSignature + "*") : cacheKeyPattern.replace("%{methodSignature}%", "*");
        cacheKeyPattern = !StringUtils.isEmpty((Object)cacheHashCode) ? cacheKeyPattern.replace("%{cacheHashCode}%", "*" + cacheHashCode + "*") : cacheKeyPattern.replace("%{cacheHashCode}%", "*");
        cacheKeyPattern = !StringUtils.isEmpty((Object)id) ? cacheKeyPattern.replace("%{id}%", id) : cacheKeyPattern.replace("%{id}%", "*");
        return cacheKeyPattern;
    }

    private CacheDataModel getDataFromRedis(String cacheKey, boolean intactKeyFlag, boolean shared) {
        String key = intactKeyFlag ? cacheKey : RedisDataHelper.getIntactCacheDataKey(cacheKey);
        Object objectByteString = this.redisUtil.get(key);
        if (!(objectByteString instanceof String)) {
            return null;
        }
        Object dataModel = SerializeUtil.deserialize(SerializeUtil.string2ByteArray((String)objectByteString));
        if (!(dataModel instanceof CacheDataModel)) {
            return null;
        }
        CacheDataModel cacheDataModel = (CacheDataModel)dataModel;
        if (!shared) {
            return cacheDataModel;
        }
        return DataHelper.decisionCacheDataModel(cacheDataModel);
    }

    private void setDataToRedis(String applicationName, String cacheKey, String methodSignature, String argStr, int cacheHashCode, Object data, long expireTimeStamp, String id, String remark) {
        CacheDataModel cacheDataModel = new CacheDataModel(applicationName, methodSignature, argStr, cacheHashCode, data, expireTimeStamp);
        if (!StringUtils.isEmpty((Object)id)) {
            cacheDataModel.setId(id);
        }
        if (!StringUtils.isEmpty((Object)remark)) {
            cacheDataModel.setRemark(remark);
        }
        this.setDataToRedis(cacheKey, cacheDataModel, expireTimeStamp - new Date().getTime());
    }

    private Map<String, CacheStatisticsModel> getStatisticsFromRedis() {
        HashMap<String, CacheStatisticsModel> resultMap = new HashMap<String, CacheStatisticsModel>();
        List<Object> objects = this.redisUtil.hValues("METHOD_CACHE_STATISTICS");
        if (objects == null) {
            return null;
        }
        for (Object object : objects) {
            Object model;
            if (!(object instanceof String) || !((model = SerializeUtil.deserialize(SerializeUtil.string2ByteArray((String)object))) instanceof CacheStatisticsModel)) continue;
            CacheStatisticsModel statisticsModel = (CacheStatisticsModel)model;
            resultMap.put(statisticsModel.getMethodSignature(), statisticsModel);
        }
        return resultMap;
    }

    private void deleteStatisticsAllFromRedis() {
        this.redisUtil.del("METHOD_CACHE_STATISTICS");
    }

    private Set<CacheDataModel> getCacheDataModel(Set<String> cacheKeys) {
        HashSet<CacheDataModel> dataModelSet = new HashSet<CacheDataModel>();
        if (cacheKeys.size() <= 0) {
            return dataModelSet;
        }
        CountDownLatch countDownLatch = new CountDownLatch(cacheKeys.size());
        for (String cacheKey : cacheKeys) {
            executorService.execute(() -> {
                try {
                    dataModelSet.add(this.getDataFromRedis(cacheKey, true, false));
                }
                catch (Exception e) {
                    logger.error("\u4eceRedis\u6279\u91cf\u67e5\u8be2\u7f13\u5b58\u51fa\u73b0\u5f02\u5e38\uff1a" + e.getMessage());
                }
                finally {
                    countDownLatch.countDown();
                }
            });
        }
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            logger.error("\u67e5\u8be2\u7f13\u5b58\u88ab\u4e2d\u65ad\uff1a" + e.getMessage());
        }
        return dataModelSet;
    }

    private static String getIntactDataLockKey(String key) {
        return "REDIS_LOCK_METHOD_CACHE_DATA@" + key;
    }

    private static String getIntactCacheDataKey(String key) {
        return "METHOD_CACHE_DATA@" + key;
    }

    private static String getIntactCacheStatisticsLockKey(String key) {
        return "REDIS_LOCK_METHOD_CACHE_STATISTICS@" + key;
    }

    private void setDataToRedis(String cacheKey, CacheDataModel cacheDataModel, long timeout) {
        this.redisUtil.set(RedisDataHelper.getIntactCacheDataKey(cacheKey), SerializeUtil.byteArray2String(SerializeUtil.serizlize(cacheDataModel)), timeout);
    }

    private void deleteDataFromRedis(String cacheKey) {
        this.redisUtil.del(RedisDataHelper.getIntactCacheDataKey(cacheKey));
    }

    private void setStatisticsToRedis(String methodSignature, CacheStatisticsModel cacheStatisticsModel) {
        this.redisUtil.hset("METHOD_CACHE_STATISTICS", methodSignature, SerializeUtil.byteArray2String(SerializeUtil.serizlize(cacheStatisticsModel)));
    }

    private void deleteStatisticsFromRedis(String methodSignature) {
        this.redisUtil.hdel("METHOD_CACHE_STATISTICS", methodSignature);
    }

    private void log(String info) {
        if (this.methodcacheProperties.isEnableLog()) {
            logger.info(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private /* synthetic */ void lambda$new$0(RedisUtil redisUtil, MethodcacheProperties methodcacheProperties) {
        while (true) {
            try {
                while (true) lbl-1000:
                // 3 sources

                {
                    statisticsNode = (DataHelper.CacheStatisticsNode)RedisDataHelper.cacheStatisticsInfoQueue.take();
                    cacheKey = statisticsNode.getCacheKey();
                    statisticsLockKey = RedisDataHelper.getIntactCacheStatisticsLockKey(cacheKey);
                    try {
                        redisUtil.lock(statisticsLockKey, methodcacheProperties.getRedisLockTimeout(), true);
                        methodSignature = statisticsNode.getMethodSignature();
                        statisticsModel = this.increaseStatistics(this.getCacheStatistics(methodSignature), statisticsNode);
                        this.setCacheStatistics(methodSignature, statisticsModel);
                    }
                    finally {
                        redisUtil.unlock(statisticsLockKey);
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            ** GOTO lbl-1000
            break;
        }
    }
}

