/*
 * Decompiled with CFR 0.152.
 */
package love.kill.methodcache.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;

public class AnnotationUtil {
    public static <T extends Annotation> T getAnnotation(Method method, Class<?> proxy, Class<T> annotationClass) {
        Object annotation = method.getDeclaredAnnotation(annotationClass);
        if (annotation != null) {
            return annotation;
        }
        annotation = AnnotationUtils.findAnnotation((Method)method, annotationClass);
        if (annotation != null) {
            return annotation;
        }
        if (proxy == null) {
            return null;
        }
        for (Method proxyMethod : proxy.getMethods()) {
            T targetAnnotation = AnnotationUtil.getAnnotation(proxyMethod, null, annotationClass);
            if (targetAnnotation == null || !AnnotationUtil.theSameAs(method, proxyMethod)) continue;
            return targetAnnotation;
        }
        return annotation;
    }

    private static boolean theSameAs(Method method, Method another) {
        if (!method.getName().equals(another.getName())) {
            return false;
        }
        if (method.getParameterCount() != another.getParameterCount()) {
            return false;
        }
        Class<?>[] subParams = method.getParameterTypes();
        Class<?>[] superParams = another.getParameterTypes();
        for (int i = 0; i < subParams.length; ++i) {
            if (subParams[i].equals(superParams[i])) continue;
            return false;
        }
        if (!method.getReturnType().equals(another.getReturnType())) {
            return method.getReturnType().isAssignableFrom(another.getReturnType());
        }
        return true;
    }
}

