/*
 * Decompiled with CFR 0.152.
 */
package love.kill.methodcache.util;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;

public class DataUtil {
    public static int getArgsHashCode(Object[] args) {
        LinkedHashMap<String, Integer> fieldHash = new LinkedHashMap<String, Integer>();
        try {
            StringBuilder integration = new StringBuilder();
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                String key = "arg" + i;
                Integer value = DataUtil.doGetHash(arg);
                fieldHash.put(key, value);
                integration.append(key).append("=").append(value).append("&");
            }
            if (integration.toString().length() > 0) {
                integration.deleteCharAt(integration.lastIndexOf("&"));
                fieldHash.put("aggregation", DataUtil.doGetHash(integration.toString()));
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return fieldHash.hashCode();
    }

    private static int doGetHash(Object arg) throws IllegalAccessException {
        Field[] declaredFields;
        if (arg == null) {
            return 0;
        }
        if (DataUtil.isPrimitive(arg.getClass())) {
            return Objects.hash(arg);
        }
        for (Field field : declaredFields = arg.getClass().getDeclaredFields()) {
            field.setAccessible(true);
        }
        LinkedList<Field> fieldList = new LinkedList<Field>(Arrays.asList(declaredFields));
        fieldList.sort(Comparator.comparing(Field::toString));
        LinkedHashMap<String, Integer> fieldHash = new LinkedHashMap<String, Integer>();
        for (Field field : fieldList) {
            fieldHash.put(field.toString(), DataUtil.doGetFieldHash(field, arg));
        }
        return Objects.hash(fieldHash);
    }

    private static int doGetFieldHash(Field field, Object object) throws IllegalAccessException {
        Field[] declaredFields;
        if (object == null) {
            return 0;
        }
        Class<Collection> typeClass = field.getType();
        Object fieldObject = field.get(object);
        if (DataUtil.isPrimitive(typeClass) || typeClass.isAssignableFrom(Collection.class)) {
            return Objects.hash(fieldObject);
        }
        for (Field innerField : declaredFields = typeClass.getDeclaredFields()) {
            innerField.setAccessible(true);
        }
        LinkedList<Field> fieldList = new LinkedList<Field>(Arrays.asList(declaredFields));
        fieldList.sort(Comparator.comparing(Field::toString));
        LinkedHashMap<String, Integer> fieldHash = new LinkedHashMap<String, Integer>();
        for (Field innerField : fieldList) {
            fieldHash.put(innerField.toString(), DataUtil.doGetFieldHash(innerField, fieldObject));
        }
        return Objects.hash(fieldHash);
    }

    private static boolean isPrimitive(Class clazz) {
        return clazz.isPrimitive() || DataUtil.isInternal(clazz);
    }

    private static boolean isInternal(Class clazz) {
        return DataUtil.isMap(clazz) || DataUtil.isCollection(clazz) || String.class == clazz || Short.class == clazz || Integer.class == clazz || Long.class == clazz || Float.class == clazz || Double.class == clazz || Character.class == clazz || Boolean.class == clazz;
    }

    private static boolean isMap(Class clazz) {
        return Map.class.isAssignableFrom(clazz);
    }

    private static boolean isCollection(Class clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public static int hash(Object key) {
        int n;
        if (key == null) {
            n = 0;
        } else {
            int h = key.hashCode();
            n = h ^ h >>> 16;
        }
        return n;
    }
}

