/*
 * Decompiled with CFR 0.152.
 */
package love.kill.methodcache.util;

import java.util.Collections;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisLockUtil {
    private static final String REDIS_RESULT_OK = "OK";
    private static final String REDIS_RESULT_REENTRANT = "REENTRANT";
    private static final String REDIS_LOCK_PREFIX = "REDIS_LOCK_";
    private static RedisSerializer<?> argsSerializer = new StringRedisSerializer();
    private static RedisSerializer<String> resultSerializer = new StringRedisSerializer();
    private static final String reentrantLockScript = "if (redis.call('exists', KEYS[1]) == 0) then redis.call('hset', KEYS[1], ARGV[1], 1); redis.call('pexpire', KEYS[1], ARGV[2]); return 'OK'; end; if (redis.call('hexists', KEYS[1], ARGV[1]) == 1) then redis.call('hincrby', KEYS[1], ARGV[1], 1); redis.call('pexpire', KEYS[1], ARGV[2]); return 'REENTRANT'; else return 'FALSE'; end; ";
    private static final String releaseLockScript = "if (redis.call('exists', KEYS[1]) == 0) then return 'NON-EXISTENT'; end;if (redis.call('hexists', KEYS[1], ARGV[1]) == 0) then return 'NOT-BELONG';end; local counter = redis.call('hincrby', KEYS[1], ARGV[1], -1); if (counter > 0) then return 'REENTRANT'; else redis.call('del', KEYS[1]); return 'OK'; end; ";

    static boolean lock(RedisTemplate redisTemplate, String key, String value, int expireTime) {
        DefaultRedisScript defaultRedisScript = new DefaultRedisScript();
        defaultRedisScript.setScriptText(reentrantLockScript);
        defaultRedisScript.setResultType(String.class);
        String result = (String)redisTemplate.execute((RedisScript)defaultRedisScript, argsSerializer, resultSerializer, Collections.singletonList(REDIS_LOCK_PREFIX + key), new Object[]{value, String.valueOf(expireTime)});
        return REDIS_RESULT_OK.equals(result) || REDIS_RESULT_REENTRANT.equals(result);
    }

    static boolean unlock(RedisTemplate redisTemplate, String key, String value) {
        DefaultRedisScript defaultRedisScript = new DefaultRedisScript();
        defaultRedisScript.setScriptText(releaseLockScript);
        defaultRedisScript.setResultType(String.class);
        String result = (String)redisTemplate.execute((RedisScript)defaultRedisScript, argsSerializer, resultSerializer, Collections.singletonList(REDIS_LOCK_PREFIX + key), new Object[]{value});
        return REDIS_RESULT_OK.equals(result) || REDIS_RESULT_REENTRANT.equals(result);
    }
}

