/*
 * Decompiled with CFR 0.152.
 */
package love.kill.methodcache.util;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import love.kill.methodcache.util.RedisLockUtil;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.StringUtils;

public class RedisUtil {
    private static final ThreadLocal<ConcurrentHashMap<String, String>> threadLocal = new ThreadLocal();
    private RedisTemplate redisTemplate;

    public RedisUtil(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public Object get(String key) {
        return key == null ? null : this.redisTemplate.opsForValue().get((Object)key);
    }

    public void set(String key, Object value) {
        try {
            this.redisTemplate.opsForValue().set((Object)key, value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void set(String key, Object value, long timeout) {
        try {
            if (timeout > 0L) {
                this.redisTemplate.opsForValue().set((Object)key, value, timeout, TimeUnit.MILLISECONDS);
            } else {
                this.set(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Set<String> keys(String pattern) {
        if (StringUtils.isEmpty((Object)pattern)) {
            pattern = "*";
        }
        try {
            return this.redisTemplate.keys((Object)pattern);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new HashSet<String>();
        }
    }

    public boolean del(String key) {
        try {
            Boolean b = this.redisTemplate.delete((Object)key);
            if (b == null) {
                return false;
            }
            return b;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public Object hget(String key, String field) {
        try {
            return key == null || field == null ? null : this.redisTemplate.opsForHash().get((Object)key, (Object)field);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void hset(String key, String field, String value) {
        try {
            this.redisTemplate.opsForHash().put((Object)key, (Object)field, (Object)value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void hdel(String key, String field) {
        try {
            this.redisTemplate.opsForHash().delete((Object)key, new Object[]{field});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List<Object> hValues(String key) {
        try {
            return key == null ? null : this.redisTemplate.opsForHash().values((Object)key);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean lock(String key, int expireTime) {
        return RedisLockUtil.lock(this.redisTemplate, key, this.getLockValue(key), expireTime);
    }

    public boolean lock(String key, int expireTime, boolean block) throws InterruptedException {
        if (block) {
            while (!this.lock(key, expireTime)) {
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new InterruptedException();
            }
            return true;
        }
        return this.lock(key, expireTime);
    }

    public boolean unlock(String key) {
        return RedisLockUtil.unlock(this.redisTemplate, key, this.getLockValue(key));
    }

    private String getLockValue(String key) {
        String value;
        ConcurrentHashMap<String, String> kvMap = threadLocal.get();
        if (kvMap == null) {
            kvMap = new ConcurrentHashMap();
            threadLocal.set(kvMap);
        }
        if ((value = kvMap.get(key)) == null || StringUtils.isEmpty((Object)value)) {
            value = UUID.randomUUID().toString() + "@" + String.valueOf(Thread.currentThread().getId());
            kvMap.put(key, value);
        }
        return value;
    }
}

