package ltd.dolink.adapter.datatype;


import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;

import java.util.List;

public interface Binder<T, VH extends RecyclerView.ViewHolder> {

    T getItem(int position);

    int getItemViewType(int position);

    long getItemId(int position);


    void onViewRecycled(@NonNull VH holder);


    boolean onFailedToRecycleView(@NonNull VH holder);

    void onViewAttachedToWindow(@NonNull VH holder);

    void onViewDetachedFromWindow(@NonNull VH holder);

    @NonNull
    VH onCreateViewHolder(@NonNull ViewGroup parent, int viewType);

    void onBindViewHolder(@NonNull VH holder, int position);


    void onBindViewHolder(@NonNull VH holder, int position, @NonNull List<Object> payloads);

}
