package ltd.dolink.adapter.datatype;


import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView.Adapter;
import androidx.recyclerview.widget.RecyclerView.ViewHolder;

import java.util.List;
import java.util.Objects;

public abstract class DataTypeAdapter extends Adapter<ViewHolder> {

    @NonNull
    private final DataTypeBinder dataTypeBinder;

    protected DataTypeAdapter(@NonNull DataTypeBinder dataTypeBinder) {
        Objects.requireNonNull(dataTypeBinder);
        this.dataTypeBinder = dataTypeBinder;
        this.dataTypeBinder.bind(this);
    }

    @NonNull
    protected DataTypeBinder getDataTypeBinder() {
        return dataTypeBinder;
    }

    public final <T> void link(@NonNull Class<T> dataType, @NonNull Linker<T> linker) {
        this.dataTypeBinder.link(dataType, linker);
    }

    public abstract Object getItem(int position);

    @Override
    public int getItemViewType(int position) {
        return dataTypeBinder.getItemViewType(position);
    }

    @Override
    public long getItemId(int position) {
        return dataTypeBinder.getItemId(position);
    }

    @Override
    public int getItemCount() {
        return dataTypeBinder.getItemCount();
    }

    @Override
    public void onViewRecycled(@NonNull ViewHolder holder) {
        dataTypeBinder.onViewRecycled(holder);
    }

    @Override
    public boolean onFailedToRecycleView(@NonNull ViewHolder holder) {
        return dataTypeBinder.onFailedToRecycleView(holder);
    }

    @Override
    public void onViewAttachedToWindow(@NonNull ViewHolder holder) {
        dataTypeBinder.onViewAttachedToWindow(holder);
    }

    @Override
    public void onViewDetachedFromWindow(@NonNull ViewHolder holder) {
        dataTypeBinder.onViewDetachedFromWindow(holder);
    }

    @NonNull
    @Override
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return dataTypeBinder.onCreateViewHolder(parent, viewType);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position) {
        dataTypeBinder.onBindViewHolder(holder, position);
    }

    @Override
    public void onBindViewHolder(@NonNull ViewHolder holder, int position, @NonNull List<Object> payloads) {
        dataTypeBinder.onBindViewHolder(holder, position, payloads);
    }

}
