package ltd.dolink.adapter.datatype;


import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.RecyclerView.ViewHolder;

import java.util.List;

public abstract class ItemViewBinder<T, VH extends RecyclerView.ViewHolder> implements Binder<T, VH> {

    @NonNull
    private ItemViewLinker<T> itemViewLinker;

    public ItemViewBinder() {
    }

    public Notify getNotify() {
        return itemViewLinker.getItemViewNotify();
    }

    void setItemViewLinker(@NonNull ItemViewLinker<T> itemViewLinker) {
        this.itemViewLinker = itemViewLinker;
    }

    @Override
    public final T getItem(int position) {
        return itemViewLinker.getItem(position);
    }

    @Override
    public final long getItemId(int position) {
        return itemViewLinker.getItemId(position);
    }

    @Override
    public final int getItemViewType(int position) {
        return itemViewLinker.getViewType(position, getItem(position));
    }

    @Override
    public void onViewAttachedToWindow(@NonNull VH holder) {

    }

    @Override
    public void onViewDetachedFromWindow(@NonNull VH holder) {

    }

    @Override
    public void onViewRecycled(@NonNull VH holder) {

    }

    @Override
    public boolean onFailedToRecycleView(@NonNull VH holder) {
        return false;
    }

    public void onBindViewEvents(@NonNull VH holder, int viewType) {
    }

    @Override
    public final void onBindViewHolder(@NonNull VH holder, int position) {
        onBindViewHolder(holder, position, getItem(position));
    }

    @Override
    public final void onBindViewHolder(@NonNull VH holder, int position, @NonNull List<Object> payloads) {
        onBindViewHolder(holder, position, payloads, getItem(position));
    }

    public abstract void onBindViewHolder(@NonNull VH holder, int position, @NonNull T data);

    public void onBindViewHolder(@NonNull VH holder, int position, @NonNull List<Object> payloads, T data) {
        onBindViewHolder(holder, position, data);
    }

    public interface Lookup {

        <T> void link(@NonNull Class<T> dataType, @NonNull ItemViewLinker<T> itemViewLinker);

        ItemViewBinder<Object, ViewHolder> findFromPosition(int position, @NonNull Object data);

        ItemViewBinder<Object, ViewHolder> findFromViewType(int viewType);


    }

}
