package ltd.dolink.adapter.datatype;

import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView.ViewHolder;

import java.util.Objects;

class ItemViewLinker<T> implements Linker<T> {
    private final Class<T> dataType;
    @NonNull
    private final Linker<T> linker;
    @NonNull
    private final DataTypeBinder dataTypeBinder;

    public ItemViewLinker(@NonNull Class<T> dataType, @NonNull Linker<T> linker, @NonNull DataTypeBinder dataTypeBinder) {
        Objects.requireNonNull(dataType);
        Objects.requireNonNull(linker);
        Objects.requireNonNull(dataTypeBinder);
        this.dataType = dataType;
        this.linker = linker;
        this.dataTypeBinder = dataTypeBinder;
    }

    @NonNull
    public Notify getItemViewNotify() {
        return dataTypeBinder.getItemViewNotify();
    }

    @NonNull
    public Class<T> getDataType() {
        return dataType;
    }


    public final T getItem(int position) {
        @SuppressWarnings("unchecked") T data = (T) dataTypeBinder.getItem(position);
        return data;
    }

    @Override
    public final long getItemId(int position) {
        return linker.getItemId(position);
    }


    @Override
    public final int getViewType(int position, T data) {
        return linker.getViewType(position, data);
    }

    @NonNull
    @Override
    public ItemViewBinder<Object, ViewHolder> getViewBinder(int position, T data) {
        return linker.getViewBinder(position, data);
    }
}
