package ltd.dolink.adapter.datatype;

import androidx.annotation.NonNull;

import java.util.List;
import java.util.Objects;


public class ListDataTypeAdapter<T> extends DataTypeAdapter {
    public ListDataTypeAdapter(@NonNull DataTypeBinder dataTypeBinder) {
        super(dataTypeBinder);
    }

    public ListDataTypeAdapter(@NonNull List<T> data) {
        this(new ListDataTypeBinder<>(data));
    }

    public ListDataTypeAdapter(@NonNull T[] data) {
        this(new ArrayDataTypeBinder<>(data));
    }

    @Override
    public T getItem(int position) {
        return (T) getDataTypeBinder().getItem(position);
    }

}

class ListDataTypeBinder<T> extends DataTypeBinder {
    private final List<T> data;

    ListDataTypeBinder(List<T> data) {
        super();
        Objects.requireNonNull(data);
        this.data = data;
    }

    @Override
    public T getItem(int position) {
        return data.get(position);
    }

    @Override
    public int getItemCount() {
        return data.size();
    }
}

class ArrayDataTypeBinder<T> extends DataTypeBinder {
    private final T[] data;

    ArrayDataTypeBinder(T[] data) {
        super();
        Objects.requireNonNull(data);
        this.data = data;
    }

    @Override
    public T getItem(int position) {
        return data[position];
    }

    @Override
    public int getItemCount() {
        return data.length;
    }
}