/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.redis.properties;

import java.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="project.redis")
public class RedisConfigProperties {
    public static final String PREFIX = "project.redis";
    private boolean enabled = true;
    private Duration delay = Duration.ofMinutes(10L);
    @Value(value="${spring.application.name:default}")
    private String name;
    @Value(value="${spring.application.host:}")
    private String applicationHost;
    @Value(value="${server.port:8080}")
    private int applicationPort;
    private String cacheKey;
    private Duration cacheTtl = Duration.ofMinutes(30L);
    private Duration waitTime = Duration.ofSeconds(55L);
    private EventWatch eventWatch;
    private ConfigWatch configWatch;
    private ServiceWatch serviceWatch;

    public boolean isEnabled() {
        return this.enabled;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public String getName() {
        return this.name;
    }

    public String getApplicationHost() {
        return this.applicationHost;
    }

    public int getApplicationPort() {
        return this.applicationPort;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public Duration getCacheTtl() {
        return this.cacheTtl;
    }

    public Duration getWaitTime() {
        return this.waitTime;
    }

    public EventWatch getEventWatch() {
        return this.eventWatch;
    }

    public ConfigWatch getConfigWatch() {
        return this.configWatch;
    }

    public ServiceWatch getServiceWatch() {
        return this.serviceWatch;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setDelay(Duration delay) {
        this.delay = delay;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setApplicationHost(String applicationHost) {
        this.applicationHost = applicationHost;
    }

    public void setApplicationPort(int applicationPort) {
        this.applicationPort = applicationPort;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public void setCacheTtl(Duration cacheTtl) {
        this.cacheTtl = cacheTtl;
    }

    public void setWaitTime(Duration waitTime) {
        this.waitTime = waitTime;
    }

    public void setEventWatch(EventWatch eventWatch) {
        this.eventWatch = eventWatch;
    }

    public void setConfigWatch(ConfigWatch configWatch) {
        this.configWatch = configWatch;
    }

    public void setServiceWatch(ServiceWatch serviceWatch) {
        this.serviceWatch = serviceWatch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedisConfigProperties)) {
            return false;
        }
        RedisConfigProperties other = (RedisConfigProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getApplicationPort() != other.getApplicationPort()) {
            return false;
        }
        Duration this$delay = this.getDelay();
        Duration other$delay = other.getDelay();
        if (this$delay == null ? other$delay != null : !((Object)this$delay).equals(other$delay)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$applicationHost = this.getApplicationHost();
        String other$applicationHost = other.getApplicationHost();
        if (this$applicationHost == null ? other$applicationHost != null : !this$applicationHost.equals(other$applicationHost)) {
            return false;
        }
        String this$cacheKey = this.getCacheKey();
        String other$cacheKey = other.getCacheKey();
        if (this$cacheKey == null ? other$cacheKey != null : !this$cacheKey.equals(other$cacheKey)) {
            return false;
        }
        Duration this$cacheTtl = this.getCacheTtl();
        Duration other$cacheTtl = other.getCacheTtl();
        if (this$cacheTtl == null ? other$cacheTtl != null : !((Object)this$cacheTtl).equals(other$cacheTtl)) {
            return false;
        }
        Duration this$waitTime = this.getWaitTime();
        Duration other$waitTime = other.getWaitTime();
        if (this$waitTime == null ? other$waitTime != null : !((Object)this$waitTime).equals(other$waitTime)) {
            return false;
        }
        EventWatch this$eventWatch = this.getEventWatch();
        EventWatch other$eventWatch = other.getEventWatch();
        if (this$eventWatch == null ? other$eventWatch != null : !((Object)this$eventWatch).equals(other$eventWatch)) {
            return false;
        }
        ConfigWatch this$configWatch = this.getConfigWatch();
        ConfigWatch other$configWatch = other.getConfigWatch();
        if (this$configWatch == null ? other$configWatch != null : !((Object)this$configWatch).equals(other$configWatch)) {
            return false;
        }
        ServiceWatch this$serviceWatch = this.getServiceWatch();
        ServiceWatch other$serviceWatch = other.getServiceWatch();
        return !(this$serviceWatch == null ? other$serviceWatch != null : !((Object)this$serviceWatch).equals(other$serviceWatch));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RedisConfigProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getApplicationPort();
        Duration $delay = this.getDelay();
        result = result * 59 + ($delay == null ? 43 : ((Object)$delay).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $applicationHost = this.getApplicationHost();
        result = result * 59 + ($applicationHost == null ? 43 : $applicationHost.hashCode());
        String $cacheKey = this.getCacheKey();
        result = result * 59 + ($cacheKey == null ? 43 : $cacheKey.hashCode());
        Duration $cacheTtl = this.getCacheTtl();
        result = result * 59 + ($cacheTtl == null ? 43 : ((Object)$cacheTtl).hashCode());
        Duration $waitTime = this.getWaitTime();
        result = result * 59 + ($waitTime == null ? 43 : ((Object)$waitTime).hashCode());
        EventWatch $eventWatch = this.getEventWatch();
        result = result * 59 + ($eventWatch == null ? 43 : ((Object)$eventWatch).hashCode());
        ConfigWatch $configWatch = this.getConfigWatch();
        result = result * 59 + ($configWatch == null ? 43 : ((Object)$configWatch).hashCode());
        ServiceWatch $serviceWatch = this.getServiceWatch();
        result = result * 59 + ($serviceWatch == null ? 43 : ((Object)$serviceWatch).hashCode());
        return result;
    }

    public String toString() {
        return "RedisConfigProperties(enabled=" + this.isEnabled() + ", delay=" + this.getDelay() + ", name=" + this.getName() + ", applicationHost=" + this.getApplicationHost() + ", applicationPort=" + this.getApplicationPort() + ", cacheKey=" + this.getCacheKey() + ", cacheTtl=" + this.getCacheTtl() + ", waitTime=" + this.getWaitTime() + ", eventWatch=" + this.getEventWatch() + ", configWatch=" + this.getConfigWatch() + ", serviceWatch=" + this.getServiceWatch() + ")";
    }

    public class ServiceWatch {
        private boolean enabled = true;
        private String keyPrefix = "service:";
        private Duration delay = Duration.ofMinutes(100L);

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getKeyPrefix() {
            return this.keyPrefix;
        }

        public Duration getDelay() {
            return this.delay;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        public void setDelay(Duration delay) {
            this.delay = delay;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServiceWatch)) {
                return false;
            }
            ServiceWatch other = (ServiceWatch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$keyPrefix = this.getKeyPrefix();
            String other$keyPrefix = other.getKeyPrefix();
            if (this$keyPrefix == null ? other$keyPrefix != null : !this$keyPrefix.equals(other$keyPrefix)) {
                return false;
            }
            Duration this$delay = this.getDelay();
            Duration other$delay = other.getDelay();
            return !(this$delay == null ? other$delay != null : !((Object)this$delay).equals(other$delay));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServiceWatch;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $keyPrefix = this.getKeyPrefix();
            result = result * 59 + ($keyPrefix == null ? 43 : $keyPrefix.hashCode());
            Duration $delay = this.getDelay();
            result = result * 59 + ($delay == null ? 43 : ((Object)$delay).hashCode());
            return result;
        }

        public String toString() {
            return "RedisConfigProperties.ServiceWatch(enabled=" + this.isEnabled() + ", keyPrefix=" + this.getKeyPrefix() + ", delay=" + this.getDelay() + ")";
        }
    }

    public class ConfigWatch {
        private boolean enabled = true;
        private String keyPrefix = "config:";
        private Duration delay = Duration.ofMillis(100L);

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getKeyPrefix() {
            return this.keyPrefix;
        }

        public Duration getDelay() {
            return this.delay;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        public void setDelay(Duration delay) {
            this.delay = delay;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConfigWatch)) {
                return false;
            }
            ConfigWatch other = (ConfigWatch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$keyPrefix = this.getKeyPrefix();
            String other$keyPrefix = other.getKeyPrefix();
            if (this$keyPrefix == null ? other$keyPrefix != null : !this$keyPrefix.equals(other$keyPrefix)) {
                return false;
            }
            Duration this$delay = this.getDelay();
            Duration other$delay = other.getDelay();
            return !(this$delay == null ? other$delay != null : !((Object)this$delay).equals(other$delay));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConfigWatch;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $keyPrefix = this.getKeyPrefix();
            result = result * 59 + ($keyPrefix == null ? 43 : $keyPrefix.hashCode());
            Duration $delay = this.getDelay();
            result = result * 59 + ($delay == null ? 43 : ((Object)$delay).hashCode());
            return result;
        }

        public String toString() {
            return "RedisConfigProperties.ConfigWatch(enabled=" + this.isEnabled() + ", keyPrefix=" + this.getKeyPrefix() + ", delay=" + this.getDelay() + ")";
        }
    }

    public class EventWatch {
        private boolean enabled = true;
        private String keyPrefix = "event:";
        private Duration waitTime = Duration.ofSeconds(55L);
        private Duration delay = Duration.ofMillis(10L);

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getKeyPrefix() {
            return this.keyPrefix;
        }

        public Duration getWaitTime() {
            return this.waitTime;
        }

        public Duration getDelay() {
            return this.delay;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setKeyPrefix(String keyPrefix) {
            this.keyPrefix = keyPrefix;
        }

        public void setWaitTime(Duration waitTime) {
            this.waitTime = waitTime;
        }

        public void setDelay(Duration delay) {
            this.delay = delay;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EventWatch)) {
                return false;
            }
            EventWatch other = (EventWatch)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$keyPrefix = this.getKeyPrefix();
            String other$keyPrefix = other.getKeyPrefix();
            if (this$keyPrefix == null ? other$keyPrefix != null : !this$keyPrefix.equals(other$keyPrefix)) {
                return false;
            }
            Duration this$waitTime = this.getWaitTime();
            Duration other$waitTime = other.getWaitTime();
            if (this$waitTime == null ? other$waitTime != null : !((Object)this$waitTime).equals(other$waitTime)) {
                return false;
            }
            Duration this$delay = this.getDelay();
            Duration other$delay = other.getDelay();
            return !(this$delay == null ? other$delay != null : !((Object)this$delay).equals(other$delay));
        }

        protected boolean canEqual(Object other) {
            return other instanceof EventWatch;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $keyPrefix = this.getKeyPrefix();
            result = result * 59 + ($keyPrefix == null ? 43 : $keyPrefix.hashCode());
            Duration $waitTime = this.getWaitTime();
            result = result * 59 + ($waitTime == null ? 43 : ((Object)$waitTime).hashCode());
            Duration $delay = this.getDelay();
            result = result * 59 + ($delay == null ? 43 : ((Object)$delay).hashCode());
            return result;
        }

        public String toString() {
            return "RedisConfigProperties.EventWatch(enabled=" + this.isEnabled() + ", keyPrefix=" + this.getKeyPrefix() + ", waitTime=" + this.getWaitTime() + ", delay=" + this.getDelay() + ")";
        }
    }
}

