/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.redis.register;

import com.google.common.base.Strings;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import ltd.fdsa.redis.properties.RedisConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewService {
    private static final Logger log = LoggerFactory.getLogger(NewService.class);
    private final RedisConfigProperties properties;
    private final String host;
    private final int port;
    private final String name;
    private final String id;

    public NewService(RedisConfigProperties properties) {
        this.properties = properties;
        this.host = this.getApplicationHost();
        this.port = this.properties.getApplicationPort();
        this.name = this.properties.getName();
        this.id = this.host + ":" + this.port + "/" + this.name;
    }

    private String getApplicationHost() {
        if (!Strings.isNullOrEmpty((String)this.properties.getApplicationHost())) {
            return this.properties.getApplicationHost();
        }
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address) || ip.isLoopbackAddress() || ip.getHostAddress().indexOf(":") != -1) continue;
                    this.properties.setApplicationHost(ip.getHostAddress());
                    return this.properties.getApplicationHost();
                }
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6IP\u5f02\u5e38", (Throwable)e);
        }
        return this.properties.getApplicationHost();
    }

    public RedisConfigProperties getProperties() {
        return this.properties;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewService)) {
            return false;
        }
        NewService other = (NewService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        RedisConfigProperties this$properties = this.getProperties();
        RedisConfigProperties other$properties = other.getProperties();
        if (this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        return !(this$id == null ? other$id != null : !this$id.equals(other$id));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NewService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPort();
        RedisConfigProperties $properties = this.getProperties();
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        return result;
    }

    public String toString() {
        return "NewService(properties=" + this.getProperties() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", name=" + this.getName() + ", id=" + this.getId() + ")";
    }
}

