/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.redis.cache;

import ltd.fdsa.redis.properties.RedisConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.CacheManager;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.cache.RedisCacheWriter;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.GenericJackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;

public class RedisCache {
    private static final Logger log = LoggerFactory.getLogger(RedisCache.class);
    final RedisConfigProperties properties;
    final RedisTemplate<String, Object> redisTemplate;
    final RedisConnectionFactory redisConnectionFactory;

    public RedisCache(RedisConfigProperties properties, RedisConnectionFactory redisConnectionFactory) {
        this.properties = properties;
        this.redisConnectionFactory = redisConnectionFactory;
        this.redisTemplate = new RedisTemplate();
        this.redisTemplate.setConnectionFactory(redisConnectionFactory);
        this.redisTemplate.setKeySerializer(this.keySerializer());
        this.redisTemplate.setHashKeySerializer(this.keySerializer());
        this.redisTemplate.setValueSerializer(this.valueSerializer());
        this.redisTemplate.setHashValueSerializer(this.valueSerializer());
    }

    public CacheManager cacheManager() {
        RedisCacheConfiguration redisCacheConfiguration = RedisCacheConfiguration.defaultCacheConfig();
        redisCacheConfiguration = redisCacheConfiguration.entryTtl(this.properties.getCacheTtl()).disableCachingNullValues().serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer(this.keySerializer())).serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(this.valueSerializer()));
        return RedisCacheManager.builder((RedisCacheWriter)RedisCacheWriter.nonLockingRedisCacheWriter((RedisConnectionFactory)this.redisConnectionFactory)).cacheDefaults(redisCacheConfiguration).build();
    }

    private RedisSerializer<String> keySerializer() {
        return new StringRedisSerializer();
    }

    private RedisSerializer<Object> valueSerializer() {
        return new GenericJackson2JsonRedisSerializer();
    }
}

