/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.redis.event;

import ltd.fdsa.core.event.RemoteEventPublisher;
import ltd.fdsa.core.event.RemotingEvent;
import ltd.fdsa.redis.properties.RedisConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisEventService
implements RemoteEventPublisher {
    private static final Logger log = LoggerFactory.getLogger(RedisEventService.class);
    private final RedisConfigProperties properties;
    private final RedisTemplate<String, RemotingEvent> eventRedisTemplate;

    public RedisEventService(RedisConfigProperties properties, RedisConnectionFactory connectionFactory) {
        this.properties = properties;
        this.eventRedisTemplate = new RedisTemplate();
        this.eventRedisTemplate.setConnectionFactory(connectionFactory);
    }

    public void send(RemotingEvent event) {
        this.eventRedisTemplate.convertAndSend(this.properties.getEventWatch().getKeyPrefix(), (Object)event);
    }
}

