/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.redis.lock;

import java.util.concurrent.locks.Lock;
import ltd.fdsa.core.lock.LockManager;
import ltd.fdsa.redis.properties.RedisConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.integration.redis.util.RedisLockRegistry;

public class RedisLockManager
implements LockManager {
    private static final Logger log = LoggerFactory.getLogger(RedisLockManager.class);
    private static RedisLockRegistry registry;
    private final RedisConfigProperties properties;
    private final RedisConnectionFactory redisConnectionFactory;

    public RedisLockManager(RedisConfigProperties properties, RedisConnectionFactory redisConnectionFactory) {
        this.properties = properties;
        this.redisConnectionFactory = redisConnectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock getLock(String lockKey) {
        if (registry == null) {
            RedisLockRegistry redisLockRegistry = registry;
            synchronized (redisLockRegistry) {
                if (registry == null) {
                    registry = new RedisLockRegistry(this.redisConnectionFactory, this.properties.getCacheKey());
                }
            }
        }
        return registry.obtain((Object)lockKey);
    }
}

