/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.redis.thread;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import ltd.fdsa.core.context.ApplicationContextHolder;
import ltd.fdsa.core.event.RefreshedEvent;
import ltd.fdsa.core.event.RemotingEvent;
import ltd.fdsa.core.event.ServiceDiscoveredEvent;
import ltd.fdsa.core.service.ServiceInfo;
import ltd.fdsa.redis.properties.RedisConfigProperties;
import ltd.fdsa.redis.register.NewService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.SmartLifecycle;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.scheduling.TaskScheduler;

public class RedisWatchThread
implements SmartLifecycle {
    private static final Logger log = LoggerFactory.getLogger(RedisWatchThread.class);
    private final RedisConfigProperties properties;
    private final TaskScheduler taskScheduler;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final RedisConnectionFactory redisConnectionFactory;
    private final RedisMessageListenerContainer redisMessageListenerContainer = new RedisMessageListenerContainer();
    private final RedisTemplate<String, NewService> serviceRedisTemplate = new RedisTemplate();
    private final RedisTemplate<String, RemotingEvent> eventRedisTemplate = new RedisTemplate();
    private final StringRedisTemplate stringRedisTemplate = new StringRedisTemplate();
    private ScheduledFuture<?> serviceRegisterFuture;

    public RedisWatchThread(RedisConfigProperties properties, TaskScheduler taskScheduler, RedisConnectionFactory connectionFactory) {
        this.properties = properties;
        this.taskScheduler = taskScheduler;
        this.redisConnectionFactory = connectionFactory;
        this.serviceRedisTemplate.setConnectionFactory(this.redisConnectionFactory);
        this.stringRedisTemplate.setConnectionFactory(this.redisConnectionFactory);
        this.eventRedisTemplate.setConnectionFactory(this.redisConnectionFactory);
        this.redisMessageListenerContainer.setConnectionFactory(this.redisConnectionFactory);
        this.redisMessageListenerContainer.setMaxSubscriptionRegistrationWaitingTime(this.properties.getWaitTime().toMillis());
        if (this.properties.getServiceWatch().isEnabled()) {
            this.redisMessageListenerContainer.addMessageListener(new MessageListener(){

                public void onMessage(Message message, byte[] bytes) {
                    log.info("channel:{},body:{}", (Object)message.getChannel(), (Object)message.getBody());
                    RedisWatchThread.this.serviceWatch();
                }
            }, (Topic)new PatternTopic(this.properties.getServiceWatch().getKeyPrefix()));
        }
        if (this.properties.getEventWatch().isEnabled()) {
            this.redisMessageListenerContainer.addMessageListener(new MessageListener(){

                public void onMessage(Message message, byte[] bytes) {
                    log.info("channel:{},body:{}", (Object)message.getChannel(), (Object)message.getBody());
                    RemotingEvent event = (RemotingEvent)RedisWatchThread.this.serviceRedisTemplate.getValueSerializer().deserialize(message.getBody());
                    if (event != null) {
                        ApplicationContextHolder.publishLocal((ApplicationEvent)event.getTarget());
                    }
                }
            }, (Topic)new PatternTopic(this.properties.getEventWatch().getKeyPrefix()));
        }
        if (this.properties.getConfigWatch().isEnabled()) {
            this.redisMessageListenerContainer.addMessageListener(new MessageListener(){

                public void onMessage(Message message, byte[] bytes) {
                    log.info("channel:{},body:{}", (Object)message.getChannel(), (Object)message.getBody());
                    RedisWatchThread.this.configWatch();
                }
            }, (Topic)new PatternTopic(this.properties.getConfigWatch().getKeyPrefix()));
        }
    }

    public void start() {
        if (this.running.compareAndSet(false, true) && this.properties.isEnabled()) {
            this.serviceRegisterFuture = this.taskScheduler.scheduleWithFixedDelay(this::serviceRegister, this.properties.getDelay());
        }
    }

    public void serviceWatch() {
        LinkedHashMap data = new LinkedHashMap();
        for (String key : this.serviceRedisTemplate.keys((Object)this.properties.getServiceWatch().getKeyPrefix())) {
            List services = this.serviceRedisTemplate.opsForSet().members((Object)key).stream().map(m -> ServiceInfo.builder().ip(m.getHost()).port(m.getPort()).build()).collect(Collectors.toList());
            data.put(key.substring(this.properties.getServiceWatch().getKeyPrefix().length() - 1), services);
        }
        ApplicationContextHolder.publishLocal((ApplicationEvent)new ServiceDiscoveredEvent((Object)this, data));
    }

    public void configWatch() {
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        String prefix = this.properties.getConfigWatch().getKeyPrefix() + ":" + this.properties.getName();
        for (String key : this.stringRedisTemplate.keys((Object)prefix)) {
            String value = (String)this.stringRedisTemplate.opsForValue().get((Object)key);
            data.put(key.substring(prefix.length() - 1), value);
        }
        ApplicationContextHolder.publishLocal((ApplicationEvent)new RefreshedEvent((Object)this, data));
    }

    public void serviceRegister() {
        if (!this.running.get()) {
            return;
        }
        try {
            NewService register = new NewService(this.properties);
            this.serviceRedisTemplate.convertAndSend(this.properties.getServiceWatch().getKeyPrefix(), (Object)register);
            this.serviceRedisTemplate.opsForSet().add((Object)(this.properties.getServiceWatch().getKeyPrefix() + ":" + register.getName()), (Object[])new NewService[]{register});
        }
        catch (Exception e) {
            log.error("Error Consul register", (Throwable)e);
        }
    }

    public void stop() {
        if (this.running.compareAndSet(true, false)) {
            if (this.serviceRegisterFuture != null) {
                this.serviceRegisterFuture.cancel(true);
            }
            this.redisMessageListenerContainer.stop();
        }
    }

    public boolean isRunning() {
        return false;
    }

    public RedisMessageListenerContainer getWatcher() {
        return this.redisMessageListenerContainer;
    }
}

