/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.starter.jdbc.collection;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.springframework.jdbc.core.RowMapper;

public class LazyResultSetCollection<E>
implements Collection<E> {
    private final ResultSet rs;
    private final RowMapper<E> mapper;
    private final Class<E> clazz;

    public LazyResultSetCollection(ResultSet resultSet, RowMapper<E> mapper, Class<E> clazz) {
        this.rs = resultSet;
        this.mapper = mapper;
        this.clazz = clazz;
    }

    @Override
    public int size() {
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean contains(Object o) {
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new ResultSetIterator<E>(this.rs, this.clazz);
    }

    @Override
    public Object[] toArray() {
        ArrayList results = new ArrayList();
        this.stream().forEach(results::add);
        return results.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        ArrayList results = new ArrayList();
        this.stream().forEach(results::add);
        return results.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return true;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return true;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return true;
    }

    @Override
    public void clear() {
    }

    private class ResultSetIterator<C>
    implements Iterator<C> {
        private final ResultSet rs;
        private C next;

        public ResultSetIterator(ResultSet resultSet, Class<C> clazz) {
            this.rs = resultSet;
        }

        @Override
        public boolean hasNext() {
            if (this.next == null) {
                boolean hasNext = false;
                try {
                    hasNext = this.rs.next();
                    if (!hasNext) {
                        return false;
                    }
                    this.next = LazyResultSetCollection.this.mapper.mapRow(this.rs, 0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return hasNext;
            }
            return true;
        }

        @Override
        public C next() {
            if (this.next == null) {
                try {
                    this.rs.next();
                    return (C)LazyResultSetCollection.this.mapper.mapRow(this.rs, 0);
                }
                catch (Exception e) {
                    return null;
                }
            }
            C returnItem = this.next;
            this.next = null;
            return returnItem;
        }
    }
}

