/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.starter.jdbc.config;

import com.fasterxml.jackson.annotation.JsonInclude;
import javax.sql.DataSource;
import ltd.fdsa.core.util.NamingUtils;
import ltd.fdsa.database.properties.JdbcApiProperties;
import ltd.fdsa.database.service.JdbcApiService;
import ltd.fdsa.starter.jdbc.controller.JdbcApiController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.bind.annotation.RestController;

@Configuration
@EnableConfigurationProperties(value={JdbcApiProperties.class})
public class JdbcApiAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(JdbcApiAutoConfiguration.class);

    @Bean
    @ConditionalOnProperty(value={"project.rest-api.enabled"}, havingValue="true", matchIfMissing=false)
    public JdbcApiService jdbcService(JdbcApiProperties properties, DataSource dataSource) {
        return new JdbcApiService(properties, dataSource);
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer jsonCustomizer() {
        return builder -> builder.serializationInclusion(JsonInclude.Include.NON_NULL).build();
    }

    @RestController
    @ConditionalOnProperty(value={"project.rest-api.enabled"}, havingValue="true", matchIfMissing=false)
    public static class JdbcControllerConfiguration
    extends JdbcApiController {
        public JdbcControllerConfiguration() {
            NamingUtils.formatLog((Logger)log, (String)"JdbcControllerConfiguration Start", (Object[])new Object[0]);
        }
    }
}

