/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.starter.jdbc.controller;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Strings;
import io.swagger.models.Swagger;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import ltd.fdsa.database.fql.JdbcFqlVisitor;
import ltd.fdsa.database.fql.antlr.FqlLexer;
import ltd.fdsa.database.fql.antlr.FqlParser;
import ltd.fdsa.database.service.JdbcApiService;
import ltd.fdsa.database.sql.columns.Column;
import ltd.fdsa.database.sql.conditions.Condition;
import ltd.fdsa.database.sql.domain.Placeholder;
import ltd.fdsa.database.sql.domain.Valuable;
import ltd.fdsa.database.sql.queries.Delete;
import ltd.fdsa.database.sql.queries.Insert;
import ltd.fdsa.database.sql.queries.Queries;
import ltd.fdsa.database.sql.queries.Query;
import ltd.fdsa.database.sql.queries.Update;
import ltd.fdsa.database.sql.schema.Table;
import ltd.fdsa.starter.jdbc.model.ViewResult;
import ltd.fdsa.starter.jdbc.model.ViewUpdate;
import ltd.fdsa.web.controller.BaseController;
import ltd.fdsa.web.enums.HttpCode;
import ltd.fdsa.web.view.Result;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@RestController
@RequestMapping(value={"/v2"})
public class JdbcApiController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(JdbcApiController.class);
    @Autowired
    JdbcApiService service;

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @RequestMapping(value={"/api-docs"}, method={RequestMethod.GET})
    public Swagger getApiDocs(@RequestParam(value="group", required=false) String group, HttpServletRequest request) {
        UriComponents components = UriComponentsBuilder.fromHttpRequest((HttpRequest)new ServletServerHttpRequest(request)).build();
        String host = components.getHost();
        if (components.getPort() > 0) {
            host = host + ":" + components.getPort();
        }
        group = Strings.isNullOrEmpty((String)group) ? "/" : "/" + group;
        Swagger swagger = this.service.getApiDocs(host, group);
        return swagger;
    }

    @RequestMapping(value={"/models"}, method={RequestMethod.GET}, produces={"application/json"})
    public Result<Object> getModels() {
        Object[] result = this.service.getNamedTables().values().stream().map(table -> ViewResult.builder().name(table.getAlias()).content(table.getSchema().getName()).remark(table.getRemark()).build()).toArray();
        return Result.success((Object)result);
    }

    @RequestMapping(value={"/{model}/columns"}, method={RequestMethod.GET}, produces={"application/json"})
    public Result<Object> getColumns(@PathVariable String model) {
        Table table = (Table)this.service.getNamedTables().get(model);
        if (table == null) {
            return Result.fail((HttpCode)HttpCode.NOT_FOUND, (Object)"No data resource\uff01");
        }
        Object[] result = ((Map)this.service.getNamedColumns().get(table.getAlias())).values().stream().map(column -> ViewResult.builder().name(column.getAlias()).content(column.getColumnDefinition()).remark(column.getRemark()).build()).toArray();
        return Result.success((Object)result);
    }

    @RequestMapping(value={"/{model}/keys"}, method={RequestMethod.GET}, produces={"application/json"})
    public Result<Object> getKeys(@PathVariable String model) {
        Table table = (Table)this.service.getNamedTables().get(model);
        if (table == null) {
            return Result.fail((HttpCode)HttpCode.NOT_FOUND, (Object)"No data resource\uff01");
        }
        List result = (List)this.service.getNamedKeyColumns().get(table.getAlias());
        return Result.success((Object)result);
    }

    @RequestMapping(value={"/create/{model}"}, method={RequestMethod.PUT}, produces={"application/json"})
    public Result<Object> create(@PathVariable String model, @RequestBody Map<String, Object> data) {
        Table table = (Table)this.service.getNamedTables().get(model);
        if (table == null) {
            return Result.fail((HttpCode)HttpCode.NOT_FOUND, (Object)"No data resource\uff01");
        }
        Map columns = (Map)this.service.getNamedColumns().get(table.getAlias());
        if (columns == null) {
            return Result.fail((HttpCode)HttpCode.NOT_FOUND, (Object)"No data description\uff01");
        }
        if (data == null || data.size() == 0) {
            return Result.fail((HttpCode)HttpCode.BAD_REQUEST, (Object)"Put data can not be empty");
        }
        try {
            Insert sql = Queries.insertInto((Table)table);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                Column column = (Column)columns.get(entry.getKey());
                if (column == null) continue;
                map.put(column.getName(), this.convertColumnData(column.getColumnDefinition().getDefinitionName(), entry.getValue()));
                sql.set(column, Placeholder.placeholder((Column)column));
            }
            return Result.success((Object)this.service.update((Query)sql, map));
        }
        catch (Exception ex) {
            return Result.error((Exception)ex);
        }
    }

    @RequestMapping(value={"/{model}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public Result<Object> delete(@PathVariable String model, @RequestBody Map<String, Object> where) {
        Table table = (Table)this.service.getNamedTables().get(model);
        if (table == null) {
            return Result.fail((HttpCode)HttpCode.NOT_FOUND, (Object)"No data resource\uff01");
        }
        Map columns = (Map)this.service.getNamedColumns().get(table.getAlias());
        if (columns == null) {
            return Result.fail((HttpCode)HttpCode.NOT_FOUND, (Object)"No data description\uff01");
        }
        if (where == null || where.size() == 0) {
            return Result.fail((HttpCode)HttpCode.BAD_REQUEST, (Object)"Condition can not be empty");
        }
        try {
            Delete sql = Queries.deleteFrom((Table)table);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            Condition condition = Condition.emptyCondition();
            for (Map.Entry<String, Object> entry : where.entrySet()) {
                Column column = (Column)columns.get(entry.getKey());
                if (column == null) {
                    return Result.fail((HttpCode)HttpCode.BAD_REQUEST, (Object)(entry.getKey() + "can not be found!"));
                }
                map.put(column.getName(), this.convertColumnData(column.getColumnDefinition().getDefinitionName(), entry.getValue()));
                condition = condition.and(column.eq(Placeholder.placeholder((Column)column)));
            }
            sql.where(condition);
            return Result.success((Object)this.service.update((Query)sql, map));
        }
        catch (Exception ex) {
            return Result.error((Exception)ex);
        }
    }

    @RequestMapping(value={"/{model}/{key}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    public Result<Object> deleteByKey(@PathVariable String model, @PathVariable String key) {
        Table table = (Table)this.service.getNamedTables().get(model);
        if (table == null) {
            return Result.fail((HttpCode)HttpCode.NOT_FOUND, (Object)"No data resource\uff01");
        }
        Map columns = (Map)this.service.getNamedColumns().get(table.getAlias());
        if (columns == null) {
            return Result.fail((HttpCode)HttpCode.NOT_FOUND, (Object)"No data description\uff01");
        }
        if (Strings.isNullOrEmpty((String)key)) {
            return Result.fail((HttpCode)HttpCode.BAD_REQUEST, (Object)"Condition can not be empty");
        }
        try {
            Delete sql = Queries.deleteFrom((Table)table);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            Condition condition = Condition.emptyCondition();
            for (String entry : (List)this.service.getNamedKeyColumns().get(table.getAlias())) {
                Column column = (Column)columns.get(entry);
                if (column == null) continue;
                condition = condition.and(column.eq(Placeholder.placeholder((Column)column)));
                map.put(column.getName(), this.convertColumnData(column.getColumnDefinition().getDefinitionName(), key));
            }
            return Result.success((Object)this.service.update((Query)sql, map));
        }
        catch (Exception ex) {
            return Result.error((Exception)ex);
        }
    }

    @RequestMapping(value={"/{model}"}, method={RequestMethod.POST}, produces={"application/json"})
    public Result<Object> update(@PathVariable String model, @RequestBody ViewUpdate update) {
        Table table = (Table)this.service.getNamedTables().get(model);
        if (table == null) {
            return Result.fail((HttpCode)HttpCode.NOT_FOUND, (Object)"No data resource\uff01");
        }
        Map columns = (Map)this.service.getNamedColumns().get(table.getAlias());
        if (columns == null) {
            return Result.fail((HttpCode)HttpCode.NOT_FOUND, (Object)"No data description\uff01");
        }
        if (update == null) {
            return Result.fail((HttpCode)HttpCode.BAD_REQUEST, (Object)"Update data can not be empty");
        }
        Map<String, Object> data = update.getData();
        if (data == null || data.size() == 0) {
            return Result.fail((HttpCode)HttpCode.BAD_REQUEST, (Object)"Update data can not be empty");
        }
        Map<String, Object> where = update.getData();
        if (where == null || where.size() == 0) {
            return Result.fail((HttpCode)HttpCode.BAD_REQUEST, (Object)"Condition can not be empty");
        }
        try {
            Update sql = Queries.update((Table)table);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                Column column = (Column)columns.get(entry.getKey());
                if (column == null) continue;
                map.put(column.getName(), this.convertColumnData(column.getColumnDefinition().getDefinitionName(), entry.getValue()));
                sql.set(column, (Valuable)Placeholder.placeholder((Column)column));
            }
            Condition condition = Condition.emptyCondition();
            for (Map.Entry<String, Object> entry : where.entrySet()) {
                Column column = (Column)columns.get(entry.getKey());
                if (column == null) {
                    return Result.fail((HttpCode)HttpCode.BAD_REQUEST, (Object)(entry.getKey() + "can not be found!"));
                }
                map.put(column.getName(), this.convertColumnData(column.getColumnDefinition().getDefinitionName(), entry.getValue()));
                condition = condition.and(column.eq(Placeholder.placeholder((Column)column)));
            }
            sql.where(condition);
            return Result.success((Object)this.service.update((Query)sql, map));
        }
        catch (Exception ex) {
            return Result.error((Exception)ex);
        }
    }

    @RequestMapping(value={"/{model}/{key}"}, method={RequestMethod.POST}, produces={"application/json"})
    public Result<Object> updateByKey(@PathVariable String model, @RequestBody Map<String, Object> data, @PathVariable String key) {
        Table table = (Table)this.service.getNamedTables().get(model);
        if (table == null) {
            return Result.fail((HttpCode)HttpCode.NOT_FOUND, (Object)"No data resource\uff01");
        }
        Map columns = (Map)this.service.getNamedColumns().get(table.getAlias());
        if (columns == null) {
            return Result.fail((HttpCode)HttpCode.NOT_FOUND, (Object)"No data description\uff01");
        }
        if (data == null || data.size() == 0) {
            return Result.fail((HttpCode)HttpCode.BAD_REQUEST, (Object)"Update data can not be empty");
        }
        if (Strings.isNullOrEmpty((String)key)) {
            return Result.fail((HttpCode)HttpCode.BAD_REQUEST, (Object)"Condition can not be empty");
        }
        try {
            Update sql = Queries.update((Table)table);
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                Column column = (Column)columns.get(entry.getKey());
                if (column == null) continue;
                map.put(column.getName(), this.convertColumnData(column.getColumnDefinition().getDefinitionName(), entry.getValue()));
                sql.set(column, (Valuable)Placeholder.placeholder((Column)column));
            }
            Condition condition = Condition.emptyCondition();
            for (String entry : (List)this.service.getNamedKeyColumns().get(table.getAlias())) {
                Column column = (Column)columns.get(entry);
                if (column == null) continue;
                condition = condition.and(column.eq(Placeholder.placeholder((Column)column)));
                map.put(column.getName(), this.convertColumnData(column.getColumnDefinition().getDefinitionName(), key));
            }
            return Result.success((Object)this.service.update((Query)sql, map));
        }
        catch (Exception ex) {
            return Result.error((Exception)ex);
        }
    }

    @RequestMapping(value={"/query"}, method={RequestMethod.POST}, produces={"application/json"})
    public Result<Object> query(@RequestBody String query) {
        try {
            if (Strings.isNullOrEmpty((String)query)) {
                return Result.fail((int)400, (String)"QUERY string can not be empty");
            }
            if (!(query = query.trim()).startsWith("{") && !query.endsWith("}")) {
                query = "{" + query + "}";
            }
            CodePointCharStream input = CharStreams.fromString((String)query);
            FqlLexer lexer = new FqlLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            FqlParser parser = new FqlParser((TokenStream)tokens);
            FqlParser.DocumentContext document = parser.document();
            JdbcFqlVisitor visitor = new JdbcFqlVisitor(this.service);
            return Result.success((Object)visitor.visit(document).getObject());
        }
        catch (Exception ex) {
            return Result.error((Exception)ex);
        }
    }

    private Object convertColumnData(String type, Object data) {
        type = type.toUpperCase(Locale.ROOT);
        try {
            switch (type) {
                case "DATE": {
                    return new SimpleDateFormat("yyyy-MM-dd").parse(data.toString());
                }
                case "TIMESTAMP": 
                case "DATETIME": {
                    return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(data.toString());
                }
                case "TIME": {
                    return new SimpleDateFormat("HH:mm:ss").parse(data.toString());
                }
                case "BOOLEAN": 
                case "BOOL": {
                    return Boolean.valueOf(data.toString());
                }
            }
            log.warn("\u6ca1\u6709\u8003\u8651\u5230\u7684\u7c7b\u578b\uff1a{}", (Object)type);
            return data;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

