/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.starter.logger.aop;

import ltd.fdsa.starter.logger.annotation.LogAnnotation;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=-1)
public class LogAnnotationAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAnnotationAspect.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Autowired
    @Around(value="@annotation(logAnnotation)")
    public Object logSave(ProceedingJoinPoint joinPoint, LogAnnotation logAnnotation) throws Throwable {
        long start = System.currentTimeMillis();
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Object[] args = new Object[]{};
        if (logAnnotation.withParam()) {
            args = joinPoint.getArgs();
        }
        String info = String.join((CharSequence)",", logAnnotation.module(), logAnnotation.desc(), logAnnotation.operate(), methodSignature.getDeclaringTypeName(), methodSignature.getName());
        Object result = null;
        try {
            result = joinPoint.proceed();
            log.debug(info);
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage());
        }
        return result;
    }
}

