/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.starter.logger.config;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.db.DBAppender;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.db.ConnectionSource;
import ch.qos.logback.core.db.DriverManagerConnectionSource;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.util.Duration;
import java.util.Map;
import ltd.fdsa.core.util.NamingUtils;
import ltd.fdsa.starter.logger.interceptor.LogInterceptor;
import ltd.fdsa.starter.logger.properties.LoggingProperties;
import net.logstash.logback.appender.LogstashTcpSocketAppender;
import net.logstash.logback.encoder.LogstashEncoder;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
@ImportAutoConfiguration(value={LoggingProperties.class})
public class LoggingAutoConfiguration
implements WebMvcConfigurer,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(LoggingAutoConfiguration.class);
    private final LoggingProperties properties;
    @Value(value="${spring.application.name:Default}")
    private String name;

    public LoggingAutoConfiguration(LoggingProperties properties) {
        this.properties = properties;
    }

    public void afterPropertiesSet() throws Exception {
        NamingUtils.formatLog((Logger)log, (String)"LoggingFactory Start", (Object[])new Object[0]);
        if (this.properties.getLevel().size() <= 0) {
            this.properties.getLevel().put("ROOT", "ERROR");
        }
        for (Map.Entry<String, String> entry : this.properties.getLevel().entrySet()) {
            LoggingProperties.Logstash logstash;
            ch.qos.logback.classic.Logger logger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)entry.getKey());
            Level level = Level.toLevel((String)entry.getValue());
            LoggerContext context = logger.getLoggerContext();
            context.putProperty("name", this.name);
            LoggingProperties.DataSource datasource = this.properties.getDatasource();
            if (datasource != null && Strings.isNotEmpty((CharSequence)datasource.getUrl()) && logger.getAppender("DB") == null) {
                NamingUtils.formatLog((Logger)log, (String)"Logging Factory DB", (Object[])new Object[0]);
                DriverManagerConnectionSource connSource = new DriverManagerConnectionSource();
                connSource.setDriverClass(datasource.getDriverClassName());
                connSource.setUrl(datasource.getUrl());
                connSource.setUser(datasource.getUsername());
                connSource.setPassword(datasource.getPassword());
                connSource.setContext((Context)context);
                connSource.start();
                DBAppender dbAppender = new DBAppender();
                dbAppender.setConnectionSource((ConnectionSource)connSource);
                dbAppender.setContext((Context)context);
                dbAppender.setName("DB");
                dbAppender.start();
                logger.addAppender((Appender)dbAppender);
            }
            if ((logstash = this.properties.getLogstash()) == null || !Strings.isNotEmpty((CharSequence)logstash.getDestination()) || logger.getAppender("LOGSTASH") != null) continue;
            NamingUtils.formatLog((Logger)log, (String)"Logging Factory Logstash:{}", (Object[])new Object[]{entry});
            LogstashEncoder encoder = new LogstashEncoder();
            encoder.setIncludeContext(false);
            encoder.setCustomFields("{\"name\":\"" + this.name + "\"}");
            encoder.setIncludeMdc(true);
            encoder.setEncoding("UTF-8");
            LogstashTcpSocketAppender appender = new LogstashTcpSocketAppender();
            appender.setReconnectionDelay(Duration.buildBySeconds((double)(logstash.getDuration() < 10 ? 10.0 : (double)logstash.getDuration())));
            appender.addDestination(logstash.getDestination());
            appender.setEncoder((Encoder)encoder);
            appender.setContext((Context)context);
            appender.setName("LOGSTASH");
            appender.start();
            logger.addAppender((Appender)appender);
        }
    }

    public void addInterceptors(InterceptorRegistry registry) {
        InterceptorRegistration registration = registry.addInterceptor((HandlerInterceptor)new LogInterceptor());
        registration.order(Integer.MIN_VALUE);
        LoggingProperties.Path path = this.properties.getWebPath();
        if (path == null) {
            registration.addPathPatterns(new String[]{"/**"});
            return;
        }
        if (path.getIncludePathPatterns() != null) {
            for (String item : path.getIncludePathPatterns()) {
                registration.addPathPatterns(new String[]{item});
            }
        }
        if (path.getExcludePathPatterns() != null) {
            for (String item : path.getExcludePathPatterns()) {
                registration.excludePathPatterns(new String[]{item});
            }
        }
    }
}

