/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.starter.logger.influxdb;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ltd.fdsa.starter.logger.influxdb.AppenderExecutor;
import ltd.fdsa.starter.logger.influxdb.InfluxDbConverter;
import ltd.fdsa.starter.logger.influxdb.InfluxDbSource;
import org.influxdb.InfluxDB;
import org.influxdb.InfluxDBFactory;
import org.influxdb.dto.Query;
import org.influxdb.dto.QueryResult;

public class InfluxDbAppender
extends AppenderBase<ILoggingEvent> {
    private AppenderExecutor appenderExecutor;
    private InfluxDbSource source;

    protected void append(ILoggingEvent iLoggingEvent) {
        this.appenderExecutor.append(iLoggingEvent);
    }

    public void start() {
        this.initExecutor();
        super.start();
    }

    private void initExecutor() {
        System.out.println(":: initExecutor :: begin: " + this.source.toString());
        InfluxDB influxdb = InfluxDBFactory.connect((String)("http://" + this.source.getIp() + ":" + this.source.getPort()), (String)this.source.getUser(), (String)this.source.getPassword());
        String database = this.source.getDatabase();
        QueryResult q = influxdb.query(new Query("CREATE DATABASES " + database));
        influxdb.setDatabase(database);
        InfluxDbConverter converter = new InfluxDbConverter();
        this.appenderExecutor = new AppenderExecutor(converter, this.source, influxdb, this.getContext());
        System.out.println(":: initExecutor :: end");
    }

    public AppenderExecutor getAppenderExecutor() {
        return this.appenderExecutor;
    }

    public InfluxDbSource getSource() {
        return this.source;
    }

    public void setAppenderExecutor(AppenderExecutor appenderExecutor) {
        this.appenderExecutor = appenderExecutor;
    }

    public void setSource(InfluxDbSource source) {
        this.source = source;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InfluxDbAppender)) {
            return false;
        }
        InfluxDbAppender other = (InfluxDbAppender)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        AppenderExecutor this$appenderExecutor = this.getAppenderExecutor();
        AppenderExecutor other$appenderExecutor = other.getAppenderExecutor();
        if (this$appenderExecutor == null ? other$appenderExecutor != null : !this$appenderExecutor.equals(other$appenderExecutor)) {
            return false;
        }
        InfluxDbSource this$source = this.getSource();
        InfluxDbSource other$source = other.getSource();
        return !(this$source == null ? other$source != null : !((Object)this$source).equals(other$source));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InfluxDbAppender;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AppenderExecutor $appenderExecutor = this.getAppenderExecutor();
        result = result * 59 + ($appenderExecutor == null ? 43 : $appenderExecutor.hashCode());
        InfluxDbSource $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        return result;
    }

    public String toString() {
        return "InfluxDbAppender(appenderExecutor=" + this.getAppenderExecutor() + ", source=" + this.getSource() + ")";
    }
}

