/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.starter.logger.interceptor;

import java.util.LinkedHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import ltd.fdsa.web.utils.TraceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

public class LogInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LogInterceptor.class);
    @Value(value="${spring.application.name:default}")
    private String name;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        TraceUtils.startTrace((HttpServletRequest[])new HttpServletRequest[]{request});
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        LinkedHashMap<String, String> meta = new LinkedHashMap<String, String>();
        meta.put("APP_NAME", this.name);
        TraceUtils.endStrace(meta);
    }
}

