/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.starter.remote;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import ltd.fdsa.core.util.NamingUtils;
import ltd.fdsa.starter.remote.RpcApiClassScanner;
import ltd.fdsa.starter.remote.RpcMethodProxyFactoryBean;
import ltd.fdsa.starter.remote.annotation.RpcClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.autoconfigure.AutoConfigurationPackages;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class RpcApiBeanDefinitionRegistry
implements BeanDefinitionRegistryPostProcessor,
EnvironmentAware,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(RpcApiBeanDefinitionRegistry.class);
    Environment environment;
    BeanFactory beanFactory;

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
        RpcApiClassScanner scanner = new RpcApiClassScanner(registry);
        NamingUtils.formatLog((Logger)log, (String)("Before RpcApi Registry: " + registry.getBeanDefinitionCount()), (Object[])new Object[0]);
        List list = AutoConfigurationPackages.get((BeanFactory)this.beanFactory);
        String[] packages = (String[])this.environment.getProperty("project.rpc.packages", String[].class);
        if (packages != null) {
            for (String item : packages) {
                list.add(item);
            }
        }
        packages = StringUtils.toStringArray((Collection)list);
        scanner.scan(packages);
        for (String name : registry.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = registry.getBeanDefinition(name);
            if (!(beanDefinition instanceof GenericBeanDefinition) || !name.endsWith("ontroller")) continue;
            Class clazz = null;
            try {
                clazz = ClassUtils.forName((String)beanDefinition.getBeanClassName(), null);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            if (clazz == null) continue;
            for (Field field : clazz.getDeclaredFields()) {
                String originalClassName;
                if (!field.isAnnotationPresent(RpcClient.class) || registry.containsBeanDefinition(originalClassName = field.getType().getCanonicalName())) continue;
                GenericBeanDefinition registryBeanDefinition = new GenericBeanDefinition();
                registryBeanDefinition.setBeanClass(RpcMethodProxyFactoryBean.class);
                registryBeanDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)clazz);
                registryBeanDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)field);
                registryBeanDefinition.setAutowireMode(2);
                registry.registerBeanDefinition(originalClassName, (BeanDefinition)registryBeanDefinition);
            }
        }
        NamingUtils.formatLog((Logger)log, (String)("After RpcApi Registry: " + registry.getBeanDefinitionCount()), (Object[])new Object[0]);
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
    }
}

