/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.starter.remote;

import java.util.Set;
import ltd.fdsa.starter.remote.RpcClientProxyFactoryBean;
import ltd.fdsa.starter.remote.annotation.RpcApis;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

public class RpcApiClassScanner
extends ClassPathBeanDefinitionScanner {
    public RpcApiClassScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
        AnnotationTypeFilter typeFilter = new AnnotationTypeFilter(RpcApis.class);
        this.addIncludeFilter((TypeFilter)typeFilter);
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Component.class));
    }

    protected Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        for (BeanDefinitionHolder beanDefinitionHolder : beanDefinitions) {
            GenericBeanDefinition beanDefinition = (GenericBeanDefinition)beanDefinitionHolder.getBeanDefinition();
            String originalClassName = beanDefinition.getBeanClassName();
            beanDefinition.setBeanClass(RpcClientProxyFactoryBean.class);
            beanDefinition.getConstructorArgumentValues().addGenericArgumentValue((Object)originalClassName);
            beanDefinition.setAutowireMode(2);
        }
        return beanDefinitions;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isIndependent();
    }

    protected boolean checkCandidate(String beanName, BeanDefinition beanDefinition) {
        if (super.checkCandidate(beanName, beanDefinition)) {
            BeanDefinitionRegistry registry = this.getRegistry();
            try {
                String name;
                BeanDefinition definedBeanDefinition;
                Class beanClass = ClassUtils.forName((String)beanDefinition.getBeanClassName(), null);
                String[] stringArray = registry.getBeanDefinitionNames();
                int n = stringArray.length;
                for (int i = 0; i < n && (definedBeanDefinition = registry.getBeanDefinition(name = stringArray[i])).getBeanClassName() != null; ++i) {
                    Class definedBeanClass = ClassUtils.forName((String)definedBeanDefinition.getBeanClassName(), null);
                    if (!beanClass.isAssignableFrom(definedBeanClass)) continue;
                    return false;
                }
            }
            catch (ClassNotFoundException e) {
                this.logger.error((Object)"ClassNotFoundException", (Throwable)e);
            }
            return true;
        }
        return false;
    }
}

