/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.starter.remote;

import com.caucho.hessian.client.HessianConnectionFactory;
import com.caucho.hessian.client.HessianProxyFactory;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import ltd.fdsa.core.event.ServiceDiscoveredEvent;
import ltd.fdsa.core.service.ServiceInfo;
import ltd.fdsa.starter.remote.RpcService;
import ltd.fdsa.starter.remote.annotation.RpcApis;
import ltd.fdsa.starter.remote.hessian.HessianTraceConnectionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationListener;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.retry.annotation.Retryable;

public class RpcClientProxyFactoryBean<T>
implements FactoryBean<T>,
EnvironmentAware,
ApplicationListener<ServiceDiscoveredEvent>,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RpcClientProxyFactoryBean.class);
    private static Retryable DEFAULT_RETRY;
    private static final HessianProxyFactory factory;
    private static final AtomicInteger next;
    private final Class<T> proxyClass;
    private Environment environment;
    Map<String, List<ServiceInfo>> serviceList = Maps.newHashMap();

    public RpcClientProxyFactoryBean(Class<T> proxyClass) {
        this.proxyClass = proxyClass;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public T getObject() {
        Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.proxyClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                Retryable retryable = method.getAnnotation(Retryable.class);
                if (retryable == null) {
                    retryable = DEFAULT_RETRY;
                }
                int attempts = 0;
                while (true) {
                    try {
                        return this.innerInvoke(method, args);
                    }
                    catch (Exception e) {
                        if (attempts >= retryable.maxAttempts()) {
                            throw new Exception("invoke service maxAttempts:" + attempts, e);
                        }
                        Thread.sleep(0L);
                        log.info("attempt invoke service:{}.{} {} times", new Object[]{RpcClientProxyFactoryBean.this.proxyClass, method.getName(), ++attempts});
                        continue;
                    }
                    break;
                }
            }

            private Object innerInvoke(Method method, Object[] args) throws Exception {
                RpcService service = RpcClientProxyFactoryBean.this.createRpcService();
                if (service == null) {
                    throw new Exception("create remote service api failed");
                }
                return service.invoke(RpcClientProxyFactoryBean.this.proxyClass, method.getName(), args);
            }
        });
        if (proxy == null) {
            return null;
        }
        return (T)proxy;
    }

    public Class<?> getObjectType() {
        return this.proxyClass;
    }

    public boolean isSingleton() {
        return true;
    }

    private RpcService createRpcService() {
        try {
            RpcApis api = this.proxyClass.getAnnotation(RpcApis.class);
            String serviceName = this.environment.resolvePlaceholders(api.value());
            if (!this.serviceList.containsKey(serviceName)) {
                return null;
            }
            ServiceInfo[] list = this.serviceList.get(serviceName).toArray(new ServiceInfo[0]);
            if (list.length == 0) {
                return null;
            }
            ServiceInfo service = list[next.getAndIncrement() % list.length];
            String url = String.format("http://%s:%s/hessian/rpc/service", service.getIp(), service.getPort());
            return (RpcService)factory.create(RpcService.class, url);
        }
        catch (MalformedURLException e) {
            log.error("createRpcService", (Throwable)e);
            return null;
        }
    }

    public void onApplicationEvent(ServiceDiscoveredEvent event) {
        this.serviceList = event.getServices();
    }

    public void afterPropertiesSet() throws Exception {
        HessianTraceConnectionFactory connectionFactory = new HessianTraceConnectionFactory();
        connectionFactory.setHessianProxyFactory(factory);
        factory.setConnectionFactory((HessianConnectionFactory)connectionFactory);
    }

    static {
        @Retryable
        final class C {
            C() {
            }
        }
        DEFAULT_RETRY = C.class.getAnnotation(Retryable.class);
        factory = new HessianProxyFactory();
        next = new AtomicInteger(0);
    }
}

