/*
 * Decompiled with CFR 0.152.
 */
package ltd.fdsa.starter.remote.config;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Collectors;
import ltd.fdsa.core.context.ApplicationContextHolder;
import ltd.fdsa.core.util.NamingUtils;
import ltd.fdsa.starter.remote.RpcApiBeanDefinitionRegistry;
import ltd.fdsa.starter.remote.RpcService;
import ltd.fdsa.starter.remote.properties.RpcProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.remoting.caucho.HessianServiceExporter;
import org.springframework.remoting.rmi.RmiServiceExporter;

@EnableConfigurationProperties(value={RpcProperties.class})
public class RpcAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RpcAutoConfiguration.class);
    static final String DEFAULT_RPC_SERVICE_NAME = "defaultRpcService";

    @Bean
    public RpcApiBeanDefinitionRegistry rpcApiBeanDefinitionRegistry() {
        NamingUtils.formatLog((Logger)log, (String)"Rpc Api Bean Definition Registry Started", (Object[])new Object[0]);
        return new RpcApiBeanDefinitionRegistry();
    }

    @Bean(name={"/hessian/rpc/service"})
    public HessianServiceExporter hessianServiceExporter() {
        NamingUtils.formatLog((Logger)log, (String)"HessianServiceExporter Started", (Object[])new Object[0]);
        HessianServiceExporter exporter = new HessianServiceExporter();
        exporter.setService((Object)this.defaultRpcService());
        exporter.setServiceInterface(RpcService.class);
        return exporter;
    }

    @Bean
    public RmiServiceExporter rmiServiceExporter() {
        NamingUtils.formatLog((Logger)log, (String)"RmiServiceExporter Started", (Object[])new Object[0]);
        RmiServiceExporter exporter = new RmiServiceExporter();
        exporter.setService((Object)this.defaultRpcService());
        exporter.setServiceName("rpcService");
        exporter.setServiceInterface(RpcService.class);
        exporter.setRegistryPort(1099);
        return exporter;
    }

    private RpcService defaultRpcService() {
        return new RpcService(){

            @Override
            public <T> Object invoke(Class<T> requiredType, String methodName, Object ... args) {
                Object bean = ApplicationContextHolder.getBean(requiredType);
                if (bean == null) {
                    log.warn("No required Type: {} in current application context", requiredType);
                    return null;
                }
                try {
                    if (args.length > 0) {
                        Class[] paramTypes = Arrays.stream(args).map(o -> o.getClass()).collect(Collectors.toSet()).toArray(new Class[0]);
                        Method method = bean.getClass().getMethod(methodName, paramTypes);
                        return method.invoke(bean, args);
                    }
                    return bean.getClass().getMethod(methodName, new Class[0]).invoke(bean, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    log.error("RpcServiceImpl.invoke", (Throwable)e);
                    return null;
                }
            }
        };
    }
}

