/*
 * Decompiled with CFR 0.152.
 */
package ly.iterative.itly.iteratively;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.segment.backo.Backo;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import ly.iterative.itly.Environment;
import ly.iterative.itly.Event;
import ly.iterative.itly.Logger;
import ly.iterative.itly.Plugin;
import ly.iterative.itly.PluginLoadOptions;
import ly.iterative.itly.Properties;
import ly.iterative.itly.ValidationResponse;
import ly.iterative.itly.iteratively.AuthInterceptor;
import ly.iterative.itly.iteratively.IterativelyOptions;
import ly.iterative.itly.iteratively.IterativelyPluginKt;
import ly.iterative.itly.iteratively.TrackModel;
import ly.iterative.itly.iteratively.TrackType;
import ly.iterative.itly.iteratively.Validation;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0001\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 82\u00020\u0001:\u000389:B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0016\u0010\u001d\u001a\u00020\u00032\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u0004\u001a\u00020!H\u0016J2\u0010\"\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010$\u001a\u00020\u00032\b\u0010%\u001a\u0004\u0018\u00010&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u001fH\u0016J*\u0010)\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010\u00032\b\u0010%\u001a\u0004\u0018\u00010&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u001fH\u0016J(\u0010*\u001a\u00020\u001b2\b\u0010#\u001a\u0004\u0018\u00010\u00032\u0006\u0010+\u001a\u00020,2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020(0\u001fH\u0016J\u0010\u0010-\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u0015H\u0002J,\u0010/\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u000101002\u0014\u0010%\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010200H\u0002J\b\u00103\u001a\u00020\u001bH\u0016J4\u00104\u001a\u00020\u00152\u0006\u00105\u001a\u0002062\n\b\u0002\u0010+\u001a\u0004\u0018\u00010,2\n\b\u0002\u0010%\u001a\u0004\u0018\u00010&2\n\b\u0002\u00107\u001a\u0004\u0018\u00010(H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lly/iterative/itly/iteratively/IterativelyPlugin;", "Lly/iterative/itly/Plugin;", "apiKey", "", "options", "Lly/iterative/itly/iteratively/IterativelyOptions;", "(Ljava/lang/String;Lly/iterative/itly/iteratively/IterativelyOptions;)V", "client", "Lokhttp3/OkHttpClient;", "config", "disabled", "", "isExternalNetworkExecutor", "isShutdown", "logger", "Lly/iterative/itly/Logger;", "mainExecutor", "Ljava/util/concurrent/ExecutorService;", "networkExecutor", "queue", "Ljava/util/concurrent/BlockingQueue;", "Lly/iterative/itly/iteratively/TrackModel;", "retryPolicy", "Lcom/segment/backo/Backo;", "scheduledExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "assertNotShutdown", "", "flush", "getTrackModelJson", "trackModels", "", "load", "Lly/iterative/itly/PluginLoadOptions;", "postGroup", "userId", "groupId", "properties", "Lly/iterative/itly/Properties;", "validationResults", "Lly/iterative/itly/ValidationResponse;", "postIdentify", "postTrack", "event", "Lly/iterative/itly/Event;", "push", "trackModel", "sanitizeValues", "", "", "", "shutdown", "toTrackModel", "type", "Lly/iterative/itly/iteratively/TrackType;", "validation", "Companion", "PollTrackingQueue", "Upload", "plugin-iteratively"})
public final class IterativelyPlugin
extends Plugin {
    private final IterativelyOptions config;
    private boolean disabled;
    private final OkHttpClient client;
    private final Backo retryPolicy;
    private final BlockingQueue<TrackModel> queue;
    private final ExecutorService mainExecutor;
    private final ExecutorService networkExecutor;
    private final ScheduledExecutorService scheduledExecutor;
    private final boolean isExternalNetworkExecutor;
    private boolean isShutdown;
    private Logger logger;
    @NotNull
    public static final String ID = "iteratively";
    @NotNull
    public static final String LOG_TAG = "[plugin-iteratively]";
    private static final ObjectMapper JSONObjectMapper;
    public static final Companion Companion;

    public void load(@NotNull PluginLoadOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Logger logger = this.logger = options.getLogger();
        if (logger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        logger.info("[plugin-iteratively] load");
        Boolean bl = this.config.getDisabled();
        boolean bl2 = bl != null ? bl : (this.disabled = options.getEnvironment() == Environment.PRODUCTION);
        if (this.disabled) {
            Logger logger2 = this.logger;
            if (logger2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger2.info("[plugin-iteratively] disabled");
            return;
        }
        this.mainExecutor.submit(new PollTrackingQueue());
        this.scheduledExecutor.scheduleAtFixedRate(new Runnable(this){
            final /* synthetic */ IterativelyPlugin this$0;

            public final void run() {
                this.this$0.flush();
            }
            {
                this.this$0 = iterativelyPlugin;
            }
        }, this.config.getFlushIntervalMs(), this.config.getFlushIntervalMs(), TimeUnit.MILLISECONDS);
    }

    public void postGroup(@Nullable String userId, @NotNull String groupId, @Nullable Properties properties, @NotNull List<ValidationResponse> validationResults) {
        Object v0;
        IterativelyPlugin iterativelyPlugin;
        IterativelyPlugin iterativelyPlugin2;
        TrackType trackType;
        Event event;
        Properties properties2;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
            Intrinsics.checkParameterIsNotNull(validationResults, (String)"validationResults");
            Iterable iterable = validationResults;
            properties2 = properties;
            event = null;
            trackType = TrackType.group;
            iterativelyPlugin2 = this;
            iterativelyPlugin = this;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                ValidationResponse it = (ValidationResponse)t;
                boolean bl3 = false;
                if (!(!it.getValid())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object var18_18 = v0;
        iterativelyPlugin.push(IterativelyPlugin.toTrackModel$default(iterativelyPlugin2, trackType, event, properties2, var18_18, 2, null));
    }

    public void postIdentify(@Nullable String userId, @Nullable Properties properties, @NotNull List<ValidationResponse> validationResults) {
        Object v0;
        IterativelyPlugin iterativelyPlugin;
        IterativelyPlugin iterativelyPlugin2;
        TrackType trackType;
        Event event;
        Properties properties2;
        block1: {
            Intrinsics.checkParameterIsNotNull(validationResults, (String)"validationResults");
            Iterable iterable = validationResults;
            properties2 = properties;
            event = null;
            trackType = TrackType.identify;
            iterativelyPlugin2 = this;
            iterativelyPlugin = this;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                ValidationResponse it = (ValidationResponse)t;
                boolean bl3 = false;
                if (!(!it.getValid())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object var17_17 = v0;
        iterativelyPlugin.push(IterativelyPlugin.toTrackModel$default(iterativelyPlugin2, trackType, event, properties2, var17_17, 2, null));
    }

    public void postTrack(@Nullable String userId, @NotNull Event event, @NotNull List<ValidationResponse> validationResults) {
        Object v0;
        IterativelyPlugin iterativelyPlugin;
        IterativelyPlugin iterativelyPlugin2;
        TrackType trackType;
        Event event2;
        Properties properties;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Intrinsics.checkParameterIsNotNull(validationResults, (String)"validationResults");
            Iterable iterable = validationResults;
            properties = (Properties)event;
            event2 = event;
            trackType = TrackType.track;
            iterativelyPlugin2 = this;
            iterativelyPlugin = this;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                ValidationResponse it = (ValidationResponse)t;
                boolean bl3 = false;
                if (!(!it.getValid())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object var17_17 = v0;
        iterativelyPlugin.push(iterativelyPlugin2.toTrackModel(trackType, event2, properties, var17_17));
    }

    public void flush() {
        this.push(TrackModel.Companion.newPoisonPill());
    }

    public void shutdown() {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        this.queue.clear();
        this.mainExecutor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
        this.client.dispatcher().cancelAll();
        this.client.dispatcher().executorService().shutdownNow();
        this.client.connectionPool().evictAll();
        if (!this.isExternalNetworkExecutor && !this.networkExecutor.isShutdown()) {
            this.networkExecutor.shutdownNow();
        }
    }

    private final void assertNotShutdown() {
        boolean bl = !this.isShutdown;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "plugin-iteratively was shutdown. Tracking is no longer operational.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final TrackModel toTrackModel(TrackType type, Event event, Properties properties, ValidationResponse validation) {
        Map map;
        String details;
        String string;
        boolean valid;
        ValidationResponse validationResponse = validation;
        boolean bl = valid = validationResponse != null ? validationResponse.getValid() : true;
        if (this.config.getOmitValues()) {
            string = "";
        } else {
            string = validation;
            if (string == null || (string = string.getMessage()) == null) {
                string = details = "";
            }
        }
        if (this.config.getOmitValues() && properties != null) {
            map = this.sanitizeValues(properties.getProperties());
        } else {
            Properties properties2 = properties;
            map = properties2 != null ? properties2.getProperties() : null;
        }
        Map sanitizedProperties = map;
        Event event2 = event;
        Event event3 = event;
        Event event4 = event;
        return new TrackModel(type, null, event2 != null ? event2.getId() : null, event3 != null ? event3.getVersion() : null, event4 != null ? event4.getName() : null, sanitizedProperties, valid, new Validation(details), 2, null);
    }

    static /* synthetic */ TrackModel toTrackModel$default(IterativelyPlugin iterativelyPlugin, TrackType trackType, Event event, Properties properties, ValidationResponse validationResponse, int n, Object object) {
        if ((n & 2) != 0) {
            event = null;
        }
        if ((n & 4) != 0) {
            properties = null;
        }
        if ((n & 8) != 0) {
            validationResponse = null;
        }
        return iterativelyPlugin.toTrackModel(trackType, event, properties, validationResponse);
    }

    private final Map sanitizeValues(Map<String, ? extends Object> properties) {
        Iterable $this$associateWith$iv = properties.keySet();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Object v = null;
            map.put(t, v);
        }
        return result$iv;
    }

    private final void push(TrackModel trackModel) {
        if (this.disabled) {
            return;
        }
        if (trackModel.getType() != TrackType.POISON) {
            Logger logger = this.logger;
            if (logger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger.debug("[plugin-iteratively] Queueing '" + trackModel.getEventName() + "' type:'" + (Object)((Object)trackModel.getType()) + '\'');
        }
        try {
            this.queue.put(trackModel);
        }
        catch (InterruptedException e) {
            Logger logger = this.logger;
            if (logger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger.error("[plugin-iteratively] Error: Queueing was interrupted for '" + (Object)((Object)trackModel.getType()) + "'. " + e.getMessage());
        }
    }

    private final String getTrackModelJson(List<TrackModel> trackModels) {
        return "{\"objects\":" + JSONObjectMapper.writeValueAsString(trackModels) + '}';
    }

    public IterativelyPlugin(@NotNull String apiKey, @NotNull IterativelyOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        super(ID);
        this.config = options;
        Boolean bl = options.getDisabled();
        this.disabled = bl != null ? bl : false;
        this.mainExecutor = IterativelyPluginKt.newDefaultExecutorService(this.config.getThreadFactory());
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(this.config.getThreadFactory());
        Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"Executors.newSingleThrea\u2026tor(config.threadFactory)");
        this.scheduledExecutor = scheduledExecutorService;
        ExecutorService executorService = options.getNetworkExecutor();
        if (executorService == null) {
            executorService = IterativelyPluginKt.newDefaultExecutorService(options.getThreadFactory());
        }
        this.networkExecutor = executorService;
        this.queue = new LinkedBlockingQueue();
        this.isExternalNetworkExecutor = options.getNetworkExecutor() != null;
        this.isShutdown = false;
        this.client = new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthInterceptor(apiKey)).build();
        Backo backo = Backo.builder().base(TimeUnit.MILLISECONDS, this.config.getRetryOptions().getDelayInitialMillis()).cap(TimeUnit.MILLISECONDS, this.config.getRetryOptions().getDelayMaximumMillis()).jitter(1).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)backo, (String)"Backo.builder()\n        \u2026r(1)\n            .build()");
        this.retryPolicy = backo;
    }

    static {
        Companion = new Companion(null);
        JSONObjectMapper = ExtensionsKt.jacksonObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
    }

    public static final /* synthetic */ Logger access$getLogger$p(IterativelyPlugin $this) {
        Logger logger = $this.logger;
        if (logger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        return logger;
    }

    public static final /* synthetic */ void access$setLogger$p(IterativelyPlugin $this, Logger logger) {
        $this.logger = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lly/iterative/itly/iteratively/IterativelyPlugin$PollTrackingQueue;", "Ljava/lang/Runnable;", "(Lly/iterative/itly/iteratively/IterativelyPlugin;)V", "run", "", "plugin-iteratively"})
    public final class PollTrackingQueue
    implements Runnable {
        @Override
        public void run() {
            boolean bl = false;
            List pending = new ArrayList();
            try {
                while (true) {
                    TrackModel track;
                    boolean isPoisonPill;
                    boolean bl2 = isPoisonPill = (track = (TrackModel)IterativelyPlugin.this.queue.take()).getType() == TrackType.POISON;
                    if (!isPoisonPill) {
                        TrackModel trackModel = track;
                        Intrinsics.checkExpressionValueIsNotNull((Object)trackModel, (String)"track");
                        pending.add(trackModel);
                    } else if (pending.size() < 1) {
                        IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("[plugin-iteratively] Flush received. No pending items.");
                        continue;
                    }
                    if ((long)pending.size() < IterativelyPlugin.this.config.getFlushQueueSize() && !isPoisonPill) continue;
                    IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("[plugin-iteratively] Posting " + pending.size() + " track items to " + IterativelyPlugin.this.config.getUrl() + '.');
                    IterativelyPlugin.this.networkExecutor.submit(new Upload(pending));
                    boolean bl3 = false;
                    pending = new ArrayList();
                }
            }
            catch (InterruptedException e) {
                IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("[plugin-iteratively] Processing thread was interrupted.");
                return;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lly/iterative/itly/iteratively/IterativelyPlugin$Upload;", "Ljava/lang/Runnable;", "batch", "", "Lly/iterative/itly/iteratively/TrackModel;", "(Lly/iterative/itly/iteratively/IterativelyPlugin;Ljava/util/List;)V", "postJson", "Lokhttp3/Response;", "url", "", "json", "run", "", "upload", "", "plugin-iteratively"})
    public final class Upload
    implements Runnable {
        private final List<TrackModel> batch;

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            int n = 0;
            int n2 = IterativelyPlugin.this.config.getRetryOptions().getMaxRetries();
            if (n <= n2) {
                while (true) {
                    void attempt;
                    boolean retry;
                    if (!(retry = this.upload())) {
                        return;
                    }
                    try {
                        IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("[plugin-iteratively] waiting to retry (" + (int)(attempt + true) + ')');
                        IterativelyPlugin.this.retryPolicy.sleep((int)attempt);
                    }
                    catch (InterruptedException e) {
                        IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("[plugin-iteratively] Thread interrupted waiting to retry upload after " + (int)attempt + " attempts.");
                        return;
                    }
                    if (attempt == n2) break;
                    ++attempt;
                }
            }
            IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).error("[plugin-iteratively] Failed to upload " + this.batch.size() + " events. Maximum attempts exceeded.");
        }

        private final boolean upload() {
            try {
                IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("[plugin-iteratively] Post (batch1): " + this.batch);
                Response response = this.postJson(IterativelyPlugin.this.config.getUrl(), IterativelyPlugin.this.getTrackModelJson(this.batch));
                response.close();
                int code = response.code();
                if (response.isSuccessful()) {
                    IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("Upload complete.");
                    return false;
                }
                int n = response.code();
                if (500 <= n && 599 >= n) {
                    IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("Upload received error response from server (" + code + ").");
                    return true;
                }
                if (response.code() == 429) {
                    IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("Upload rejected due to rate limiting (" + code + ").");
                    return true;
                }
                IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("Upload failed due to unhandled HTTP error (" + code + ").");
                return false;
            }
            catch (InterruptedException e) {
                IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).error("Thread was interrupted before upload could complete.");
                return false;
            }
            catch (IOException e) {
                if (Intrinsics.areEqual((Object)e.getMessage(), (Object)"interrupted")) {
                    IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).error("Thread was interrupted before upload could complete.(IOException).");
                    return false;
                }
                IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).error("Upload failed due to IOException (" + e.getMessage() + ").");
                return true;
            }
            catch (ConnectException e) {
                IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).error("Error connecting to server.");
                return true;
            }
            catch (Exception e) {
                IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).error("A unhandled exception occurred. " + e.getMessage());
                return false;
            }
        }

        private final Response postJson(String url, String json) throws IOException {
            IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("[plugin-iteratively] Post JSON: " + json);
            RequestBody requestBody = RequestBody.Companion.create(json, IterativelyPluginKt.getJSON_MEDIA_TYPE());
            Request request = new Request.Builder().url(url).addHeader("Content-Type", "application/json").post(requestBody).build();
            return IterativelyPlugin.this.client.newCall(request).execute();
        }

        public Upload(List<TrackModel> batch) {
            Intrinsics.checkParameterIsNotNull(batch, (String)"batch");
            this.batch = batch;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lly/iterative/itly/iteratively/IterativelyPlugin$Companion;", "", "()V", "ID", "", "JSONObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "LOG_TAG", "plugin-iteratively"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

