/*
 * Decompiled with CFR 0.152.
 */
package ly.iterative.itly.iteratively;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.segment.backo.Backo;
import java.io.IOException;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import ly.iterative.itly.Environment;
import ly.iterative.itly.Event;
import ly.iterative.itly.Logger;
import ly.iterative.itly.Plugin;
import ly.iterative.itly.PluginLoadOptions;
import ly.iterative.itly.Properties;
import ly.iterative.itly.ValidationResponse;
import ly.iterative.itly.iteratively.AuthInterceptor;
import ly.iterative.itly.iteratively.IterativelyOptions;
import ly.iterative.itly.iteratively.IterativelyPluginKt;
import ly.iterative.itly.iteratively.RetryOptions;
import ly.iterative.itly.iteratively.TrackModel;
import ly.iterative.itly.iteratively.TrackType;
import ly.iterative.itly.iteratively.Validation;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0001\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 :2\u00020\u0001:\u0004:;<=B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u0016\u0010\u001f\u001a\u00020\u00032\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00170!H\u0002J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0004\u001a\u00020#H\u0016J2\u0010$\u001a\u00020\u001d2\b\u0010%\u001a\u0004\u0018\u00010\u00032\u0006\u0010&\u001a\u00020\u00032\b\u0010'\u001a\u0004\u0018\u00010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0!H\u0016J*\u0010+\u001a\u00020\u001d2\b\u0010%\u001a\u0004\u0018\u00010\u00032\b\u0010'\u001a\u0004\u0018\u00010(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0!H\u0016J(\u0010,\u001a\u00020\u001d2\b\u0010%\u001a\u0004\u0018\u00010\u00032\u0006\u0010-\u001a\u00020.2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020*0!H\u0016J\u0010\u0010/\u001a\u00020\u001d2\u0006\u00100\u001a\u00020\u0017H\u0002J,\u00101\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u000103022\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010402H\u0002J\b\u00105\u001a\u00020\u001dH\u0016J4\u00106\u001a\u00020\u00172\u0006\u00107\u001a\u0002082\n\b\u0002\u0010-\u001a\u0004\u0018\u00010.2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(2\n\b\u0002\u00109\u001a\u0004\u0018\u00010*H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lly/iterative/itly/iteratively/IterativelyPlugin;", "Lly/iterative/itly/Plugin;", "apiKey", "", "options", "Lly/iterative/itly/iteratively/IterativelyOptions;", "(Ljava/lang/String;Lly/iterative/itly/iteratively/IterativelyOptions;)V", "client", "Lokhttp3/OkHttpClient;", "config", "Lly/iterative/itly/iteratively/IterativelyPlugin$Config;", "getConfig", "()Lly/iterative/itly/iteratively/IterativelyPlugin$Config;", "disabled", "", "isExternalNetworkExecutor", "isShutdown", "logger", "Lly/iterative/itly/Logger;", "mainExecutor", "Ljava/util/concurrent/ExecutorService;", "queue", "Ljava/util/concurrent/BlockingQueue;", "Lly/iterative/itly/iteratively/TrackModel;", "retryPolicy", "Lcom/segment/backo/Backo;", "scheduledExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "assertNotShutdown", "", "flush", "getTrackModelJson", "trackModels", "", "load", "Lly/iterative/itly/PluginLoadOptions;", "postGroup", "userId", "groupId", "properties", "Lly/iterative/itly/Properties;", "validationResults", "Lly/iterative/itly/ValidationResponse;", "postIdentify", "postTrack", "event", "Lly/iterative/itly/Event;", "push", "trackModel", "sanitizeValues", "", "", "", "shutdown", "toTrackModel", "type", "Lly/iterative/itly/iteratively/TrackType;", "validation", "Companion", "Config", "PollTrackingQueue", "Upload", "plugin-iteratively"})
public final class IterativelyPlugin
extends Plugin {
    @NotNull
    private final Config config;
    private boolean disabled;
    private final OkHttpClient client;
    private final Backo retryPolicy;
    private final BlockingQueue<TrackModel> queue;
    private final ExecutorService mainExecutor;
    private final ScheduledExecutorService scheduledExecutor;
    private final boolean isExternalNetworkExecutor;
    private boolean isShutdown;
    private Logger logger;
    @NotNull
    public static final String ID = "iteratively";
    @NotNull
    public static final String LOG_TAG = "[plugin-iteratively]";
    private static final ObjectMapper JSONObjectMapper;
    @JvmField
    @NotNull
    public static final String DEFAULT_DATAPLANE_URL = "https://data.us-east-2.iterative.ly/t";
    public static final Companion Companion;

    @NotNull
    public final Config getConfig() {
        return this.config;
    }

    public void load(@NotNull PluginLoadOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        Logger logger = this.logger = options.getLogger();
        if (logger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        logger.info("[plugin-iteratively] load");
        Boolean bl = this.config.getDisabled();
        boolean bl2 = bl != null ? bl : (this.disabled = options.getEnvironment() == Environment.PRODUCTION);
        if (this.disabled) {
            Logger logger2 = this.logger;
            if (logger2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger2.info("[plugin-iteratively] disabled");
            return;
        }
        this.mainExecutor.submit(new PollTrackingQueue());
        this.scheduledExecutor.scheduleAtFixedRate(new Runnable(this){
            final /* synthetic */ IterativelyPlugin this$0;

            public final void run() {
                this.this$0.flush();
            }
            {
                this.this$0 = iterativelyPlugin;
            }
        }, this.config.getFlushIntervalMs(), this.config.getFlushIntervalMs(), TimeUnit.MILLISECONDS);
    }

    public void postGroup(@Nullable String userId, @NotNull String groupId, @Nullable Properties properties, @NotNull List<ValidationResponse> validationResults) {
        Object v0;
        IterativelyPlugin iterativelyPlugin;
        IterativelyPlugin iterativelyPlugin2;
        TrackType trackType;
        Event event;
        Properties properties2;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
            Intrinsics.checkParameterIsNotNull(validationResults, (String)"validationResults");
            Iterable iterable = validationResults;
            properties2 = properties;
            event = null;
            trackType = TrackType.group;
            iterativelyPlugin2 = this;
            iterativelyPlugin = this;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                ValidationResponse it = (ValidationResponse)t;
                boolean bl3 = false;
                if (!(!it.getValid())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object var18_18 = v0;
        iterativelyPlugin.push(IterativelyPlugin.toTrackModel$default(iterativelyPlugin2, trackType, event, properties2, var18_18, 2, null));
    }

    public void postIdentify(@Nullable String userId, @Nullable Properties properties, @NotNull List<ValidationResponse> validationResults) {
        Object v0;
        IterativelyPlugin iterativelyPlugin;
        IterativelyPlugin iterativelyPlugin2;
        TrackType trackType;
        Event event;
        Properties properties2;
        block1: {
            Intrinsics.checkParameterIsNotNull(validationResults, (String)"validationResults");
            Iterable iterable = validationResults;
            properties2 = properties;
            event = null;
            trackType = TrackType.identify;
            iterativelyPlugin2 = this;
            iterativelyPlugin = this;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                ValidationResponse it = (ValidationResponse)t;
                boolean bl3 = false;
                if (!(!it.getValid())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object var17_17 = v0;
        iterativelyPlugin.push(IterativelyPlugin.toTrackModel$default(iterativelyPlugin2, trackType, event, properties2, var17_17, 2, null));
    }

    public void postTrack(@Nullable String userId, @NotNull Event event, @NotNull List<ValidationResponse> validationResults) {
        Object v0;
        IterativelyPlugin iterativelyPlugin;
        IterativelyPlugin iterativelyPlugin2;
        TrackType trackType;
        Event event2;
        Properties properties;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Intrinsics.checkParameterIsNotNull(validationResults, (String)"validationResults");
            Iterable iterable = validationResults;
            properties = (Properties)event;
            event2 = event;
            trackType = TrackType.track;
            iterativelyPlugin2 = this;
            iterativelyPlugin = this;
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                ValidationResponse it = (ValidationResponse)t;
                boolean bl3 = false;
                if (!(!it.getValid())) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Object var17_17 = v0;
        iterativelyPlugin.push(iterativelyPlugin2.toTrackModel(trackType, event2, properties, var17_17));
    }

    public void flush() {
        this.push(TrackModel.Companion.newPoisonPill());
    }

    public void shutdown() {
        if (this.isShutdown) {
            return;
        }
        this.isShutdown = true;
        this.queue.clear();
        this.mainExecutor.shutdownNow();
        this.scheduledExecutor.shutdownNow();
        this.client.dispatcher().cancelAll();
        this.client.dispatcher().executorService().shutdownNow();
        this.client.connectionPool().evictAll();
        if (!this.isExternalNetworkExecutor && !this.config.getNetworkExecutor().isShutdown()) {
            this.config.getNetworkExecutor().shutdownNow();
        }
    }

    private final void assertNotShutdown() {
        boolean bl = !this.isShutdown;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "plugin-iteratively was shutdown. Tracking is no longer operational.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final TrackModel toTrackModel(TrackType type, Event event, Properties properties, ValidationResponse validation) {
        Map map;
        String details;
        String string;
        boolean valid;
        ValidationResponse validationResponse = validation;
        boolean bl = valid = validationResponse != null ? validationResponse.getValid() : true;
        if (this.config.getOmitValues()) {
            string = "";
        } else {
            string = validation;
            if (string == null || (string = string.getMessage()) == null) {
                string = details = "";
            }
        }
        if (this.config.getOmitValues() && properties != null) {
            map = this.sanitizeValues(properties.getProperties());
        } else {
            Properties properties2 = properties;
            map = properties2 != null ? properties2.getProperties() : null;
        }
        Map sanitizedProperties = map;
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"UUID.randomUUID().toString()");
        Event event2 = event;
        Event event3 = event;
        Event event4 = event;
        return new TrackModel(type, string2, null, event2 != null ? event2.getId() : null, event3 != null ? event3.getVersion() : null, event4 != null ? event4.getName() : null, sanitizedProperties, valid, new Validation(details), 4, null);
    }

    static /* synthetic */ TrackModel toTrackModel$default(IterativelyPlugin iterativelyPlugin, TrackType trackType, Event event, Properties properties, ValidationResponse validationResponse, int n, Object object) {
        if ((n & 2) != 0) {
            event = null;
        }
        if ((n & 4) != 0) {
            properties = null;
        }
        if ((n & 8) != 0) {
            validationResponse = null;
        }
        return iterativelyPlugin.toTrackModel(trackType, event, properties, validationResponse);
    }

    private final Map sanitizeValues(Map<String, ? extends Object> properties) {
        Iterable $this$associateWith$iv = properties.keySet();
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            Object v = null;
            map.put(t, v);
        }
        return result$iv;
    }

    private final void push(TrackModel trackModel) {
        if (this.disabled) {
            return;
        }
        if (trackModel.getType() != TrackType.POISON) {
            Logger logger = this.logger;
            if (logger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger.debug("[plugin-iteratively] Queueing '" + trackModel.getEventName() + "' type:'" + (Object)((Object)trackModel.getType()) + '\'');
        }
        try {
            this.queue.put(trackModel);
        }
        catch (InterruptedException e) {
            Logger logger = this.logger;
            if (logger == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
            }
            logger.error("[plugin-iteratively] Error: Queueing was interrupted for '" + (Object)((Object)trackModel.getType()) + "'. " + e.getMessage());
        }
    }

    private final String getTrackModelJson(List<TrackModel> trackModels) {
        String tp = this.config.getVersion() != null ? "\"trackingPlanVersion\":\"" + this.config.getVersion() + "\"," : "";
        String bn = this.config.getBranch() != null ? "\"branchName\":\"" + this.config.getBranch() + "\"," : "";
        return '{' + tp + bn + "\"objects\":" + JSONObjectMapper.writeValueAsString(trackModels) + '}';
    }

    public final boolean disabled() {
        return this.disabled;
    }

    public IterativelyPlugin(@NotNull String apiKey, @NotNull IterativelyOptions options) {
        RetryOptions retryOptions;
        ExecutorService executorService;
        Intrinsics.checkParameterIsNotNull((Object)apiKey, (String)"apiKey");
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        super(ID);
        String string = options.getUrl();
        if (string == null) {
            string = DEFAULT_DATAPLANE_URL;
        }
        String string2 = options.getBranch();
        String string3 = options.getVersion();
        Boolean bl = options.getOmitValues();
        boolean bl2 = bl != null ? bl : false;
        Integer n = options.getBatchSize();
        int n2 = n != null ? n : 100;
        Long l = options.getFlushQueueSize();
        long l2 = l != null ? l : 10L;
        Long l3 = options.getFlushIntervalMs();
        long l4 = l3 != null ? l3 : 10000L;
        Boolean bl3 = options.getDisabled();
        ThreadFactory threadFactory = options.getThreadFactory();
        if (threadFactory == null) {
            threadFactory = IterativelyPluginKt.getDEFAULT_THREAD_FACTORY();
        }
        if ((executorService = options.getNetworkExecutor()) == null) {
            ThreadFactory threadFactory2 = options.getThreadFactory();
            if (threadFactory2 == null) {
                threadFactory2 = IterativelyPluginKt.getDEFAULT_THREAD_FACTORY();
            }
            executorService = IterativelyPluginKt.newDefaultExecutorService(threadFactory2);
        }
        if ((retryOptions = options.getRetryOptions()) == null) {
            retryOptions = new RetryOptions(0, 0L, 0L, 7, null);
        }
        this.config = new Config(string, string2, string3, bl2, n2, l2, l4, bl3, threadFactory, executorService, retryOptions);
        Boolean bl4 = this.config.getDisabled();
        this.disabled = bl4 != null ? bl4 : false;
        this.mainExecutor = IterativelyPluginKt.newDefaultExecutorService(this.config.getThreadFactory());
        ScheduledExecutorService scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(this.config.getThreadFactory());
        Intrinsics.checkExpressionValueIsNotNull((Object)scheduledExecutorService, (String)"Executors.newSingleThrea\u2026tor(config.threadFactory)");
        this.scheduledExecutor = scheduledExecutorService;
        this.queue = new LinkedBlockingQueue();
        this.isExternalNetworkExecutor = options.getNetworkExecutor() != null;
        this.isShutdown = false;
        OkHttpClient okHttpClient = new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthInterceptor(apiKey)).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"OkHttpClient.Builder()\n/\u2026\n                .build()");
        this.client = okHttpClient;
        Backo backo = Backo.builder().base(TimeUnit.MILLISECONDS, this.config.getRetryOptions().getDelayInitialMillis()).cap(TimeUnit.MILLISECONDS, this.config.getRetryOptions().getDelayMaximumMillis()).jitter(1).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)backo, (String)"Backo.builder()\n        \u2026r(1)\n            .build()");
        this.retryPolicy = backo;
    }

    public /* synthetic */ IterativelyPlugin(String string, IterativelyOptions iterativelyOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            iterativelyOptions = new IterativelyOptions(null, null, null, null, null, null, null, null, null, null, null, 2047, null);
        }
        this(string, iterativelyOptions);
    }

    static {
        Companion = new Companion(null);
        JSONObjectMapper = ExtensionsKt.jacksonObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        DEFAULT_DATAPLANE_URL = DEFAULT_DATAPLANE_URL;
    }

    public static final /* synthetic */ Logger access$getLogger$p(IterativelyPlugin $this) {
        Logger logger = $this.logger;
        if (logger == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"logger");
        }
        return logger;
    }

    public static final /* synthetic */ void access$setLogger$p(IterativelyPlugin $this, Logger logger) {
        $this.logger = logger;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\u0018\u00002\u00020\u0001Bc\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001e\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0018R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010\u0018\u00a8\u0006+"}, d2={"Lly/iterative/itly/iteratively/IterativelyPlugin$Config;", "", "url", "", "branch", "version", "omitValues", "", "batchSize", "", "flushQueueSize", "", "flushIntervalMs", "disabled", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "networkExecutor", "Ljava/util/concurrent/ExecutorService;", "retryOptions", "Lly/iterative/itly/iteratively/RetryOptions;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZIJJLjava/lang/Boolean;Ljava/util/concurrent/ThreadFactory;Ljava/util/concurrent/ExecutorService;Lly/iterative/itly/iteratively/RetryOptions;)V", "getBatchSize", "()I", "getBranch", "()Ljava/lang/String;", "getDisabled", "()Ljava/lang/Boolean;", "setDisabled", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getFlushIntervalMs", "()J", "getFlushQueueSize", "getNetworkExecutor", "()Ljava/util/concurrent/ExecutorService;", "getOmitValues", "()Z", "getRetryOptions", "()Lly/iterative/itly/iteratively/RetryOptions;", "getThreadFactory", "()Ljava/util/concurrent/ThreadFactory;", "getUrl", "getVersion", "plugin-iteratively"})
    public static final class Config {
        @NotNull
        private final String url;
        @Nullable
        private final String branch;
        @Nullable
        private final String version;
        private final boolean omitValues;
        private final int batchSize;
        private final long flushQueueSize;
        private final long flushIntervalMs;
        @Nullable
        private Boolean disabled;
        @NotNull
        private final ThreadFactory threadFactory;
        @NotNull
        private final ExecutorService networkExecutor;
        @NotNull
        private final RetryOptions retryOptions;

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        @Nullable
        public final String getBranch() {
            return this.branch;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        public final boolean getOmitValues() {
            return this.omitValues;
        }

        public final int getBatchSize() {
            return this.batchSize;
        }

        public final long getFlushQueueSize() {
            return this.flushQueueSize;
        }

        public final long getFlushIntervalMs() {
            return this.flushIntervalMs;
        }

        @Nullable
        public final Boolean getDisabled() {
            return this.disabled;
        }

        public final void setDisabled(@Nullable Boolean bl) {
            this.disabled = bl;
        }

        @NotNull
        public final ThreadFactory getThreadFactory() {
            return this.threadFactory;
        }

        @NotNull
        public final ExecutorService getNetworkExecutor() {
            return this.networkExecutor;
        }

        @NotNull
        public final RetryOptions getRetryOptions() {
            return this.retryOptions;
        }

        public Config(@NotNull String url, @Nullable String branch, @Nullable String version, boolean omitValues, int batchSize, long flushQueueSize, long flushIntervalMs, @Nullable Boolean disabled, @NotNull ThreadFactory threadFactory, @NotNull ExecutorService networkExecutor, @NotNull RetryOptions retryOptions) {
            Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
            Intrinsics.checkParameterIsNotNull((Object)threadFactory, (String)"threadFactory");
            Intrinsics.checkParameterIsNotNull((Object)networkExecutor, (String)"networkExecutor");
            Intrinsics.checkParameterIsNotNull((Object)retryOptions, (String)"retryOptions");
            this.url = url;
            this.branch = branch;
            this.version = version;
            this.omitValues = omitValues;
            this.batchSize = batchSize;
            this.flushQueueSize = flushQueueSize;
            this.flushIntervalMs = flushIntervalMs;
            this.disabled = disabled;
            this.threadFactory = threadFactory;
            this.networkExecutor = networkExecutor;
            this.retryOptions = retryOptions;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lly/iterative/itly/iteratively/IterativelyPlugin$PollTrackingQueue;", "Ljava/lang/Runnable;", "(Lly/iterative/itly/iteratively/IterativelyPlugin;)V", "run", "", "plugin-iteratively"})
    public final class PollTrackingQueue
    implements Runnable {
        @Override
        public void run() {
            boolean bl = false;
            List pending = new ArrayList();
            try {
                while (true) {
                    TrackModel track;
                    boolean isPoisonPill;
                    boolean bl2 = isPoisonPill = (track = (TrackModel)IterativelyPlugin.this.queue.take()).getType() == TrackType.POISON;
                    if (!isPoisonPill) {
                        TrackModel trackModel = track;
                        Intrinsics.checkExpressionValueIsNotNull((Object)trackModel, (String)"track");
                        pending.add(trackModel);
                    } else if (pending.size() < 1) {
                        IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("[plugin-iteratively] Flush received. No pending items.");
                        continue;
                    }
                    if ((long)pending.size() < IterativelyPlugin.this.getConfig().getFlushQueueSize() && !isPoisonPill) continue;
                    IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("[plugin-iteratively] Posting " + pending.size() + " track items to " + IterativelyPlugin.this.getConfig().getUrl() + '.');
                    IterativelyPlugin.this.getConfig().getNetworkExecutor().submit(new Upload(pending));
                    boolean bl3 = false;
                    pending = new ArrayList();
                }
            }
            catch (InterruptedException e) {
                IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("[plugin-iteratively] Processing thread was interrupted.");
                return;
            }
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lly/iterative/itly/iteratively/IterativelyPlugin$Upload;", "Ljava/lang/Runnable;", "batch", "", "Lly/iterative/itly/iteratively/TrackModel;", "(Lly/iterative/itly/iteratively/IterativelyPlugin;Ljava/util/List;)V", "postJson", "Lokhttp3/Response;", "url", "", "json", "run", "", "upload", "", "plugin-iteratively"})
    public final class Upload
    implements Runnable {
        private final List<TrackModel> batch;

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            int n = 0;
            int n2 = IterativelyPlugin.this.getConfig().getRetryOptions().getMaxRetries();
            if (n <= n2) {
                while (true) {
                    void attempt;
                    boolean retry;
                    if (!(retry = this.upload())) {
                        return;
                    }
                    try {
                        IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("[plugin-iteratively] waiting to retry (" + (int)(attempt + true) + ')');
                        IterativelyPlugin.this.retryPolicy.sleep((int)attempt);
                    }
                    catch (InterruptedException e) {
                        IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("[plugin-iteratively] Thread interrupted waiting to retry upload after " + (int)attempt + " attempts.");
                        return;
                    }
                    if (attempt == n2) break;
                    ++attempt;
                }
            }
            IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).error("[plugin-iteratively] Failed to upload " + this.batch.size() + " events. Maximum attempts exceeded.");
        }

        private final boolean upload() {
            try {
                IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("[plugin-iteratively] Post (batch1): " + this.batch);
                Response response = this.postJson(IterativelyPlugin.this.getConfig().getUrl(), IterativelyPlugin.this.getTrackModelJson(this.batch));
                response.close();
                int code = response.code();
                if (response.isSuccessful()) {
                    IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("Upload complete.");
                    return false;
                }
                int n = code;
                if (500 <= n && 599 >= n) {
                    IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("Upload received error response from server (" + code + ").");
                    return true;
                }
                if (code == 429) {
                    IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("Upload rejected due to rate limiting (" + code + ").");
                    return true;
                }
                IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("Upload failed due to unhandled HTTP error (" + code + ").");
                return false;
            }
            catch (InterruptedException e) {
                IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).error("Thread was interrupted before upload could complete.");
                return false;
            }
            catch (IOException e) {
                if (Intrinsics.areEqual((Object)e.getMessage(), (Object)"interrupted")) {
                    IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).error("Thread was interrupted before upload could complete.(IOException).");
                    return false;
                }
                IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).error("Upload failed due to IOException (" + e.getMessage() + ").");
                return true;
            }
            catch (ConnectException e) {
                IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).error("Error connecting to server.");
                return true;
            }
            catch (Exception e) {
                IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).error("A unhandled exception occurred. " + e.getMessage());
                return false;
            }
        }

        private final Response postJson(String url, String json) throws IOException {
            IterativelyPlugin.access$getLogger$p(IterativelyPlugin.this).debug("[plugin-iteratively] Post JSON: " + json);
            RequestBody requestBody = RequestBody.create((MediaType)IterativelyPluginKt.getJSON_MEDIA_TYPE(), (String)json);
            Request request = new Request.Builder().url(url).addHeader("Content-Type", "application/json").post(requestBody).build();
            Response response = IterativelyPlugin.this.client.newCall(request).execute();
            Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"client.newCall(request).execute()");
            return response;
        }

        public Upload(List<TrackModel> batch) {
            Intrinsics.checkParameterIsNotNull(batch, (String)"batch");
            this.batch = batch;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lly/iterative/itly/iteratively/IterativelyPlugin$Companion;", "", "()V", "DEFAULT_DATAPLANE_URL", "", "ID", "JSONObjectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "kotlin.jvm.PlatformType", "LOG_TAG", "plugin-iteratively"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

