package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;

import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.views.adapters.ActiveCouponAdapter;


public class ActiveCouponsActivity extends Activity implements View.OnClickListener {

    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================

    private ImageView mIvBack;
    private RecyclerView mRecyclerCoupons;
    private ActiveCouponAdapter mAdapterCoupons;
    private CouponList mCouponList = new CouponList();
    private TextView mTvEmptyCoupons;
    private boolean mCouponsPressed = false;

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_active_coupons);

        mIvBack = findViewById(R.id.iv_coupons_close);
        mTvEmptyCoupons = findViewById(R.id.tv_no_coupons);
        mRecyclerCoupons = findViewById(R.id.rv_active_coupons);

        initViews();
    }

    @Override
    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent(this, "screen", "ActiveCouponsScreen");
        mCouponsPressed = false;
        filterItems();
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.iv_coupons_close) {
            onBackPressed();
        }
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(ViewPumpContextWrapper.wrap(newBase));
    }

    // ===========================================================
    // Methods
    // ===========================================================

    private void initViews() {
        mIvBack.setOnClickListener(this);
    }

    private void filterItems() {
        CouponList cpnlist = new CouponList();
        for (Coupon cpn : WarplyManagerHelper.getCouponList()) {
            if (cpn.getStatus() == 1) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                Date newDate = new Date();
                try {
                    newDate = simpleDateFormat.parse(cpn.getExpiration());
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                cpn.setExpirationDate(newDate);
                cpnlist.add(cpn);
            }
        }
        Collections.sort(cpnlist, (coupon1, coupon2) -> coupon1.getExpirationDate().compareTo(coupon2.getExpirationDate()));
        mCouponList.clear();
        mCouponList.addAll(cpnlist);

        if (mCouponList != null && mCouponList.size() > 0) {
            mRecyclerCoupons.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
            mAdapterCoupons = new ActiveCouponAdapter(this, mCouponList);
            mRecyclerCoupons.setAdapter(mAdapterCoupons);
            mAdapterCoupons.getPositionClicks()
                    .doOnNext(coupon -> {
                        if (!mCouponsPressed) {
                            mCouponsPressed = true;
                            WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Coupon").concat(":").concat(coupon.getName()));
                            Intent intent = new Intent(ActiveCouponsActivity.this, CouponInfoActivity.class);
                            intent.putExtra("coupon", (Serializable) coupon);
                            startActivity(intent);
                        }
                    })
                    .doOnError(error -> {
                    })
                    .subscribe();
        } else {
            mTvEmptyCoupons.setVisibility(View.VISIBLE);
        }
    }

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================

}
