package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import java.io.Serializable;
import java.util.ArrayList;

import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.MergedActiveGifts;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.views.adapters.MergedActiveGiftsAdapter;


public class ActiveGiftsActivity extends Activity implements View.OnClickListener {

    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================

    private ImageView mIvBack;
    private ArrayList<MergedActiveGifts> mData = new ArrayList();
    private RecyclerView mRecyclerMergedActiveGifts;
    private MergedActiveGiftsAdapter mAdapterMergedActiveGifts;

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_active_gifts);

        mergeDatasets(
                /*WarplyManagerHelper.getUniqueCampaignList().get("gifts_for_you")*/null,
                WarplyManagerHelper.getCouponList()
        );

        mIvBack = findViewById(R.id.iv_list_close);

        mRecyclerMergedActiveGifts = findViewById(R.id.rv_merged_active_gifts);

        initViews();
    }

    @Override
    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent(this, "screen", "ActiveGiftsScreen");
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.iv_list_close) {
            onBackPressed();
            return;
        }
    }

    // ===========================================================
    // Methods
    // ===========================================================

    private void initViews() {
        mIvBack.setOnClickListener(this);

        if (mData != null && mData.size() > 0) {
            mRecyclerMergedActiveGifts.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
            mAdapterMergedActiveGifts = new MergedActiveGiftsAdapter(this, mData);
            mRecyclerMergedActiveGifts.setAdapter(mAdapterMergedActiveGifts);
            mAdapterMergedActiveGifts.getPositionClicks()
                    .doOnNext(dataItem -> {
                        if (dataItem.getDataType() == 1) {
                            startActivity(WarpViewActivity.createIntentFromURL(this, WarplyManagerHelper.constructCampaignUrl(dataItem.getCampaign())));
                        } else if (dataItem.getDataType() == 2) {
                            Intent intent = new Intent(ActiveGiftsActivity.this, CouponInfoActivity.class);
                            intent.putExtra("coupon", (Serializable) dataItem.getCoupon());
                            startActivity(intent);
                        }
                    })
                    .doOnError(error -> {
                    })
                    .subscribe();
        } else {
//            mClCouponsOuter.setVisibility(View.GONE);
        }
    }

    private ArrayList<MergedActiveGifts> mergeDatasets(CampaignList campaignList, CouponList couponsList) {
        if (campaignList != null && campaignList.size() > 0) {
            for (Campaign campaign : campaignList) {
                MergedActiveGifts data = new MergedActiveGifts();
                data.setCampaign(campaign);
                data.setCoupon(null);
                data.setDataType(1);
                mData.add(data);
            }
        }

        if (couponsList.size() > 0) {
            for (Coupon coupon : couponsList) {
                MergedActiveGifts data = new MergedActiveGifts();
                data.setCampaign(null);
                data.setCoupon(coupon);
                data.setDataType(2);
                mData.add(data);
            }
        }

        return mData;
    }

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================

}
