package ly.warp.sdk.activities;

import android.os.Bundle;
import android.view.MenuItem;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;

import com.google.android.material.bottomnavigation.BottomNavigationView;
import com.google.android.material.navigation.NavigationBarView;

import java.util.ArrayList;
import java.util.HashMap;

import ly.warp.sdk.R;
import ly.warp.sdk.fragments.HomeFragment;
import ly.warp.sdk.fragments.LoyaltyFragment;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.io.models.Consumer;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.request.WarplyGetCampaignsRequest;
import ly.warp.sdk.utils.managers.WarplyManager;

public class BaseFragmentActivity extends FragmentActivity implements NavigationBarView.OnItemSelectedListener {

    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================

    private BottomNavigationView mBottomNavigationView;
    private Fragment mFragmentToSet = null;

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_base_fragment);

        mBottomNavigationView = findViewById(R.id.bt_tabs);

//            WarplyManager.getUserCouponsWithCouponsets(new WarplyUserCouponsRequest(), mUserCouponsReceiver);
        WarplyManager.getUserCouponsWithCouponsets(mUserCouponsReceiver);
        WarplyManager.getCampaigns(new WarplyGetCampaignsRequest().setLanguage("en"), mCampaignsCallback);
    }

    @Override
    protected void onStart() {
        super.onStart();
    }

    @Override
    protected void onStop() {
        super.onStop();
    }

    @Override
    protected void onResume() {
        super.onResume();
        initViews();
    }

    @Override
    public boolean onNavigationItemSelected(@NonNull MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == R.id.menu_loyalty) {
            mFragmentToSet = LoyaltyFragment.newInstance();
            getSupportFragmentManager().beginTransaction()
                    .replace(R.id.fl_fragment, mFragmentToSet)
                    .addToBackStack(null)
                    .commit();
            return true;
        } else if (itemId == R.id.menu_home) {
            mFragmentToSet = HomeFragment.newInstance();
            getSupportFragmentManager().beginTransaction()
                    .replace(R.id.fl_fragment, mFragmentToSet)
                    .addToBackStack(null)
                    .commit();
            return true;
        }
        return false;
    }

    // ===========================================================
    // Methods
    // ===========================================================

    private void initViews() {
        mBottomNavigationView.setOnItemSelectedListener(this);
        mFragmentToSet = HomeFragment.newInstance();
        getSupportFragmentManager().beginTransaction().add(R.id.fl_fragment, mFragmentToSet).commit();
        mBottomNavigationView.setSelectedItemId(R.id.menu_home);
    }

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================

    private final CallbackReceiver<ArrayList<Campaign>> mCampaignsCallback = new CallbackReceiver<ArrayList<Campaign>>() {
        @Override
        public void onSuccess(ArrayList<Campaign> result) {
            Toast.makeText(BaseFragmentActivity.this, "Campaigns Success", Toast.LENGTH_SHORT).show();
        }

        @Override
        public void onFailure(int errorCode) {
            Toast.makeText(BaseFragmentActivity.this, "Campaigns Error", Toast.LENGTH_SHORT).show();
        }
    };

    private final CallbackReceiver<CouponList> mUserCouponsReceiver = new CallbackReceiver<CouponList>() {
        @Override
        public void onSuccess(CouponList result) {
            Toast.makeText(BaseFragmentActivity.this, "Coupons Success " + String.valueOf(result.size()), Toast.LENGTH_SHORT).show();
        }

        @Override
        public void onFailure(int errorCode) {
            Toast.makeText(BaseFragmentActivity.this, "Coupons Error", Toast.LENGTH_SHORT).show();
        }
    };

}
