package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.google.android.material.bottomsheet.BottomSheetDialog;

import org.greenrobot.eventbus.EventBus;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import ly.warp.sdk.R;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Consumer;
import ly.warp.sdk.io.models.LoyaltyContextualOfferModel;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.WarplyCCMSEnabledModel;
import ly.warp.sdk.io.request.CosmoteSubmitOrderRequest;
import ly.warp.sdk.io.request.WarplyConsumerRequest;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;


public class ContextualActivity extends Activity implements View.OnClickListener {

    // ===========================================================
    // Constants
    // ===========================================================

    private final String MSISDN_LIST = "msisdnList";

    // ===========================================================
    // Fields
    // ===========================================================

    private ImageView mIvBack, mIvCampaignPhoto;
    private TextView mTvCampaignTitle, mTvCampaignSubtitle;
    private LoyaltyContextualOfferModel mCCMS = new LoyaltyContextualOfferModel();
    private LinearLayout mLlActivateOffer;
    private Consumer mConsumer;
    private String mSender = "";
    private AlertDialog mAlertDialogAskActivate, mAlertDialogErrorActivating, mAlertDialogSuccessActivating;

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_contextual);

        mCCMS = (LoyaltyContextualOfferModel) getIntent().getSerializableExtra("ccms");

        mIvBack = findViewById(R.id.iv_contextual_back);
        mTvCampaignTitle = findViewById(R.id.textView13);
        mIvCampaignPhoto = findViewById(R.id.imageView6);
        mTvCampaignSubtitle = findViewById(R.id.textView14);
        mLlActivateOffer = findViewById(R.id.ll_activate_button);

        initViews();
    }

    @Override
    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent(this, "screen", "ContextualScreen");

//        new Thread(() -> {
//            if (!Thread.currentThread().isInterrupted()) {
//                WarplyManager.getConsumer(new WarplyConsumerRequest()
//                        , mConsumerCallback);
//            }
//            Thread.currentThread().interrupt();
//        }).start();
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.iv_contextual_back) {
            onBackPressed();
            return;
        }
        if (view.getId() == R.id.ll_activate_button) {
            showActivationDialog();
        }
    }

    // ===========================================================
    // Methods
    // ===========================================================

    private void initViews() {
        mTvCampaignTitle.setText(mCCMS.getTitleOffer());
        mTvCampaignSubtitle.setText(mCCMS.getDescription());

        if (!TextUtils.isEmpty(mCCMS.getImageUrl())) {
            Glide.with(this)
//                        .setDefaultRequestOptions(
//                                RequestOptions
//                                        .placeholderOf(R.drawable.ic_default_contact_photo)
//                                        .error(R.drawable.ic_default_contact_photo))
                    .load(mCCMS.getImageUrl())
                    .diskCacheStrategy(DiskCacheStrategy.DATA)
                    .into(mIvCampaignPhoto);
        } else {
            Glide.with(this)
                    .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                    .into(mIvCampaignPhoto);
        }
        mIvBack.setOnClickListener(this);
        mLlActivateOffer.setOnClickListener(this);
    }

    private void showActivationDialog() {
        final BottomSheetDialog bottomSheetDialog = new BottomSheetDialog(this);
        bottomSheetDialog.setContentView(R.layout.dl_share);
        TextView tvHeader = bottomSheetDialog.findViewById(R.id.tv_sender_value);
        tvHeader.setText(R.string.cos_coupon_share_telco);
        LinearLayout parent = bottomSheetDialog.findViewById(R.id.ll_share_dialog_view_inner);

        ImageView dialogClose = (ImageView) bottomSheetDialog.findViewById(R.id.iv_sender_list_close);
        dialogClose.setOnClickListener(view -> bottomSheetDialog.dismiss());

//        if (mConsumer != null) {
//            try {
//                JSONObject profMeta = new JSONObject(mConsumer.getProfileMetadata());
//                if (profMeta != null) {
//                    JSONArray msisdnList = new JSONArray();
//                    msisdnList = profMeta.optJSONArray(MSISDN_LIST);
//                    if (msisdnList != null && msisdnList.length() > 0) {
//                        for (int i = 0; i < msisdnList.length(); i++) {
//                            LayoutInflater vi = (LayoutInflater) getApplicationContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
//                            LinearLayout v = (LinearLayout) vi.inflate(R.layout.item_share, null);
//                            TextView textView = (TextView) v.findViewById(R.id.tv_phone_share);
//                            textView.setText(msisdnList.optString(i));
//                            textView.setOnClickListener(view -> {
//                                TextView tv = (TextView) view;
//                                mSender = tv.getText().toString();
//                                bottomSheetDialog.dismiss();
//                                askActivateDialog();
//                            });
//                            parent.addView(v, 0, new ViewGroup.LayoutParams(
//                                    ViewGroup.LayoutParams.MATCH_PARENT,
//                                    ViewGroup.LayoutParams.WRAP_CONTENT));
//                        }
//                    }
//                }
//            } catch (JSONException e) {
//                e.printStackTrace();
//            }
//        }

        if (mCCMS.getEligibleAssets() != null && mCCMS.getEligibleAssets().size() > 0) {
            for (int i = 0; i < mCCMS.getEligibleAssets().size(); i++) {
                LayoutInflater vi = (LayoutInflater) getApplicationContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                LinearLayout v = (LinearLayout) vi.inflate(R.layout.item_share, null);
                TextView textView = (TextView) v.findViewById(R.id.tv_phone_share);
                textView.setText(mCCMS.getEligibleAssets().get(i));
                textView.setOnClickListener(view -> {
                    TextView tv = (TextView) view;
                    mSender = tv.getText().toString();
                    bottomSheetDialog.dismiss();
                    askActivateDialog();
                });
                parent.addView(v, 0, new ViewGroup.LayoutParams(
                        ViewGroup.LayoutParams.MATCH_PARENT,
                        ViewGroup.LayoutParams.WRAP_CONTENT));
            }
        }

        bottomSheetDialog.show();
    }

    private void activateGift() {
        WarplyAnalyticsManager.logTrackersEvent(this, "click", ("ActivateContextual")
                .concat(":")
                .concat(mCCMS.getSessionId()));

//        new Thread(() -> {
//            if (!Thread.currentThread().isInterrupted()) {
        WarplyManager.submitOrder(new CosmoteSubmitOrderRequest()
                        .setCommunicationUuid("")
                        .setUserMsisdn(mSender)
                        .setSessionId(mCCMS.getSessionId())
                        .setBusinessService(mCCMS.getBusinessService())
                        .setNotificationMessage(mCCMS.getNotificationMessage())
                        .setOfferName(mCCMS.getOfferName())
                        .setProductType(mCCMS.getProductType())
                        .setProvDuration(mCCMS.getProvDuration())
                        .setNoOfRecurrance(mCCMS.getNoOfRecurrance())
                        .setPrice(mCCMS.getPrice())
                        .setDiscount(mCCMS.getDiscount())
                        .setVoiceCategory(mCCMS.getVoiceCategory())
                        .setDataCategory(mCCMS.getDataCategory())
                        .setMinsValue(mCCMS.getMinsValue())
                        .setDataValue(mCCMS.getDataValue())
                        .setProvStepValueMins(mCCMS.getProvStepValueMins())
                        .setOfferAudienceLevel(mCCMS.getOfferAudienceLevel())
                        .setUACIOfferTrackingCode(mCCMS.getUACIOfferTrackingCode())
                        .setOfferCode1(mCCMS.getOfferCode1())
                        .setScore(mCCMS.getScore())
                        .setZone(mCCMS.getZone())
                        .setWave(mCCMS.getWave())
                        .setValidity(mCCMS.getValidity())
                        .setTreatmentCode(mCCMS.getTreatmentCode()),
                mSubmitCallback);
//            }
//            Thread.currentThread().interrupt();
//        }).start();
    }

    private void askActivateDialog() {
        if (!isFinishing()) {
            mAlertDialogAskActivate = new AlertDialog.Builder(this)
                    .setTitle(R.string.cos_dlg_activate_telco_title)
                    .setMessage(R.string.cos_dlg_activate_telco_subtitle)
                    .setPositiveButton(R.string.cos_dlg_positive_button, (dialogPositive, whichPositive) -> {
                        activateGift();
                    })
                    .setNegativeButton(R.string.cos_dlg_negative_button2, (dialogNegative, whichNegative) -> {
                        dialogNegative.dismiss();
                    })
                    .show();
        }
    }

    private void errorActivatingDialog() {
        LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
        analyticsEvent.setEventName("loyalty_offer_activated");
        analyticsEvent.setParameter("name", mCCMS.getTitle());
        analyticsEvent.setParameter("type", "gift");
        analyticsEvent.setParameter("successful", "false");
        EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));

        if (!isFinishing()) {
            mAlertDialogErrorActivating = new AlertDialog.Builder(this)
                    .setTitle(R.string.cos_dlg_error_title)
                    .setMessage(R.string.cos_dlg_error_subtitle)
                    .setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                        dialogPositive.dismiss();
                    })
                    .show();
        }
    }

    private void successActivatingDialog() {
        LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
        analyticsEvent.setEventName("loyalty_offer_activated");
        analyticsEvent.setParameter("name", mCCMS.getTitle());
        analyticsEvent.setParameter("type", "gift");
        analyticsEvent.setParameter("successful", "true");
        EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));

        WarplyCCMSEnabledModel ccmsEnabled = new WarplyCCMSEnabledModel();
        ccmsEnabled.setActivated(true);
        EventBus.getDefault().post(new WarplyEventBusManager(ccmsEnabled));

        if (!isFinishing()) {
            mAlertDialogSuccessActivating = new AlertDialog.Builder(this)
                    .setTitle(R.string.cos_dlg_activate_success_title)
                    .setMessage(R.string.cos_dlg_activate_success_subtitle)
                    .setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                        dialogPositive.dismiss();
                    })
                    .show();
        }
    }

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================

    private final CallbackReceiver<Consumer> mConsumerCallback = new CallbackReceiver<Consumer>() {
        @Override
        public void onSuccess(Consumer result) {
            mConsumer = result;
        }

        @Override
        public void onFailure(int errorCode) {
            Log.v("TELCO_ACTIVITY", String.valueOf(errorCode));
        }
    };

    private CallbackReceiver<JSONObject> mSubmitCallback = new CallbackReceiver<JSONObject>() {
        @Override
        public void onSuccess(JSONObject result) {
            int status = result.optInt("status", 2);
//            runOnUiThread(() -> {
            if (status == 1)
                successActivatingDialog();
            else
                errorActivatingDialog();
//            });
        }

        @Override
        public void onFailure(int errorCode) {
//            runOnUiThread(() -> errorActivatingDialog());
            errorActivatingDialog();
        }
    };
}
