package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.core.content.ContextCompat;
import androidx.core.text.HtmlCompat;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.EAN13Writer;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.Couponset;
import ly.warp.sdk.io.models.Merchant;
import ly.warp.sdk.services.EventCouponsService;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;


public class CouponInfoActivity extends Activity implements View.OnClickListener {

    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================

    private ImageView mIvBack, mIvCouponPhoto, mIvBarcode;
    private TextView mTvTerms, mTvCouponCode, mTvCouponTitle, mTvCouponSubtitle, mTvCouponDate,
            mTvTermsValue, mTvFullBarcode, mTvDescription, mTvCouponCodeTitle;
    private LinearLayout mLlGiftIt, mLlShops, mLlBarcodeShown, mLlBarcodeContainer, mLlTerms, mLlWebsite;
    private Coupon mCoupon;
    private Couponset mCouponset;
    private boolean mIsBarcodeShown = false, mIsTermsShown = false, mIsFromWallet = false,
            mShopsPressed = false, mGiftPressed = false, mEshopPressed = false, mIsUnified = false;
    private Merchant mMerchant;

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_coupon_info);

        mCoupon = (Coupon) getIntent().getSerializableExtra("coupon");
        mIsFromWallet = getIntent().getBooleanExtra("isFromWallet", false);
        mIsUnified = getIntent().getBooleanExtra("isUnified", false);

        mIvBack = findViewById(R.id.iv_coupon_info_back);
        mTvTerms = findViewById(R.id.tv_terms);
        mLlGiftIt = findViewById(R.id.ll_gift_it);
        mTvCouponCode = findViewById(R.id.textView16);
        mTvCouponTitle = findViewById(R.id.textView13);
        mTvCouponSubtitle = findViewById(R.id.textView14);
        mTvCouponDate = findViewById(R.id.textView17);
        mIvCouponPhoto = findViewById(R.id.imageView6);
        mIvBarcode = findViewById(R.id.iv_barcode);
        mLlShops = findViewById(R.id.ll_shops);
        mLlWebsite = findViewById(R.id.ll_website);
        mLlBarcodeShown = findViewById(R.id.ll_show_barcode);
        mLlBarcodeContainer = findViewById(R.id.ll_barcode_container_items);
        mLlTerms = findViewById(R.id.ll_terms_inner);
        mTvTermsValue = findViewById(R.id.tv_terms_value);
        mTvFullBarcode = findViewById(R.id.tv_full_barcode);
        mTvDescription = findViewById(R.id.tv_clickable_link);
        mTvCouponCodeTitle = findViewById(R.id.textView15);

        initViews();
    }

    @Override
    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent(this, "screen", "CouponScreen");
        mShopsPressed = false;
        mGiftPressed = false;
        mEshopPressed = false;
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1001) {
            if (resultCode == RESULT_OK) {
                OneTimeWorkRequest mywork = new OneTimeWorkRequest.Builder(EventCouponsService.class).build();
                WorkManager.getInstance(this).enqueue(mywork);
                onBackPressed();
            }
        }
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.iv_coupon_info_back) {
            onBackPressed();
            return;
        }
        if (view.getId() == R.id.ll_gift_it) {
            if (!mGiftPressed) {
                mGiftPressed = true;
                WarplyAnalyticsManager.logTrackersEvent(this, "click", ("ShareCoupon")
                        .concat(":")
                        .concat(mCoupon.getName()));

                Intent intent = new Intent(CouponInfoActivity.this, CouponShareActivity.class);
                intent.putExtra("coupon", (Serializable) mCoupon);
                intent.putExtra("isFromWallet", mIsFromWallet);
                if (!mIsFromWallet)
                    startActivity(intent);
                else
                    startActivityForResult(intent, 1001);
            }
            return;
        }
        if (view.getId() == R.id.ll_shops) {
            if (!mShopsPressed) {
                mShopsPressed = true;
                WarplyAnalyticsManager.logTrackersEvent(this, "click", "SeeShops");

                if (GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(CouponInfoActivity.this) == ConnectionResult.SUCCESS) {
                    Intent intent = new Intent(CouponInfoActivity.this, ShopsActivity.class);
                    intent.putExtra("couponset", (Serializable) mCouponset);
                    startActivity(intent);
                    return;
                } else {
                    Intent intent = new Intent(CouponInfoActivity.this, ShopsHuaweiActivity.class);
                    intent.putExtra("couponset", (Serializable) mCouponset);
                    startActivity(intent);
                    return;
                }
            }
        }
        if (view.getId() == R.id.ll_website) {
            if (!mEshopPressed) {
                mEshopPressed = true;
                WarplyAnalyticsManager.logTrackersEvent(this, "click", "SeeShopWebsite");

                if (!TextUtils.isEmpty(mMerchant.getWebsite())) {
                    Intent intent = new Intent(Intent.ACTION_VIEW);
                    intent.setData(Uri.parse(mMerchant.getWebsite()));
                    startActivity(intent);
                }
            }
            return;
        }
        if (view.getId() == R.id.ll_show_barcode) {
            if (mIsBarcodeShown) {
                mLlBarcodeContainer.setVisibility(View.GONE);
                TextView barcodeButtonTitle = mLlBarcodeShown.findViewById(R.id.tv_barcode);
                ImageView barcodeButtonArrow = mLlBarcodeShown.findViewById(R.id.iv_barcode_arrow);
                barcodeButtonTitle.setText(getString(R.string.cos_show_barcode));
                barcodeButtonArrow.setImageDrawable(ContextCompat.getDrawable(this, R.drawable.ic_down_dark_new));
                mIsBarcodeShown = false;
            } else {
                mLlBarcodeContainer.setVisibility(View.VISIBLE);
                TextView barcodeButtonTitle = mLlBarcodeShown.findViewById(R.id.tv_barcode);
                ImageView barcodeButtonArrow = mLlBarcodeShown.findViewById(R.id.iv_barcode_arrow);
                barcodeButtonTitle.setText(getString(R.string.cos_hide_barcode));
                barcodeButtonArrow.setImageDrawable(ContextCompat.getDrawable(this, R.drawable.ic_up_dark_new));
                mIsBarcodeShown = true;
            }
            return;
        }
        if (view.getId() == R.id.ll_terms_inner) {
            if (mIsTermsShown) {
                mTvTermsValue.setVisibility(View.GONE);
                ImageView termsButtonArrow = mLlTerms.findViewById(R.id.iv_terms_arrow);
                termsButtonArrow.setImageDrawable(ContextCompat.getDrawable(this, R.drawable.ic_down_dark_new));
                mIsTermsShown = false;
            } else {
                mTvTermsValue.setVisibility(View.VISIBLE);
                ImageView termsButtonArrow = mLlTerms.findViewById(R.id.iv_terms_arrow);
                termsButtonArrow.setImageDrawable(ContextCompat.getDrawable(this, R.drawable.ic_up_dark_new));
                mIsTermsShown = true;
            }
        }
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(ViewPumpContextWrapper.wrap(newBase));
    }

    // ===========================================================
    // Methods
    // ===========================================================

    private void initViews() {
        if (mIsUnified) {
            mTvCouponCodeTitle.setVisibility(View.GONE);
            mTvCouponCode.setVisibility(View.GONE);
            mLlGiftIt.setVisibility(View.GONE);
        }
        mLlBarcodeShown.setVisibility(View.GONE);
        mLlBarcodeContainer.setVisibility(View.GONE);
        mIvBarcode.setVisibility(View.GONE);

        if (mIsUnified) {
            mTvCouponTitle.setText(HtmlCompat.fromHtml(mCoupon.getInnerText(), HtmlCompat.FROM_HTML_MODE_COMPACT));
        } else {
            mTvCouponCode.setText(mCoupon.getCoupon());
            mTvCouponTitle.setText(mCoupon.getName());
        }
//        mTvCouponSubtitle.setText(mCoupon.getDescription());

        if (WarplyManagerHelper.getCouponsets() != null && WarplyManagerHelper.getCouponsets().size() > 0) {
            for (Couponset couponset : WarplyManagerHelper.getCouponsets()) {
                if (couponset.getUuid().equals(mCoupon.getCouponsetUuid())) {
                    mCouponset = couponset;
                    break;
                }
            }
        }

        if (mCouponset != null) {
            if (WarplyManagerHelper.getMerchantList() != null && WarplyManagerHelper.getMerchantList().size() > 0) {
                for (Merchant merchant : WarplyManagerHelper.getMerchantList()) {
                    if (merchant.getUuid().equals(mCouponset.getMerchantUuid())) {
                        mMerchant = merchant;
                        break;
                    }
                }

                if (mMerchant != null && !TextUtils.isEmpty(mMerchant.getBody()) && !mMerchant.getBody().equals("null")) {
                    mTvDescription.setText(HtmlCompat.fromHtml(mMerchant.getBody(), HtmlCompat.FROM_HTML_MODE_COMPACT));
                    mTvDescription.setMovementMethod(LinkMovementMethod.getInstance());
                } else {
                    mTvDescription.setVisibility(View.GONE);
                }

//                if (mMerchant != null) {
//                    if (mMerchant.getExtraFields() != null && mMerchant.getExtraFields().has("show_map") && (mMerchant.getExtraFields().optBoolean("show_map") || mMerchant.getExtraFields().optString("show_map").equals("true"))) {
                mLlShops.setVisibility(View.VISIBLE);
//                    }
//                    if (mMerchant.getExtraFields() != null && mMerchant.getExtraFields().has("eshop") && (mMerchant.getExtraFields().optBoolean("eshop") || mMerchant.getExtraFields().optString("eshop").equals("true"))) {
//                        mLlWebsite.setVisibility(View.VISIBLE);
//                    }
//                }
            }

            mTvCouponSubtitle.setText(mCouponset.getShortDescription());
            mTvTermsValue.setText(HtmlCompat.fromHtml(mCouponset.getTerms(), HtmlCompat.FROM_HTML_MODE_COMPACT));
            mTvTermsValue.setMovementMethod(LinkMovementMethod.getInstance());
        } else {
            if (mIsFromWallet) {
                if (WarplyManagerHelper.getMerchantList() != null && WarplyManagerHelper.getMerchantList().size() > 0) {
                    for (Merchant merchant : WarplyManagerHelper.getMerchantList()) {
                        if (merchant.getUuid().equals(mCoupon.getMerchantUuid())) {
                            mMerchant = merchant;
                            break;
                        }
                    }

//                    if (mMerchant != null && !TextUtils.isEmpty(mMerchant.getBody()) && !mMerchant.getBody().equals("null")) {
//                        mTvDescription.setText(HtmlCompat.fromHtml(mMerchant.getBody(), HtmlCompat.FROM_HTML_MODE_COMPACT));
//                        mTvDescription.setMovementMethod(LinkMovementMethod.getInstance());
//                    } else {
                    mTvDescription.setVisibility(View.GONE);
//                    }

//                if (mMerchant != null) {
//                    if (mMerchant.getExtraFields() != null && mMerchant.getExtraFields().has("show_map") && (mMerchant.getExtraFields().optBoolean("show_map") || mMerchant.getExtraFields().optString("show_map").equals("true"))) {
                    mLlShops.setVisibility(View.VISIBLE);
//                    }
//                    if (mMerchant.getExtraFields() != null && mMerchant.getExtraFields().has("eshop") && (mMerchant.getExtraFields().optBoolean("eshop") || mMerchant.getExtraFields().optString("eshop").equals("true"))) {
//                        mLlWebsite.setVisibility(View.VISIBLE);
//                    }
//                }
                }

                if(mIsUnified) {
                    mTvCouponSubtitle.setText(HtmlCompat.fromHtml(mCoupon.getDescription(), HtmlCompat.FROM_HTML_MODE_COMPACT));
                } else {
                    mTvCouponSubtitle.setText(mCoupon.getShort_description());
                }
                mTvTermsValue.setText(HtmlCompat.fromHtml(mCoupon.getTerms(), HtmlCompat.FROM_HTML_MODE_COMPACT));
                mTvTermsValue.setMovementMethod(LinkMovementMethod.getInstance());
            }
        }

        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
        Date newDate = new Date();
        try {
            newDate = simpleDateFormat.parse(mCoupon.getExpiration());
        } catch (ParseException e) {
            e.printStackTrace();
        }
        simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        mTvCouponDate.setText(String.format(getResources().getString(R.string.cos_mycoupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));

        if (!TextUtils.isEmpty(mCoupon.getImage())) {
            if (mIsUnified) {
                mIvCouponPhoto.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            } else {
                mIvCouponPhoto.setScaleType(ImageView.ScaleType.CENTER_CROP);
            }

            Glide.with(this)
//                        .setDefaultRequestOptions(
//                                RequestOptions
//                                        .placeholderOf(R.drawable.ic_default_contact_photo)
//                                        .error(R.drawable.ic_default_contact_photo))
                    .load(mCoupon.getImage())
                    .diskCacheStrategy(DiskCacheStrategy.DATA)
                    .into(mIvCouponPhoto);
        } else {
            Glide.with(this)
                    .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                    .into(mIvCouponPhoto);
        }
        mIvBack.setOnClickListener(this);
//        mTvTerms.setPaintFlags(mTvTerms.getPaintFlags() | Paint.UNDERLINE_TEXT_FLAG);
        mLlGiftIt.setOnClickListener(this);
        mLlShops.setOnClickListener(this);
        mLlWebsite.setOnClickListener(this);
        mLlBarcodeShown.setOnClickListener(this);
        mLlTerms.setOnClickListener(this);

        String tempCoupon = "";
        int result = 0;
        try {
            tempCoupon = mCoupon.getCoupon();
            for (int i = 0; i < (12 - mCoupon.getCoupon().length()); i++) {
                tempCoupon += "0";
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            for (int i = mCoupon.getCoupon().length() - 1; i >= 0; i--) {
                result = result + Integer.parseInt(String.valueOf((mCoupon.getCoupon()).charAt(i))) * (1 + (2 * (i % 2)));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        tempCoupon = tempCoupon + (10 - (result % 10)) % 10;
        createBarcodeBitmap(tempCoupon);
    }

    private void createBarcodeBitmap(String barcodeString) {
        EAN13Writer writer = new EAN13Writer();
        try {
            BitMatrix bitMatrix = writer.encode(barcodeString, BarcodeFormat.EAN_13, 1024, 512);
            int width = bitMatrix.getWidth();
            int height = bitMatrix.getHeight();
            Bitmap bmp = Bitmap.createBitmap(width, height, Bitmap.Config.RGB_565);
            for (int x = 0; x < width; x++) {
                for (int y = 0; y < height; y++) {
                    bmp.setPixel(x, y, bitMatrix.get(x, y) ? Color.BLACK : Color.WHITE);
                }
            }
            mIvBarcode.setImageBitmap(bmp);
            mTvFullBarcode.setText(barcodeString);

        } catch (Exception e) {
            e.printStackTrace();
            mLlBarcodeShown.setVisibility(View.GONE);
            mLlBarcodeContainer.setVisibility(View.GONE);
            mIvBarcode.setVisibility(View.GONE);
        }
    }

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================

}
