package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.google.android.material.bottomsheet.BottomSheetDialog;

import org.greenrobot.eventbus.EventBus;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;

import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import ly.warp.sdk.R;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Consumer;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.WarplyCouponsChangedEventModel;
import ly.warp.sdk.io.request.CosmoteCouponSharingRequest;
import ly.warp.sdk.io.request.WarplyConsumerRequest;
import ly.warp.sdk.io.request.WarplyUserCouponsRequest;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;


public class CouponShareActivity extends Activity implements View.OnClickListener {

    // ===========================================================
    // Constants
    // ===========================================================

    private final String MSISDN_LIST = "msisdnList";

    // ===========================================================
    // Fields
    // ===========================================================

    private ImageView mIvBack, mIvCouponPhoto;
    private TextView mTvCouponTitle, mTvPhoneHeader;
    private Coupon mCoupon;
    private Consumer mConsumer;
    private RelativeLayout mRlSenderView;
    private LinearLayout mLlShareButton;
    private String mSender = "";
    private EditText mEdtReceiver;
    private AlertDialog mAlertDialogSuccessSharing, mAlertDialogErrorSharing,
            mAlertDialogCouponAskSharing, mAlertDialogWrongNumberSharing, mAlertDialogNoAssets;
    private boolean mIsFromWallet = false;

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_coupon_share);

        mCoupon = (Coupon) getIntent().getSerializableExtra("coupon");
        mIsFromWallet = getIntent().getBooleanExtra("isFromWallet", false);

        mIvBack = findViewById(R.id.iv_coupon_share_back);
        mTvCouponTitle = findViewById(R.id.textView13);
        mIvCouponPhoto = findViewById(R.id.imageView6);
        mRlSenderView = findViewById(R.id.ll_share_view);
        mLlShareButton = findViewById(R.id.ll_share_button);
        mTvPhoneHeader = findViewById(R.id.tv_phone);
        mEdtReceiver = findViewById(R.id.et_phone);

        initViews();
    }

    @Override
    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent(this, "screen", "CouponShareScreen");

        WarplyManager.getConsumer(new WarplyConsumerRequest()
                , mConsumerCallback);
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.iv_coupon_share_back) {
            onBackPressed();
            return;
        }
        if (view.getId() == R.id.ll_share_view) {
            if (mConsumer == null)
                return;

            try {
                JSONObject profMeta = new JSONObject(mConsumer.getProfileMetadata());
                if (profMeta != null) {
                    JSONArray msisdnList = new JSONArray();
                    msisdnList = profMeta.optJSONArray(MSISDN_LIST);

                    ArrayList<String> listdata = new ArrayList<String>();
                    if (msisdnList != null) {
                        for (int i = 0; i < msisdnList.length(); i++) {
                            if (!TextUtils.isEmpty(msisdnList.optString(i).trim()))
                                listdata.add(msisdnList.optString(i).trim());
                        }
                    }

                    if (listdata == null || listdata.size() == 0) {
                        showNoAssetsDialog();
                        return;
                    }
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }

            showSharingDialog();
            return;
        }
        if (view.getId() == R.id.ll_share_button) {
            if (!TextUtils.isEmpty(mSender) && !mTvPhoneHeader.getText().toString().equals(R.string.cos_coupon_share_sender) && !TextUtils.isEmpty(mEdtReceiver.getText().toString())) {
                askSharingDialog();
            } else {
                errorSharingDialog2();
            }
        }
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(ViewPumpContextWrapper.wrap(newBase));
    }

    // ===========================================================
    // Methods
    // ===========================================================

    private void initViews() {
        mTvCouponTitle.setText(mCoupon.getName());

        if (!TextUtils.isEmpty(mCoupon.getImage())) {
            Glide.with(this)
//                        .setDefaultRequestOptions(
//                                RequestOptions
//                                        .placeholderOf(R.drawable.ic_default_contact_photo)
//                                        .error(R.drawable.ic_default_contact_photo))
                    .load(mCoupon.getImage())
                    .diskCacheStrategy(DiskCacheStrategy.DATA)
                    .into(mIvCouponPhoto);
        } else {
            Glide.with(this)
                    .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                    .into(mIvCouponPhoto);
        }
        mIvBack.setOnClickListener(this);
        mRlSenderView.setOnClickListener(this);
        mLlShareButton.setOnClickListener(this);
    }

    private void showSharingDialog() {
        final BottomSheetDialog bottomSheetDialog = new BottomSheetDialog(this);
        bottomSheetDialog.setContentView(R.layout.dl_share);
        LinearLayout parent = bottomSheetDialog.findViewById(R.id.ll_share_dialog_view_inner);

        ImageView dialogClose = (ImageView) bottomSheetDialog.findViewById(R.id.iv_sender_list_close);
        dialogClose.setOnClickListener(view -> bottomSheetDialog.dismiss());

        if (mConsumer != null) {
            try {
                JSONObject profMeta = new JSONObject(mConsumer.getProfileMetadata());
                if (profMeta != null) {
                    JSONArray msisdnList = new JSONArray();
                    msisdnList = profMeta.optJSONArray(MSISDN_LIST);
                    if (msisdnList != null && msisdnList.length() > 0) {
                        for (int i = 0; i < msisdnList.length(); i++) {
                            LayoutInflater vi = (LayoutInflater) getApplicationContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                            LinearLayout v = (LinearLayout) vi.inflate(R.layout.item_share, null);
                            TextView textView = (TextView) v.findViewById(R.id.tv_phone_share);
                            textView.setText(msisdnList.optString(i));
                            textView.setOnClickListener(view -> {
                                TextView tv = (TextView) view;
                                mTvPhoneHeader.setText(tv.getText().toString());
                                mSender = tv.getText().toString();
                                bottomSheetDialog.dismiss();
                            });
                            parent.addView(v, 0, new ViewGroup.LayoutParams(
                                    ViewGroup.LayoutParams.MATCH_PARENT,
                                    ViewGroup.LayoutParams.WRAP_CONTENT));
                        }
                    }
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }

        bottomSheetDialog.show();
    }

    private void acceptSharingDialog() {
        if (!isFinishing()) {
            mAlertDialogSuccessSharing = new AlertDialog.Builder(this)
                    .setTitle(R.string.cos_dlg_success_title)
                    .setMessage(R.string.cos_dlg_positive_coupon_text)
                    .setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                        dialogPositive.dismiss();
                        if (mIsFromWallet) {
                            setResult(RESULT_OK, new Intent());
                            onBackPressed();
                        }
                    })
                    .show();
        }
    }

    private void errorSharingDialog() {
        if (!isFinishing()) {
            mAlertDialogErrorSharing = new AlertDialog.Builder(this)
                    .setTitle(R.string.cos_dlg_error_title)
                    .setMessage(R.string.cos_dlg_error_subtitle)
                    .setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                        dialogPositive.dismiss();
                    })
                    .show();
        }
    }

    private void wrongNumberDialog(String message) {
        if (!isFinishing()) {
            mAlertDialogWrongNumberSharing = new AlertDialog.Builder(this)
                    .setTitle(R.string.cos_dlg_error_title)
                    .setMessage(message)
                    .setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                        dialogPositive.dismiss();
                    })
                    .show();
        }
    }

    private void errorSharingDialog2() {
        if (!isFinishing()) {
            mAlertDialogErrorSharing = new AlertDialog.Builder(this)
                    .setTitle(R.string.cos_dlg_error_title2)
                    .setMessage(R.string.cos_dlg_error_subtitle2)
                    .setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                        dialogPositive.dismiss();
                    })
                    .show();
        }
    }

    private void showNoAssetsDialog() {
        if (!isFinishing()) {
            mAlertDialogNoAssets = new AlertDialog.Builder(this)
                    .setTitle(R.string.cos_coupon_gift)
                    .setMessage(R.string.cos_share_no_assets)
                    .setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                        dialogPositive.dismiss();
                        onBackPressed();
                    })
                    .show();
        }
    }

    private void askSharingDialog() {
        if (!isFinishing()) {
            mAlertDialogCouponAskSharing = new AlertDialog.Builder(this)
                    .setTitle(R.string.cos_dlg_positive_coupon_title)
                    .setMessage(R.string.cos_dlg_positive_coupon_subtitle)
                    .setPositiveButton(R.string.cos_dlg_negative_button3, (dialogPositive, whichPositive) -> {
                        WarplyAnalyticsManager.logTrackersEvent(this, "click", ("ShareCoupon")
                                .concat(":")
                                .concat(mCoupon.getName()));

                        new Thread(() -> {
                            if (!Thread.currentThread().isInterrupted()) {
                                WarplyManager.cosmoteCouponSharing(new CosmoteCouponSharingRequest()
                                                .setCoupon(mCoupon.getCoupon())
                                                .setSender(mSender)
                                                .setReceiver(mEdtReceiver.getText().toString())
                                        , mCouponSharingCallback);
                            }
                            Thread.currentThread().interrupt();
                        }).start();
                    })
                    .setNegativeButton(R.string.cos_dlg_negative_button2, (dialogNegative, whichNegative) -> {
                        dialogNegative.dismiss();
                    })
                    .show();
        }
    }

    private final CallbackReceiver<Consumer> mConsumerCallback = new CallbackReceiver<Consumer>() {
        @Override
        public void onSuccess(Consumer result) {
            mConsumer = result;
        }

        @Override
        public void onFailure(int errorCode) {
            Log.v("COUPON_SHARE_ACTIVITY", String.valueOf(errorCode));
        }
    };

    private final CallbackReceiver<JSONObject> mCouponSharingCallback = new CallbackReceiver<JSONObject>() {
        @Override
        public void onSuccess(JSONObject result) {
            int status = result.optInt("status", 2);
            String message = result.optString("msg", "");
            WarplyManager.getUserCouponsWithCouponsets(mUserCouponsReceiver);
            runOnUiThread(() -> {
                if (status == 1)
                    acceptSharingDialog();
                else if (status == 4)
                    wrongNumberDialog(message);
                else
                    errorSharingDialog();
            });
        }

        @Override
        public void onFailure(int errorCode) {
            Log.v("COUPON_SHARE", String.valueOf(errorCode));
            runOnUiThread(() -> errorSharingDialog());
        }
    };

    private final CallbackReceiver<CouponList> mUserCouponsReceiver = new CallbackReceiver<CouponList>() {
        @Override
        public void onSuccess(CouponList result) {
            WarplyCouponsChangedEventModel couponsChanged = new WarplyCouponsChangedEventModel();
            couponsChanged.setChanged(true);
            EventBus.getDefault().post(new WarplyEventBusManager(couponsChanged));
        }

        @Override
        public void onFailure(int errorCode) {

        }
    };

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================

}
