package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;
import androidx.core.text.HtmlCompat;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;

import org.greenrobot.eventbus.EventBus;
import org.json.JSONObject;

import java.util.ArrayList;

import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import ly.warp.sdk.R;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.Couponset;
import ly.warp.sdk.io.models.LoyaltyContextualOfferModel;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.WarplyCCMSEnabledModel;
import ly.warp.sdk.io.models.WarplyCouponsChangedEventModel;
import ly.warp.sdk.io.request.WarplyGetCampaignsRequest;
import ly.warp.sdk.io.request.WarplyRedeemCouponRequest;
import ly.warp.sdk.services.EventCampaignService;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;


public class CouponsetInfoActivity extends Activity implements View.OnClickListener {

    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================

    private ImageView mIvBack, mIvCouponsetPhoto, mIvTermsArrow;
    private TextView mTvTerms, mTvCouponsetTitle, mTvCouponsetSubtitle, mTvTermsValue;
    private Couponset mCouponset;
    private LinearLayout mLlRedeem, mLlTerms;
    private ProgressBar mPbLoading;
    private Coupon mCoupon;
    private boolean mIsTermsPressed = false;
    private AlertDialog mAlertDialogCouponset;
    private Campaign mLoyalty;
    private LoyaltyContextualOfferModel mCcms = null;
    private AlertDialog mAlertDialogNonTelco;

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_couponset_info);

        mCouponset = (Couponset) getIntent().getSerializableExtra("couponset");
        mLoyalty = (Campaign) getIntent().getSerializableExtra("loyalty");
        mCcms = (LoyaltyContextualOfferModel) getIntent().getSerializableExtra("ccms");

        mIvBack = findViewById(R.id.iv_couponset_info_back);
        mTvTerms = findViewById(R.id.tv_terms);
        mTvCouponsetTitle = findViewById(R.id.textView13);
        mTvCouponsetSubtitle = findViewById(R.id.textView14);
        mIvCouponsetPhoto = findViewById(R.id.imageView6);
        mLlRedeem = findViewById(R.id.ll_get_gift);
        mPbLoading = findViewById(R.id.pb_loading);
        mLlTerms = findViewById(R.id.ll_terms_inner);
        mTvTermsValue = findViewById(R.id.tv_terms_value);
        mIvTermsArrow = findViewById(R.id.iv_terms_arrow);

        initViews();
    }

    @Override
    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent(this, "screen", "CouponsetScreen");
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.iv_couponset_info_back) {
            onBackPressed();
            return;
        }
        if (view.getId() == R.id.ll_get_gift) {
            mLlRedeem.setEnabled(false);
            mPbLoading.setVisibility(View.VISIBLE);
            WarplyAnalyticsManager.logTrackersEvent(this, "click", ("RetrieveCoupon")
                    .concat(":")
                    .concat(mCouponset.getUuid()));
            if (mCcms == null) {
                WarplyManager.redeemCoupon(new WarplyRedeemCouponRequest()
                        .setCouponsetUuid(mCouponset.getUuid())
                        .setCommunicationUuid(mLoyalty.getSessionUUID()), mRedeemCouponCallback);
            } else {
                WarplyManager.redeemCoupon(new WarplyRedeemCouponRequest()
                        .setCouponsetUuid(mCouponset.getUuid())
                        .setCommunicationUuid(mLoyalty.getSessionUUID())
                        .setHasContextualOffer(true)
                        .setSessionId(mCcms.getSessionId())
                        .setUserMsisdn(WarplyManagerHelper.getConsumer().getMsisdn()) //TODO: where to find the msisdn??
                        .setBusinessService(mCcms.getBusinessService())
                        .setOfferName(mCcms.getOfferName())
                        .setProductType(mCcms.getProductType())
                        .setProvDuration(mCcms.getProvDuration())
                        .setNoOfRecurrance(mCcms.getNoOfRecurrance())
                        .setPrice(mCcms.getPrice())
                        .setDiscount(mCcms.getDiscount())
                        .setVoiceCategory(mCcms.getVoiceCategory())
                        .setDataCategory(mCcms.getDataCategory())
                        .setMinsValue(mCcms.getMinsValue())
                        .setDataValue(mCcms.getDataValue())
                        .setProvStepValueMins(mCcms.getProvStepValueMins())
                        .setOfferAudienceLevel(mCcms.getOfferAudienceLevel())
                        .setUACIOfferTrackingCode(mCcms.getUACIOfferTrackingCode())
                        .setOfferCode1(mCcms.getOfferCode1())
                        .setScore(mCcms.getScore())
                        .setZone(mCcms.getZone())
                        .setWave(mCcms.getWave())
                        .setValidity(mCcms.getValidity())
                        .setTreatmentCode(mCcms.getTreatmentCode()), mRedeemCouponCallback);
            }
            return;
        }
        if (view.getId() == R.id.ll_terms_inner) {
            if (mIsTermsPressed) {
                mIsTermsPressed = false;
                mTvTermsValue.setVisibility(View.GONE);
                mIvTermsArrow.setImageDrawable(getDrawable(R.drawable.ic_down_dark_new));
            } else {
                mIsTermsPressed = true;
                mTvTermsValue.setVisibility(View.VISIBLE);
                mIvTermsArrow.setImageDrawable(getDrawable(R.drawable.ic_up_dark_new));
            }
        }
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(ViewPumpContextWrapper.wrap(newBase));
    }

    // ===========================================================
    // Methods
    // ===========================================================

    private void initViews() {
        if (WarpUtils.getUserNonTelco(this)) {
            nonTelcoDialog();
        }

        mTvCouponsetTitle.setText(mCouponset.getName());
        mTvCouponsetSubtitle.setText(HtmlCompat.fromHtml(mCouponset.getDescription(), HtmlCompat.FROM_HTML_MODE_COMPACT));
        mTvCouponsetSubtitle.setMovementMethod(LinkMovementMethod.getInstance());
        mLlTerms.setOnClickListener(this);
        mTvTermsValue.setText(HtmlCompat.fromHtml(mCouponset.getTerms(), HtmlCompat.FROM_HTML_MODE_COMPACT));
        mTvTermsValue.setMovementMethod(LinkMovementMethod.getInstance());

        if (!TextUtils.isEmpty(mCouponset.getImgPreview())) {
            Glide.with(this)
//                        .setDefaultRequestOptions(
//                                RequestOptions
//                                        .placeholderOf(R.drawable.ic_default_contact_photo)
//                                        .error(R.drawable.ic_default_contact_photo))
                    .load(mCouponset.getImgPreview())
                    .diskCacheStrategy(DiskCacheStrategy.DATA)
                    .into(mIvCouponsetPhoto);
        } else {
            Glide.with(this)
                    .load(R.drawable.ic_cosmote_logo_horizontal_grey)
                    .into(mIvCouponsetPhoto);
        }

        mIvBack.setOnClickListener(this);
        mLlRedeem.setOnClickListener(this);
//        mTvTerms.setPaintFlags(mTvTerms.getPaintFlags() | Paint.UNDERLINE_TEXT_FLAG);
    }

    private final CallbackReceiver<JSONObject> mRedeemCouponCallback = new CallbackReceiver<JSONObject>() {
        @Override
        public void onSuccess(JSONObject result) {
            mPbLoading.setVisibility(View.GONE);
            int status = result.optInt("status");
            if (status == 1) {
                if (mCcms != null) {
                    WarplyCCMSEnabledModel ccmsEnabled = new WarplyCCMSEnabledModel();
                    ccmsEnabled.setActivated(true);
                    EventBus.getDefault().post(new WarplyEventBusManager(ccmsEnabled));
                }

                mCoupon = new Coupon(result.optJSONObject("result"));
                mCoupon.setDescription(mCouponset.getShortDescription());
                mCoupon.setImage(mCouponset.getImgPreview());
                mCoupon.setName(mCouponset.getName());
                showDialog(true, 1);
                new Thread(() -> {
                    if (!Thread.currentThread().isInterrupted()) {
                        WarplyManager.getUserCouponsWithCouponsets(mUserCouponsReceiver);
                        WarplyManager.getCampaigns(new WarplyGetCampaignsRequest().setLanguage("en"), mCampaignsCallback);
                    }
                }).start();
            } else {
                showDialog(false, status);
            }
            mLlRedeem.setEnabled(true);
        }

        @Override
        public void onFailure(int errorCode) {
            mPbLoading.setVisibility(View.GONE);
            showDialog(false, errorCode);
            mLlRedeem.setEnabled(true);
        }
    };

    private void showDialog(boolean success, int status) {
        if (success) {
            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("loyalty_offer_activated");
            analyticsEvent.setParameter("name", mLoyalty.getTitle());
            analyticsEvent.setParameter("type", "coupon");
            analyticsEvent.setParameter("successful", "true");
            EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));

            if (!isFinishing()) {
                mAlertDialogCouponset = new AlertDialog.Builder(this)
                        .setTitle(R.string.cos_dlg_success_couponset_title)
                        .setMessage(R.string.cos_dlg_success_couponset_subtitle)
                        .setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                            dialogPositive.dismiss();
                            if (success) {
//                            setResult(RESULT_OK, new Intent());
                                onBackPressed();
                            }
                        })
                        .setCancelable(false)
                        .show();
            }
        } else {
            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("loyalty_offer_activated");
            analyticsEvent.setParameter("name", mLoyalty.getTitle());
            analyticsEvent.setParameter("type", "coupon");
            analyticsEvent.setParameter("successful", "false");
            EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));

            if (status == 3) {
                if (!isFinishing()) {
                    mAlertDialogCouponset = new AlertDialog.Builder(this)
                            .setTitle(R.string.cos_dlg_error_title)
                            .setMessage(R.string.cos_dlg_error_subtitle_non_buyable)
                            .setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                                dialogPositive.dismiss();
                            })
                            .show();
                }
            } else if (status == 5) {
                if (!isFinishing()) {
                    mAlertDialogCouponset = new AlertDialog.Builder(this)
                            .setTitle(R.string.cos_dlg_error_title)
                            .setMessage(R.string.cos_dlg_error_subtitle_no_points)
                            .setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                                dialogPositive.dismiss();
                            })
                            .show();
                }
            } else if (status == 6) {
                if (!isFinishing()) {
                    mAlertDialogCouponset = new AlertDialog.Builder(this)
                            .setTitle(R.string.cos_dlg_coupon_depleted_title)
                            .setMessage(R.string.cos_dlg_coupon_depleted_message)
                            .setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                                dialogPositive.dismiss();
                            })
                            .show();
                }
            } else {
                if (!isFinishing()) {
                    mAlertDialogCouponset = new AlertDialog.Builder(this)
                            .setTitle(R.string.cos_dlg_error_title)
                            .setMessage(R.string.cos_dlg_error_subtitle)
                            .setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                                dialogPositive.dismiss();
                            })
                            .show();
                }
            }
        }
    }

    private void nonTelcoDialog() {
        if (!isFinishing()) {
            mAlertDialogNonTelco = new AlertDialog.Builder(this)
                    .setTitle(R.string.cos_dlg_non_telco_title)
                    .setMessage(R.string.cos_dlg_non_telco)
                    .setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                        dialogPositive.dismiss();
                        onBackPressed();
                    })
                    .setCancelable(false)
                    .show();
        }
    }

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================

    private final CallbackReceiver<CouponList> mUserCouponsReceiver = new CallbackReceiver<CouponList>() {
        @Override
        public void onSuccess(CouponList result) {
//            Thread.currentThread().interrupt();
            WarplyCouponsChangedEventModel couponsChanged = new WarplyCouponsChangedEventModel();
            couponsChanged.setChanged(true);
            EventBus.getDefault().post(new WarplyEventBusManager(couponsChanged));
        }

        @Override
        public void onFailure(int errorCode) {
            Thread.currentThread().interrupt();
        }
    };

    private CallbackReceiver<ArrayList<Campaign>> mCampaignsCallback = new CallbackReceiver<ArrayList<Campaign>>() {
        @Override
        public void onSuccess(ArrayList<Campaign> result) {
            OneTimeWorkRequest mywork = new OneTimeWorkRequest.Builder(EventCampaignService.class).build();
            WorkManager.getInstance(CouponsetInfoActivity.this).enqueue(mywork);
//            Thread.currentThread().interrupt();
        }

        @Override
        public void onFailure(int errorCode) {
            Thread.currentThread().interrupt();
        }
    };

}
