package ly.warp.sdk.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.Couponset;
import ly.warp.sdk.io.models.LoyaltyContextualOfferModel;
import ly.warp.sdk.io.models.LoyaltyGiftsForYouOfferClickEvent;
import ly.warp.sdk.io.models.LoyaltyGiftsForYouPackage;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.MergedGifts;
import ly.warp.sdk.services.EventCampaignService;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import ly.warp.sdk.views.adapters.MergedGiftsAdapter;


public class GiftsForYouActivity extends AppCompatActivity implements View.OnClickListener {

    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================

    private ImageView mIvBack, mIvPopupClose;
    private TextView mTvTitle;
    private LinearLayout mLlGiftsPopup;
    private ArrayList<MergedGifts> mData = new ArrayList<>();
    private RecyclerView mRecyclerMergedGifts;
    private MergedGiftsAdapter mAdapterMergedGifts;
    private ArrayList<Campaign> mValuesList = new ArrayList<>();
    private ArrayList<LoyaltyGiftsForYouPackage> mSeasonalList = new ArrayList<>();
    private HashSet<LoyaltyGiftsForYouPackage> mHashSetSeasonalList = new HashSet<>();
    private ArrayList<LoyaltyContextualOfferModel> mContextualList = new ArrayList<>();
    private int mTimer = 0;
    private Handler mSecondsHandler;

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
//        Objects.requireNonNull(getSupportActionBar()).hide();
        setContentView(R.layout.activity_gifts_for_you);
        mSecondsHandler = new Handler();

        mIvBack = findViewById(R.id.iv_list_close);
        mTvTitle = findViewById(R.id.textView3);
        mIvPopupClose = findViewById(R.id.iv_popup_gifts_close);
        mLlGiftsPopup = findViewById(R.id.ll_gifts_popup);
        mRecyclerMergedGifts = findViewById(R.id.rv_merged_gifts);

        filterItems();

        mergeDatasets();

        initViews();
    }

    @Override
    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent(GiftsForYouActivity.this, "screen", "GiftsForYouScreen");
        mTimer = 0;
        mSecondsHandler.post(new Runnable() {
            @Override
            public void run() {
                mTimer++;
                mSecondsHandler.postDelayed(this, 1000);
            }
        });
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onPause() {
        super.onPause();
        if (mSecondsHandler != null) {
            mSecondsHandler.removeCallbacksAndMessages(null);

            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("time_spent_on_loyalty_sdk");
            analyticsEvent.setParameter("name", "GiftsForYou");
            analyticsEvent.setParameter("seconds", String.valueOf(mTimer));
            EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        EventBus.getDefault().register(this);
    }

    @Override
    protected void onStop() {
        super.onStop();
        EventBus.getDefault().unregister(this);
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.iv_list_close) {
            onBackPressed();
            return;
        }
        if (view.getId() == R.id.iv_popup_gifts_close) {
            mLlGiftsPopup.setVisibility(View.GONE);
            WarpUtils.setGiftsPopup(this, false);
        }
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(ViewPumpContextWrapper.wrap(newBase));
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1004) {
            OneTimeWorkRequest mywork = new OneTimeWorkRequest.Builder(EventCampaignService.class).build();
            WorkManager.getInstance(GiftsForYouActivity.this).enqueue(mywork);
        }
    }

    @Subscribe()
    public void onMessageEvent(WarplyEventBusManager event) {
        if (event.getCcmsAdded() != null || event.getCampaignsAdded() != null) {
            filterItems();

            mergeDatasets();

            runOnUiThread(this::initViews2);
        }
    }

    // ===========================================================
    // Methods
    // ===========================================================

    private void initViews() {
        mIvBack.setOnClickListener(this);
        mIvPopupClose.setOnClickListener(this);

//        if (WarpUtils.getGiftsPopup(this))
//            mLlGiftsPopup.setVisibility(View.VISIBLE);

        if (mData != null && mData.size() > 0) {
            mRecyclerMergedGifts.setNestedScrollingEnabled(false);
            mRecyclerMergedGifts.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
            mAdapterMergedGifts = new MergedGiftsAdapter(this, mData);
            mRecyclerMergedGifts.setAdapter(mAdapterMergedGifts);
            mAdapterMergedGifts.getPositionClicks()
                    .doOnNext(this::handleGiftItemClick)
                    .doOnError(error -> {
                    })
                    .subscribe();
        }
    }

    private void initViews2() {
        mIvBack.setOnClickListener(this);
        mIvPopupClose.setOnClickListener(this);

//        if (WarpUtils.getGiftsPopup(this))
//            mLlGiftsPopup.setVisibility(View.VISIBLE);

        if (mData != null && mData.size() > 0) {
//            mRecyclerMergedGifts.setNestedScrollingEnabled(false);
//            mRecyclerMergedGifts.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
//            mAdapterMergedGifts = new MergedGiftsAdapter(this, mData);
//            mRecyclerMergedGifts.setAdapter(mAdapterMergedGifts);
//            mAdapterMergedGifts.getPositionClicks()
//                    .doOnNext(this::handleGiftItemClick)
//                    .doOnError(error -> {
//                    })
//                    .subscribe();

            mAdapterMergedGifts.updateData(mData);
        }
    }

    private void handleGiftItemClick(MergedGifts dataItem) {
        if (dataItem.getDataType() == 1) {
            WarpUtils.log("GFY_CLICK " + dataItem.getCampaign().toString());
            EventBus.getDefault().post(new WarplyEventBusManager(new LoyaltyGiftsForYouOfferClickEvent()));

            if (dataItem.getCampaign().getType().equals("coupon")) {
                if (WarplyManagerHelper.getCCMSLoyaltyCampaigns() != null && WarplyManagerHelper.getCCMSLoyaltyCampaigns().size() > 0) {
                    LoyaltyContextualOfferModel ccmsItem = null;
                    for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                        if (ccms.getLoyaltyCampaignId().equals(dataItem.getCampaign().getSessionUUID())) {
                            ccmsItem = ccms;
                            break;
                        }
                    }

                    if (ccmsItem != null) {
                        try {
                            JSONObject campaignSettings = WarpJSONParser.getJSONFromString(dataItem.getCampaign().getCampaignTypeSettings());
                            if (campaignSettings != null) {
                                if (campaignSettings.has("couponset")) {
                                    String cpnUuid = campaignSettings.optString("couponset");
                                    for (Couponset cpns : WarplyManagerHelper.getCouponsets()) {
                                        if (cpns.getUuid().equals(cpnUuid)) {
                                            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                                            analyticsEvent.setEventName("loyalty_sdk_offer_selected");
                                            analyticsEvent.setParameter("name", dataItem.getCampaign().getTitle());
                                            analyticsEvent.setParameter("type", "coupon");
                                            EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));

                                            WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Loyalty").concat(":").concat(dataItem.getCampaign().getSessionUUID()));
                                            WarplyManager.getSingleCampaign(dataItem.getCampaign().getSessionUUID());
                                            Intent intent = new Intent(GiftsForYouActivity.this, CouponsetInfoActivity.class);
                                            intent.putExtra("couponset", (Serializable) cpns);
                                            intent.putExtra("loyalty", (Serializable) dataItem.getCampaign());
                                            intent.putExtra("ccms", ccmsItem);
                                            startActivityForResult(intent, 1004);
                                            break;
                                        }
                                    }
                                } else {
                                    WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Loyalty").concat(":").concat(dataItem.getCampaign().getSessionUUID()));
                                    startActivityForResult(WarpViewActivity.createIntentFromURL(this, WarplyManagerHelper.constructCampaignUrl(dataItem.getCampaign())), 1004);
                                }
                            }
                        } catch (Exception exception) {
                            exception.printStackTrace();
                        }

                        return;
                    }
                }

                try {
                    JSONObject campaignSettings = WarpJSONParser.getJSONFromString(dataItem.getCampaign().getCampaignTypeSettings());
                    if (campaignSettings != null) {
                        if (campaignSettings.has("couponset")) {
                            String cpnUuid = campaignSettings.optString("couponset");
                            for (Couponset cpns : WarplyManagerHelper.getCouponsets()) {
                                if (cpns.getUuid().equals(cpnUuid)) {
                                    LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                                    analyticsEvent.setEventName("loyalty_sdk_offer_selected");
                                    analyticsEvent.setParameter("name", dataItem.getCampaign().getTitle());
                                    analyticsEvent.setParameter("type", "coupon");
                                    EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));

                                    WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Loyalty").concat(":").concat(dataItem.getCampaign().getSessionUUID()));
                                    WarplyManager.getSingleCampaign(dataItem.getCampaign().getSessionUUID());
                                    Intent intent = new Intent(GiftsForYouActivity.this, CouponsetInfoActivity.class);
                                    intent.putExtra("couponset", (Serializable) cpns);
                                    intent.putExtra("loyalty", (Serializable) dataItem.getCampaign());
                                    startActivityForResult(intent, 1004);
                                    break;
                                }
                            }
                        } else {
                            WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Loyalty").concat(":").concat(dataItem.getCampaign().getSessionUUID()));
                            startActivityForResult(WarpViewActivity.createIntentFromURL(this, WarplyManagerHelper.constructCampaignUrl(dataItem.getCampaign())), 1004);
                        }
                    }
                } catch (Exception exception) {
                    exception.printStackTrace();
                }

                return;
            }

            try {
                JSONObject extraFields = WarpJSONParser.getJSONFromString(dataItem.getCampaign().getExtraFields());
                if (extraFields != null) {
                    if (extraFields.has("type") && extraFields.optString("type").equals("telco")) {
                        for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                            if (ccms.getLoyaltyCampaignId().equals(dataItem.getCampaign().getSessionUUID())) {
                                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                                analyticsEvent.setEventName("loyalty_sdk_offer_selected");
                                analyticsEvent.setParameter("name", ccms.getTitle());
                                analyticsEvent.setParameter("type", "gift");
                                EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));

                                WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Telco").concat(":").concat(ccms.getSessionId()));
                                WarplyManager.getSingleCampaign(dataItem.getCampaign().getSessionUUID());
                                Intent intent = new Intent(GiftsForYouActivity.this, TelcoActivity.class);
                                intent.putExtra("ccms", ccms);
                                intent.putExtra("loyalty", (Serializable) dataItem.getCampaign());
                                startActivityForResult(intent, 1004);
                                break;
                            }
                        }
                        return;
                    }
                    if (extraFields.has("ccms_offer") && extraFields.optString("ccms_offer").equals("true")) {
                        for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                            if (ccms.getLoyaltyCampaignId().equals(dataItem.getCampaign().getSessionUUID())) {
                                WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Contextual").concat(":").concat(ccms.getSessionId()));
                                startActivityForResult(WarpViewActivity.createIntentFromURL(this, WarplyManagerHelper.constructCcmsUrl(dataItem.getCampaign(), ccms)), 1004);
                                break;
                            }
                        }
                    } else {
                        WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Loyalty").concat(":").concat(dataItem.getCampaign().getSessionUUID()));
                        startActivityForResult(WarpViewActivity.createIntentFromURL(this, WarplyManagerHelper.constructCampaignUrl(dataItem.getCampaign())), 1004);
                    }
                }
            } catch (Exception exception) {
                WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Loyalty").concat(":").concat(dataItem.getCampaign().getSessionUUID()));
                startActivityForResult(WarpViewActivity.createIntentFromURL(this, WarplyManagerHelper.constructCampaignUrl(dataItem.getCampaign())), 1004);
            }
        } else if (dataItem.getDataType() == 2) {
            LoyaltyGiftsForYouOfferClickEvent seasonalCLick = new LoyaltyGiftsForYouOfferClickEvent();
            seasonalCLick.setTitle(dataItem.getSeasonalList().getTitle());
            seasonalCLick.setLoyaltyPackageId(dataItem.getSeasonalList().getLoyaltyPackageId());
            seasonalCLick.setImageUrl(dataItem.getSeasonalList().getImageUrl());
            seasonalCLick.setContext(this);
            EventBus.getDefault().post(new WarplyEventBusManager(seasonalCLick));

            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("loyalty_sdk_offer_selected");
            analyticsEvent.setParameter("name", dataItem.getSeasonalList().getTitle());
            analyticsEvent.setParameter("type", "seasonal");
            EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));
        } else if (dataItem.getDataType() == 3) {
            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("loyalty_sdk_offer_selected");
            analyticsEvent.setParameter("name", dataItem.getCCMS().getTitle());
            analyticsEvent.setParameter("type", "gift");
            EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));

            WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Contextual").concat(":").concat(dataItem.getCCMS().getSessionId()));
            Intent intent = new Intent(GiftsForYouActivity.this, ContextualActivity.class);
            intent.putExtra("ccms", dataItem.getCCMS());
            startActivity(intent);
        }
    }

    private void mergeDatasets() {
        mData.clear();
        if (mSeasonalList != null && mSeasonalList.size() > 0) {
            Log.v("SEASONAL", String.valueOf(mSeasonalList.size()));
            for (LoyaltyGiftsForYouPackage seasonal : mSeasonalList) {
                MergedGifts data = new MergedGifts();
                data.setCampaign(null);
                data.setSeasonalList(seasonal);
                data.setCCMS(null);
                data.setDataType(2);
                mData.add(data);
            }
        }

        if (mContextualList != null && mContextualList.size() > 0) {
            Log.v("CCMS", String.valueOf(mContextualList.size()));
            for (LoyaltyContextualOfferModel ccmsItem : mContextualList) {
                MergedGifts data = new MergedGifts();
                data.setCampaign(null);
                data.setSeasonalList(null);
                data.setCCMS(ccmsItem);
                data.setDataType(3);
                mData.add(data);
            }
        }

        if (mValuesList != null && mValuesList.size() > 0) {
            Log.v("GIFTS_FOR_YOU", String.valueOf(mValuesList.size()));
            for (Campaign campaign : mValuesList) {
                MergedGifts data = new MergedGifts();
                data.setCampaign(campaign);
                data.setSeasonalList(null);
                data.setCCMS(null);
                data.setDataType(1);
                mData.add(data);
            }
        }

        Set<MergedGifts> set = new LinkedHashSet<>(mData);
        mData.clear();
        mData.addAll(set);
    }

    private void filterItems() {
        if (WarplyManagerHelper.getSeasonalList() != null && WarplyManagerHelper.getSeasonalList().size() > 0) {
            mHashSetSeasonalList.clear();
            mHashSetSeasonalList.addAll(WarplyManagerHelper.getSeasonalList());
            mSeasonalList.clear();
            mSeasonalList.addAll(mHashSetSeasonalList);
        }

        if (WarplyManagerHelper.getCCMSLoyaltyCampaigns() != null && WarplyManagerHelper.getCCMSLoyaltyCampaigns().size() > 0) {
            mContextualList.clear();
            for (LoyaltyContextualOfferModel ccmsItem : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                if ((TextUtils.isEmpty(ccmsItem.getLoyaltyCampaignId()) || ccmsItem.getLoyaltyCampaignId().equals("NA"))
                        && ccmsItem.getZone().equals("COSMOTE_APP_GIFTS4U"))
                    mContextualList.add(ccmsItem);
            }
        }

        mValuesList.clear();
        ArrayList<Campaign> gfyList = new ArrayList<>();
        if (WarplyManagerHelper.getCampaignListAll() != null && WarplyManagerHelper.getCampaignListAll().size() > 0) {
            if (WarplyManagerHelper.getCCMSLoyaltyCampaigns() == null || WarplyManagerHelper.getCCMSLoyaltyCampaigns().size() == 0) {
                for (Campaign camp : WarplyManagerHelper.getCampaignListAll()) {
                    if (camp.getOfferCategory().equals("gifts_for_you")) {
                        try {
                            JSONObject extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
                            if (extraFields != null) {
                                if (extraFields.length() == 0 || !(extraFields.has("ccms_offer") || extraFields.has("type"))) {
                                    gfyList.add(camp);
                                }
                            }
                        } catch (Exception exception) {
                            gfyList.add(camp);
                        }
                    }
                }
            } else {
                for (Campaign camp : WarplyManagerHelper.getCampaignListAll()) {
                    if (camp.getOfferCategory().equals("gifts_for_you")) {
                        try {
                            JSONObject extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
                            if (extraFields != null) {
                                if (extraFields.has("ccms_offer") && extraFields.optString("ccms_offer").equals("true")) {
                                    for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                                        if (ccms.getLoyaltyCampaignId().equals(camp.getSessionUUID())) {
                                            gfyList.add(camp);
                                            break;
                                        }
                                    }
                                } else {
                                    gfyList.add(camp);
                                }
                            }
                        } catch (Exception exception) {
                            gfyList.add(camp);
                        }
                    }
                }
            }

            WarpUtils.log("GFY_FILTER_LIST_COUNT: " + String.valueOf(gfyList.size()));
            WarpUtils.log("GFY_FILTER_LIST_JSON: " + String.valueOf(gfyList.toString()));
            mValuesList.clear();
            mValuesList.addAll(gfyList);
            WarpUtils.log("GFY_VAR_LIST_COUNT: " + String.valueOf(mValuesList.size()));
            WarpUtils.log("GFY_VAR_LIST_JSON: " + String.valueOf(mValuesList.toString()));
        }
    }

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================

}
