package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.graphics.Typeface;
import android.os.Bundle;
import android.os.Handler;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import org.greenrobot.eventbus.EventBus;

import java.util.ArrayList;

import io.github.inflationx.calligraphy3.CalligraphyTypefaceSpan;
import io.github.inflationx.calligraphy3.TypefaceUtils;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import ly.warp.sdk.R;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.Couponset;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.SharingCoupon;
import ly.warp.sdk.io.models.SharingList;
import ly.warp.sdk.io.request.WarplySharingHistoryRequest;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import ly.warp.sdk.views.adapters.ExpiredCouponAdapter;
import ly.warp.sdk.views.adapters.SharedCouponAdapter;


public class LoyaltyAnalysisActivity extends Activity implements View.OnClickListener {

    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================

    private ImageView mIvBack;
    private TextView mTvCouponsValueAll, mTvSharedEmpty, mTvExpiredEmpty;
    private RecyclerView mRvExpiredCoupons, mRvSharedCoupons;
    private ExpiredCouponAdapter mAdapterExpiredCoupons;
    private SharedCouponAdapter mAdapterSharedCoupons;
    private LinearLayout mLlExpiredTab, mLlSharedTab, mLlShowMoreExpired, mLlShowMoreShared;
    private RelativeLayout mRlExpiredView;
    private CardView mRlSharedView;
    private SharingList mSharedCoupons = new SharingList();
    private int mTimer = 0;
    private Handler mSecondsHandler;

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_loyalty_analysis);
        mSecondsHandler = new Handler();

        mIvBack = findViewById(R.id.iv_loyalty_analysis_close);
        mTvCouponsValueAll = findViewById(R.id.tv_expired_coupons_title);
        mRvExpiredCoupons = findViewById(R.id.rv_expired_coupons);
        mLlExpiredTab = findViewById(R.id.cl_tab_coupon_analysis).findViewById(R.id.ll_tab_expired);
        mLlSharedTab = findViewById(R.id.cl_tab_coupon_analysis).findViewById(R.id.ll_tab_shared);
        mRlExpiredView = findViewById(R.id.rl_expired_view);
        mRlSharedView = findViewById(R.id.rl_shared_view);
        mRvSharedCoupons = findViewById(R.id.rv_shared_coupons);
        mTvSharedEmpty = findViewById(R.id.tv_shared_empty);
        mTvExpiredEmpty = findViewById(R.id.tv_expired_empty);
        mLlShowMoreExpired = findViewById(R.id.ll_show_more_expired);
        mLlShowMoreShared = findViewById(R.id.ll_show_more_shared);

        initViews();
    }

    @Override
    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent(this, "screen", "LoyaltyHistoryScreen");
        mTimer = 0;
        mSecondsHandler.post(new Runnable() {
            @Override
            public void run() {
                mTimer++;
                mSecondsHandler.postDelayed(this, 1000);
            }
        });

        mSharedCoupons.clear();

        new Thread(() -> {
            if (!Thread.currentThread().isInterrupted()) {
                WarplyManager.getSharingHistory(new WarplySharingHistoryRequest()
                                .setExcludeFilter("supermarket")
                        , mSharingHistoryCallback);
            }
            Thread.currentThread().interrupt();
        }).start();
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onPause() {
        super.onPause();
        if (mSecondsHandler != null) {
            mSecondsHandler.removeCallbacksAndMessages(null);

            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("time_spent_on_loyalty_sdk");
            analyticsEvent.setParameter("name", "GiftsCalculator");
            analyticsEvent.setParameter("seconds", String.valueOf(mTimer));
            EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));
        }
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.iv_loyalty_analysis_close) {
            onBackPressed();
            return;
        }
        if (view.getId() == R.id.ll_tab_expired) {
            WarplyAnalyticsManager.logTrackersEvent(this, "click", ("LoyaltyHistoryScreen")
                    .concat(":")
                    .concat("TabExpired"));

            mLlExpiredTab.setBackgroundResource(R.drawable.bottom_border_light_blue);
            TextView expiredTab = findViewById(R.id.tv_expired_tab);
            expiredTab.setTextColor(ContextCompat.getColor(this, R.color.cos_light_black));
            CalligraphyTypefaceSpan typefaceBoldSpan = new CalligraphyTypefaceSpan(TypefaceUtils.load(getAssets(), "fonts/PeridotPE-Bold.ttf"));
            SpannableStringBuilder sBuilderExpired = new SpannableStringBuilder();
            sBuilderExpired.append(getString(R.string.cos_redeemed_coupons_tab));
            sBuilderExpired.setSpan(typefaceBoldSpan, 0, getString(R.string.cos_redeemed_coupons_tab).length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            expiredTab.setText(sBuilderExpired, TextView.BufferType.SPANNABLE);

            mLlSharedTab.setBackgroundResource(R.drawable.bottom_border_transparent);
            TextView sharedTab = findViewById(R.id.tv_shared_tab);
            sharedTab.setTextColor(ContextCompat.getColor(this, R.color.cos_gray2));
            CalligraphyTypefaceSpan typefaceRegularSpan = new CalligraphyTypefaceSpan(TypefaceUtils.load(getAssets(), "fonts/PeridotPE-SemiBold.ttf"));
            SpannableStringBuilder sBuilderShared = new SpannableStringBuilder();
            sBuilderShared.append(getString(R.string.cos_shared_gifts_tab));
            sBuilderShared.setSpan(typefaceRegularSpan, 0, getString(R.string.cos_shared_gifts_tab).length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            sharedTab.setText(sBuilderShared, TextView.BufferType.SPANNABLE);

            mRlSharedView.setVisibility(View.GONE);
            mRlExpiredView.setVisibility(View.VISIBLE);
            return;
        }
        if (view.getId() == R.id.ll_tab_shared) {
            WarplyAnalyticsManager.logTrackersEvent(this, "click", ("LoyaltyHistoryScreen")
                    .concat(":")
                    .concat("TabShared"));

            mLlSharedTab.setBackgroundResource(R.drawable.bottom_border_light_blue);
            TextView sharedTab = findViewById(R.id.tv_shared_tab);
            sharedTab.setTextColor(ContextCompat.getColor(this, R.color.cos_light_black));
            CalligraphyTypefaceSpan typefaceBoldSpan = new CalligraphyTypefaceSpan(TypefaceUtils.load(getAssets(), "fonts/PeridotPE-Bold.ttf"));
            SpannableStringBuilder sBuilderShared = new SpannableStringBuilder();
            sBuilderShared.append(getString(R.string.cos_shared_gifts_tab));
            sBuilderShared.setSpan(typefaceBoldSpan, 0, getString(R.string.cos_shared_gifts_tab).length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            sharedTab.setText(sBuilderShared, TextView.BufferType.SPANNABLE);

            mLlExpiredTab.setBackgroundResource(R.drawable.bottom_border_transparent);
            TextView expiredTab = findViewById(R.id.tv_expired_tab);
            expiredTab.setTextColor(ContextCompat.getColor(this, R.color.cos_gray2));
            CalligraphyTypefaceSpan typefaceRegularSpan = new CalligraphyTypefaceSpan(TypefaceUtils.load(getAssets(), "fonts/PeridotPE-SemiBold.ttf"));
            SpannableStringBuilder sBuilderExpired = new SpannableStringBuilder();
            sBuilderExpired.append(getString(R.string.cos_redeemed_coupons_tab));
            sBuilderExpired.setSpan(typefaceRegularSpan, 0, getString(R.string.cos_redeemed_coupons_tab).length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            expiredTab.setText(sBuilderExpired, TextView.BufferType.SPANNABLE);

            mRlExpiredView.setVisibility(View.GONE);
            mRlSharedView.setVisibility(View.VISIBLE);
            return;
        }
        if (view.getId() == R.id.ll_show_more_expired) {
            mLlShowMoreExpired.setVisibility(View.GONE);
            mAdapterExpiredCoupons = new ExpiredCouponAdapter(this, WarplyManagerHelper.getCouponExpiredList());
            mRvExpiredCoupons.setAdapter(mAdapterExpiredCoupons);
            mAdapterExpiredCoupons.notifyDataSetChanged();
            return;
        }
        if (view.getId() == R.id.ll_show_more_shared) {
            mLlShowMoreShared.setVisibility(View.GONE);
            mAdapterSharedCoupons = new SharedCouponAdapter(LoyaltyAnalysisActivity.this, mSharedCoupons);
            mRvSharedCoupons.setAdapter(mAdapterSharedCoupons);
            mAdapterSharedCoupons.notifyDataSetChanged();
        }
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(ViewPumpContextWrapper.wrap(newBase));
    }

    // ===========================================================
    // Methods
    // ===========================================================

    private void initViews() {
        mIvBack.setOnClickListener(this);
        mLlExpiredTab.setOnClickListener(this);
        mLlSharedTab.setOnClickListener(this);
        mLlShowMoreExpired.setOnClickListener(this);
        mLlShowMoreShared.setOnClickListener(this);

        mLlExpiredTab.setBackgroundResource(R.drawable.bottom_border_light_blue);
        TextView expiredTab = findViewById(R.id.tv_expired_tab);
        expiredTab.setTextColor(ContextCompat.getColor(this, R.color.cos_light_black));
        CalligraphyTypefaceSpan typefaceBoldExpiredSpan = new CalligraphyTypefaceSpan(TypefaceUtils.load(getAssets(), "fonts/PeridotPE-Bold.ttf"));
        SpannableStringBuilder sBuilderExpired = new SpannableStringBuilder();
        sBuilderExpired.append(getString(R.string.cos_redeemed_coupons_tab));
        sBuilderExpired.setSpan(typefaceBoldExpiredSpan, 0, getString(R.string.cos_redeemed_coupons_tab).length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        expiredTab.setText(sBuilderExpired, TextView.BufferType.SPANNABLE);

        mLlSharedTab.setBackgroundResource(R.drawable.bottom_border_transparent);
        TextView sharedTab = findViewById(R.id.tv_shared_tab);
        sharedTab.setTextColor(ContextCompat.getColor(this, R.color.cos_gray2));
        CalligraphyTypefaceSpan typefaceRegularSharedSpan = new CalligraphyTypefaceSpan(TypefaceUtils.load(getAssets(), "fonts/PeridotPE-SemiBold.ttf"));
        SpannableStringBuilder sBuilderShared = new SpannableStringBuilder();
        sBuilderShared.append(getString(R.string.cos_shared_gifts_tab));
        sBuilderShared.setSpan(typefaceRegularSharedSpan, 0, getString(R.string.cos_shared_gifts_tab).length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        sharedTab.setText(sBuilderShared, TextView.BufferType.SPANNABLE);

        String badgeValue = String.format("%.02f", WarplyManagerHelper.getLoyaltyBadge().getValue());

        SpannableStringBuilder sBuilder = new SpannableStringBuilder();
        sBuilder
                .append(getString(R.string.cos_wallet_text3))
                .append(String.format(getString(R.string.cos_value), badgeValue))
                .append(getString(R.string.cos_wallet_text4))
                .append(String.format(getString(R.string.cos_value2), String.valueOf(WarplyManagerHelper.getLoyaltyBadge().getCouponCount())))
                .append(getString(R.string.cos_wallet_text5));

        CalligraphyTypefaceSpan typefaceRegularSpan = new CalligraphyTypefaceSpan(TypefaceUtils.load(getAssets(), "fonts/PeridotPE-Regular.ttf"));
        CalligraphyTypefaceSpan typefaceRegularSpan2 = new CalligraphyTypefaceSpan(TypefaceUtils.load(getAssets(), "fonts/PeridotPE-Regular.ttf"));
        CalligraphyTypefaceSpan typefaceRegularSpan3 = new CalligraphyTypefaceSpan(TypefaceUtils.load(getAssets(), "fonts/PeridotPE-Regular.ttf"));
        CalligraphyTypefaceSpan typefaceBoldSpan = new CalligraphyTypefaceSpan(TypefaceUtils.load(getAssets(), "fonts/PeridotPE-Bold.ttf"));
        CalligraphyTypefaceSpan typefaceBoldSpan2 = new CalligraphyTypefaceSpan(TypefaceUtils.load(getAssets(), "fonts/PeridotPE-Bold.ttf"));
        sBuilder.setSpan(typefaceRegularSpan, 0, getString(R.string.cos_wallet_text3).length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        sBuilder.setSpan(typefaceBoldSpan, getString(R.string.cos_wallet_text3).length(), getString(R.string.cos_wallet_text3).length() + badgeValue.length() + 1, Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        sBuilder.setSpan(typefaceRegularSpan2, getString(R.string.cos_wallet_text3).length() + badgeValue.length() + 1, getString(R.string.cos_wallet_text3).length() + badgeValue.length() + 1 + getString(R.string.cos_wallet_text4).length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        sBuilder.setSpan(typefaceBoldSpan2, getString(R.string.cos_wallet_text3).length() + badgeValue.length() + 1 + getString(R.string.cos_wallet_text4).length(), getString(R.string.cos_wallet_text3).length() + badgeValue.length() + 1 + getString(R.string.cos_wallet_text4).length() + String.valueOf(WarplyManagerHelper.getLoyaltyBadge().getCouponCount()).length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        sBuilder.setSpan(typefaceRegularSpan3, getString(R.string.cos_wallet_text3).length() + 1 + badgeValue.length() + 1 + getString(R.string.cos_wallet_text4).length() + String.valueOf(WarplyManagerHelper.getLoyaltyBadge().getCouponCount()).length(), getString(R.string.cos_wallet_text3).length() + badgeValue.length() + 1 + getString(R.string.cos_wallet_text4).length() + String.valueOf(WarplyManagerHelper.getLoyaltyBadge().getCouponCount()).length() + getString(R.string.cos_wallet_text5).length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);

        mTvCouponsValueAll.setText(sBuilder, TextView.BufferType.SPANNABLE);

        if (WarplyManagerHelper.getCouponExpiredList() != null && WarplyManagerHelper.getCouponExpiredList().size() > 0) {
            if (WarplyManagerHelper.getCouponExpiredList().size() > 3) {
                ArrayList<Coupon> tempList = new ArrayList<>(WarplyManagerHelper.getCouponExpiredList().subList(0, 3));

                mRvExpiredCoupons.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
                mAdapterExpiredCoupons = new ExpiredCouponAdapter(this, tempList);
                mRvExpiredCoupons.setAdapter(mAdapterExpiredCoupons);
                mLlShowMoreExpired.setVisibility(View.VISIBLE);
                return;
            }

            mRvExpiredCoupons.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
            mAdapterExpiredCoupons = new ExpiredCouponAdapter(this, WarplyManagerHelper.getCouponExpiredList());
            mRvExpiredCoupons.setAdapter(mAdapterExpiredCoupons);
        } else {
            mTvExpiredEmpty.setVisibility(View.VISIBLE);
        }
    }

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================

    private CallbackReceiver<SharingList> mSharingHistoryCallback = new CallbackReceiver<SharingList>() {
        @Override
        public void onSuccess(SharingList result) {
            if (result != null && result.size() > 0) {
                if (WarplyManagerHelper.getCouponsets() != null && WarplyManagerHelper.getCouponsets().size() > 0) {
                    for (SharingCoupon shCoupon : result) {
                        for (Couponset cpnset : WarplyManagerHelper.getCouponsets()) {
                            if (shCoupon.getCouponsetUuid().equals(cpnset.getUuid())) {
                                SharingCoupon newShCoupon = new SharingCoupon();
                                newShCoupon = shCoupon;
                                newShCoupon.setName(cpnset.getName());
                                newShCoupon.setFinal_price(cpnset.getFinal_price());
                                mSharedCoupons.add(newShCoupon);
                                break;
                            }
                        }
                    }
                }
            }

            runOnUiThread(() -> {
                if (mSharedCoupons != null && mSharedCoupons.size() > 0) {
                    if (mSharedCoupons.size() > 3) {
                        ArrayList<SharingCoupon> tempList = new ArrayList<>(mSharedCoupons.subList(0, 3));

                        mRvSharedCoupons.setLayoutManager(new LinearLayoutManager(LoyaltyAnalysisActivity.this, LinearLayoutManager.VERTICAL, false));
                        mAdapterSharedCoupons = new SharedCouponAdapter(LoyaltyAnalysisActivity.this, tempList);
                        mRvSharedCoupons.setAdapter(mAdapterSharedCoupons);
                        mLlShowMoreShared.setVisibility(View.VISIBLE);
                        return;
                    }

                    mRvSharedCoupons.setLayoutManager(new LinearLayoutManager(LoyaltyAnalysisActivity.this, LinearLayoutManager.VERTICAL, false));
                    mAdapterSharedCoupons = new SharedCouponAdapter(LoyaltyAnalysisActivity.this, mSharedCoupons);
                    mRvSharedCoupons.setAdapter(mAdapterSharedCoupons);
                } else {
                    mTvSharedEmpty.setVisibility(View.VISIBLE);
                }
            });
        }

        @Override
        public void onFailure(int errorCode) {
            WarpUtils.log("SHARED_COUPONS_ERROR " + String.valueOf(errorCode));
        }
    };
}
