package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ScrollView;
import android.widget.TextView;

import androidx.appcompat.app.AlertDialog;
import androidx.cardview.widget.CardView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.widget.NestedScrollView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;

import net.cachapa.expandablelayout.ExpandableLayout;

import org.apmem.tools.layouts.FlowLayout;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

import io.github.inflationx.calligraphy3.CalligraphyTypefaceSpan;
import io.github.inflationx.calligraphy3.TypefaceUtils;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import ly.warp.sdk.R;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.ActiveDFYCouponEventModel;
import ly.warp.sdk.io.models.ActiveDFYCouponModel;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.UnifiedCoupon;
import ly.warp.sdk.io.models.WarplyDealsAnalysisEventModel;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import ly.warp.sdk.views.adapters.ActiveCouponAdapter;
import ly.warp.sdk.views.adapters.MarketCouponAdapter;


public class LoyaltyWallet extends Activity implements View.OnClickListener, View.OnScrollChangeListener {

    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================

    private ImageView mIvBack, mIvDealsLogo, mIvProfilePhoto, mIvExpArrow;
    private TextView mTvUsername, mTvDealsValue, mTvDealsValueAll,
            mTvUserBadge, mTvGiftsValue, mTvGiftsValueAll, mTvActiveCode, mTvActiveDate,
            mTvActiveTitle, mTvActiveCouponsHeader, mTvMarketValue, mTvMarketAll, mTvFavValue, mTvFavValueAll;
    private ConstraintLayout mClDealsBanner, mClDealsView,
            mClGiftsBanner, mClToolbar, mClMarket;
    private LinearLayout mLlQuestionnaire, mLlUserBadge, mLlEmptyWallet, mLlDeals, mLlGifts,
            mLlMarketView;
    private FlowLayout mLlActiveCodesView;
    private float couponDfyValue = 0.0f, mFavValue = 0.0f;
    private RecyclerView mRecyclerCoupons, mRvMarketCoupons;
    private ActiveCouponAdapter mAdapterCoupons;
    private AlertDialog mAlertDialogNonTelco;
    private ScrollView mScActiveCodes;
    private NestedScrollView mSvLoyaltyWallet;
    private int mTimer = 0;
    private Handler mSecondsHandler;
    private ArrayList<UnifiedCoupon> mUnifiedCoupons = new ArrayList<UnifiedCoupon>();
    private float countValue = 0.0f;
    private MarketCouponAdapter mAdapterMarketCoupons;
    private ExpandableLayout mElGifts;
    private boolean mIsStayCollapsed = true;
    private CardView mClExp;
    private boolean mDfyPressed = false, mDealsBannerPressed = false, mQuestionnairePressed = false,
            mHistoryPressed = false, mHistoryMarketPressed = false, mUnifiedPressed = false,
            mCouponPressed = false;

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_loyalty_wallet);
        mSecondsHandler = new Handler();

        mIvBack = findViewById(R.id.iv_back);
        mTvUsername = findViewById(R.id.tv_profile_name);
        mLlQuestionnaire = findViewById(R.id.ll_user_questionnaire);
        mLlUserBadge = findViewById(R.id.ll_user_badge);
        mTvUserBadge = findViewById(R.id.tv_type);
        mTvGiftsValue = findViewById(R.id.tv_gifts_value);
        mTvGiftsValueAll = findViewById(R.id.tv_gifts_value_all);
        mClDealsBanner = findViewById(R.id.cl_deals_win_inner_cos);
        mClGiftsBanner = findViewById(R.id.cl_deals_win_inner);
        mTvDealsValue = findViewById(R.id.tv_deals_value);
        mTvDealsValueAll = findViewById(R.id.tv_deals_value_all);
        mTvActiveCode = findViewById(R.id.tv_active_deals_text);
        mTvActiveDate = findViewById(R.id.tv_active_deals_date_text);
        mIvDealsLogo = findViewById(R.id.dfy_logo);
        mClDealsView = findViewById(R.id.cl_mygifts);
        mLlDeals = findViewById(R.id.ll_mygifts);
        mIvProfilePhoto = findViewById(R.id.iv_profile_photo);
        mTvActiveTitle = findViewById(R.id.tv_active_gifts);
        mTvActiveCouponsHeader = findViewById(R.id.tv_active_coupons_header);
        mLlEmptyWallet = findViewById(R.id.ll_empty_wallet);
        mLlActiveCodesView = findViewById(R.id.ll_active_deals_codes_view);
        mScActiveCodes = findViewById(R.id.sv_active_deals_codes_view);
        mSvLoyaltyWallet = findViewById(R.id.sv_loyalty_wallet);
        mClToolbar = findViewById(R.id.cl_loyalty_wallet_header);
        mLlGifts = findViewById(R.id.ll_gifts_view);
        mLlMarketView = findViewById(R.id.ll_market_view);
        mRvMarketCoupons = findViewById(R.id.rv_market_coupons);
        mRvMarketCoupons.setNestedScrollingEnabled(false);
        mRvMarketCoupons.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
        mElGifts = findViewById(R.id.el_exp);
        mClExp = findViewById(R.id.cl_exp);
        mIvExpArrow = findViewById(R.id.iv_exp_arrow);
        mTvMarketValue = findViewById(R.id.tv_market_value);
        mTvMarketAll = findViewById(R.id.tv_market_value_all);
        mClMarket = findViewById(R.id.cl_market_inner);
        mTvFavValue = findViewById(R.id.tv_exp_value);
        mTvFavValueAll = findViewById(R.id.tv_exp_value_all);

        if (WarplyManagerHelper.getActiveDFYCoupons() != null) {
            Collections.sort(WarplyManagerHelper.getActiveDFYCoupons(), new Comparator<ActiveDFYCouponModel>() {
                public int compare(ActiveDFYCouponModel o1, ActiveDFYCouponModel o2) {
                    return o1.getDate().compareTo(o2.getDate());
                }
            });

//            for (ActiveDFYCouponModel dfycoupon : WarplyManagerHelper.getActiveDFYCoupons()) {
//                try {
//                    couponDfyValue += Float.parseFloat(dfycoupon.getValue());
//                } catch (NumberFormatException e) {
//
//                }
//            }
        }

        mRecyclerCoupons = findViewById(R.id.rv_active_coupons);
        mRecyclerCoupons.setNestedScrollingEnabled(false);
        mRecyclerCoupons.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));

//        initViews();

        WarplyManager.getUnifiedCoupons(mUnifiedCallback);
    }

    @Override
    protected void onStart() {
        super.onStart();
        EventBus.getDefault().register(this);
    }

    @Override
    protected void onStop() {
        super.onStop();
        EventBus.getDefault().unregister(this);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent(this, "screen", "LoyaltyWalletScreen");
        mTimer = 0;
        mSecondsHandler.post(new Runnable() {
            @Override
            public void run() {
                mTimer++;
                mSecondsHandler.postDelayed(this, 1000);
            }
        });
        mDfyPressed = false;
        mDealsBannerPressed = false;
        mQuestionnairePressed = false;
        mHistoryPressed = false;
        mHistoryMarketPressed = false;
        mUnifiedPressed = false;
        mCouponPressed = false;
    }

    @Override
    public void onPause() {
        super.onPause();
        if (mSecondsHandler != null) {
            mSecondsHandler.removeCallbacksAndMessages(null);

            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("time_spent_on_loyalty_sdk");
            analyticsEvent.setParameter("name", "MyRewards");
            analyticsEvent.setParameter("seconds", String.valueOf(mTimer));
            EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));
        }
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.iv_back) {
            onBackPressed();
            return;
        }
        if (view.getId() == R.id.ll_user_questionnaire || view.getId() == R.id.ll_user_badge) {
            if (!mQuestionnairePressed) {
                mQuestionnairePressed = true;
                WarplyAnalyticsManager.logTrackersEvent(this, "click", ("LoyaltyWalletScreen")
                        .concat(":")
                        .concat("Questionnaire"));

                startActivityForResult(WarpViewActivity.createIntentFromURL(LoyaltyWallet.this, WarplyManagerHelper.openQuestionnaire()), 1000);
            }
            return;
        }
        if (view.getId() == R.id.cl_deals_win_inner_cos) {
            if (!mDealsBannerPressed) {
                mDealsBannerPressed = true;
                WarplyAnalyticsManager.logTrackersEvent(this, "click", ("LoyaltyWalletScreen")
                        .concat(":")
                        .concat("DealsBanner"));

                WarpUtils.log("DFY coupon banner pressed!");
                WarplyDealsAnalysisEventModel warplyDealsAnalysisEventModel = new WarplyDealsAnalysisEventModel();
                warplyDealsAnalysisEventModel.setPressed(true);
                EventBus.getDefault().post(new WarplyEventBusManager(warplyDealsAnalysisEventModel));

                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("did_tap_deals_for_you_badge");
                analyticsEvent.setParameter("screen", "Loyalty Wallet");
                EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));
            }
            return;
        }
        if (view.getId() == R.id.cl_deals_win_inner) {
            if (!mHistoryPressed) {
                mHistoryPressed = true;
                WarplyAnalyticsManager.logTrackersEvent(this, "click", ("LoyaltyWalletScreen")
                        .concat(":")
                        .concat("LoyaltyBanner"));

                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("did_tap_gifts_for_you_badge");
                analyticsEvent.setParameter("screen", "Loyalty Wallet");
                EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));

                Intent intent = new Intent(LoyaltyWallet.this, LoyaltyAnalysisActivity.class);
                startActivity(intent);
            }
            return;
        }
        if (view.getId() == R.id.cl_exp) {
            if (!mIsStayCollapsed) {
                mElGifts.toggle(true);
                if (mElGifts.isExpanded()) {
                    mIvExpArrow.setImageDrawable(ContextCompat.getDrawable(this, R.drawable.ic_up_dark_new));
                } else {
                    mIvExpArrow.setImageDrawable(ContextCompat.getDrawable(this, R.drawable.ic_down_dark_new));
                }
            }
            return;
        }
        if (view.getId() == R.id.cl_market_inner) {
//            if (countValue > 0) {
            if (!mHistoryMarketPressed) {
                mHistoryMarketPressed = true;
                WarplyAnalyticsManager.logTrackersEvent(this, "click", ("LoyaltyWalletScreen")
                        .concat(":")
                        .concat("MarketBanner"));
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("did_tap_market_badge");
                analyticsEvent.setParameter("screen", "Loyalty Wallet");
                EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));
                Intent intent = new Intent(LoyaltyWallet.this, LoyaltyMarketAnalysisActivity.class);
                startActivity(intent);
            }
//            }
            return;
        }
        if (view.getId() == R.id.cl_mygifts) {
            if (!mDfyPressed) {
                mDfyPressed = true;
                WarplyAnalyticsManager.logTrackersEvent(this, "click", ("LoyaltyWalletScreen")
                        .concat(":")
                        .concat("ActiveDealsBanner"));

                ActiveDFYCouponEventModel activeCouponEventModel = new ActiveDFYCouponEventModel();
                activeCouponEventModel.setPressed(true);
                EventBus.getDefault().post(new WarplyEventBusManager(activeCouponEventModel));
            }
        }
    }

    @Override
    public void onScrollChange(View view, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
        if (scrollY > oldScrollY) {
            mClToolbar.setElevation(14);
        }
        if (scrollY < oldScrollY) {
            mClToolbar.setElevation(14);
        }
        if (scrollY == 0) {
            mClToolbar.setElevation(0);
        }
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1000) {
            if (resultCode == RESULT_OK) {
                if (!TextUtils.isEmpty(WarplyManagerHelper.getUserTag(LoyaltyWallet.this))) {
                    mTvUserBadge.setText(WarplyManagerHelper.getUserTag(LoyaltyWallet.this));
                    mLlQuestionnaire.setVisibility(View.GONE);
                    mLlUserBadge.setVisibility(View.VISIBLE);
                } else {
                    mLlUserBadge.setVisibility(View.GONE);
                    mLlQuestionnaire.setVisibility(View.VISIBLE);
                }
            }
        }
    }

    @Subscribe()
    public void onMessageEvent(WarplyEventBusManager event) {
        if (event.getCouponsAdded() != null) {
            mCouponPressed = false;
            CouponList tempCouponList = new CouponList();
            CouponList cpnlist = new CouponList();
            tempCouponList.clear();
            tempCouponList.addAll(WarplyManagerHelper.getCouponList());

            for (Coupon cpn : tempCouponList) {
                if (cpn.getStatus() == 1) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                    Date newDate = new Date();
                    try {
                        newDate = simpleDateFormat.parse(cpn.getExpiration());
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    cpn.setExpirationDate(newDate);
                    cpnlist.add(cpn);
                }
            }

            Collections.sort(cpnlist, (coupon1, coupon2) -> coupon1.getExpirationDate().compareTo(coupon2.getExpirationDate()));

            runOnUiThread(() -> {
                if (cpnlist != null && cpnlist.size() > 0) {
                    mAdapterCoupons = new ActiveCouponAdapter(this, cpnlist);
                    mRecyclerCoupons.setAdapter(mAdapterCoupons);
                    mAdapterCoupons.getPositionClicks()
                            .doOnNext(coupon -> {
                                if (!mCouponPressed) {
                                    mCouponPressed = true;
                                    WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Coupon").concat(":").concat(coupon.getName()));
                                    Intent intent = new Intent(LoyaltyWallet.this, CouponInfoActivity.class);
                                    intent.putExtra("coupon", (Serializable) coupon);
                                    intent.putExtra("isFromWallet", true);
                                    startActivityForResult(intent, 1002);
                                }
                            })
                            .doOnError(error -> {
                            })
                            .subscribe();
                    mAdapterCoupons.notifyDataSetChanged();
                } else {
                    mLlGifts.setVisibility(View.GONE);
                }
            });
        }
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(ViewPumpContextWrapper.wrap(newBase));
    }

    // ===========================================================
    // Methods
    // ===========================================================

    private void initViews() {
        if (WarpUtils.getUserNonTelco(this)) {
            nonTelcoDialog();
        }

        if (mUnifiedCoupons != null && mUnifiedCoupons.size() > 0) {
            ArrayList<UnifiedCoupon> unilist = new ArrayList<UnifiedCoupon>();
            for (UnifiedCoupon unicpn : mUnifiedCoupons) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                Date newDate = new Date();
                try {
                    newDate = simpleDateFormat.parse(unicpn.getCreated());
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                unicpn.setExpirationDate(newDate);
                unilist.add(unicpn);
            }

            Collections.sort(unilist, (coupon1, coupon2) -> coupon2.getExpirationDate().compareTo(coupon1.getExpirationDate()));

            mAdapterMarketCoupons = new MarketCouponAdapter(this, unilist);
            mRvMarketCoupons.setAdapter(mAdapterMarketCoupons);
            mAdapterMarketCoupons.getPositionClicks()
                    .doOnNext(coupon -> {
                        if (!mUnifiedPressed) {
                            mUnifiedPressed = true;
                            WarplyAnalyticsManager.logTrackersEvent(this, "click", ("UnifiedCoupon").concat(":").concat(coupon.getBarcode()));
                            Intent intent = new Intent(LoyaltyWallet.this, UnifiedCouponInfoActivity.class);
                            intent.putExtra("coupon", (Serializable) coupon);
                            intent.putExtra("isFromWallet", true);
                            startActivity(intent);
                        }
//                        startActivityForResult(intent, 1002);
                    })
                    .doOnError(error -> {
                    })
                    .subscribe();
            mLlMarketView.setVisibility(View.VISIBLE);
        } else {
            mLlMarketView.setVisibility(View.GONE);
        }

        if (WarplyManagerHelper.getCouponList() != null && WarplyManagerHelper.getCouponList().size() > 0) {
            CouponList cpnlist = new CouponList();
            for (Coupon cpn : WarplyManagerHelper.getCouponList()) {
                if (cpn.getStatus() == 1) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                    Date newDate = new Date();
                    try {
                        newDate = simpleDateFormat.parse(cpn.getExpiration());
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    cpn.setExpirationDate(newDate);
                    cpnlist.add(cpn);
                }
            }

            Collections.sort(cpnlist, (coupon1, coupon2) -> coupon1.getExpirationDate().compareTo(coupon2.getExpirationDate()));

            mAdapterCoupons = new ActiveCouponAdapter(this, cpnlist);
            mRecyclerCoupons.setAdapter(mAdapterCoupons);
            mAdapterCoupons.getPositionClicks()
                    .doOnNext(coupon -> {
                        if (!mCouponPressed) {
                            mCouponPressed = true;
                            WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Coupon").concat(":").concat(coupon.getName()));
                            Intent intent = new Intent(LoyaltyWallet.this, CouponInfoActivity.class);
                            intent.putExtra("coupon", (Serializable) coupon);
                            intent.putExtra("isFromWallet", true);
                            startActivityForResult(intent, 1002);
                        }
                    })
                    .doOnError(error -> {
                    })
                    .subscribe();
            mLlGifts.setVisibility(View.VISIBLE);
        } else {
            mLlGifts.setVisibility(View.GONE);
        }

        // First Expandable Banner
        String badgeValueFirst = String.format("%.02f", WarplyManagerHelper.getDealsCouponsSum());
        mTvDealsValue.setText(String.format(getString(R.string.cos_value), badgeValueFirst));
        if (String.valueOf(WarplyManagerHelper.getDealsCouponsSum()).length() >= 3) {
            mTvDealsValue.setTextSize(12);
        } else {
            mTvDealsValue.setTextSize(14);
        }
        SpannableStringBuilder sBuilder = new SpannableStringBuilder();
        sBuilder.append(String.format(getString(R.string.cos_deals_win_title_cos), badgeValueFirst));
        CalligraphyTypefaceSpan typefaceBoldSpanFirst = new CalligraphyTypefaceSpan(TypefaceUtils.load(getAssets(), "fonts/PeridotPE-Bold.ttf"));
        sBuilder.setSpan(typefaceBoldSpanFirst, 15, 16 + badgeValueFirst.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        mTvDealsValueAll.setText(sBuilder, TextView.BufferType.SPANNABLE);
        mFavValue += WarplyManagerHelper.getDealsCouponsSum();

        // Second Expandable Banner
        if (WarplyManagerHelper.getLoyaltyBadge() != null && (WarplyManagerHelper.getLoyaltyBadge().getCouponCount() > 0 || WarplyManagerHelper.getLoyaltyBadge().getCouponCount() == 0)) {
            String badgeValue = String.format("%.02f", WarplyManagerHelper.getLoyaltyBadge().getValue());
            mTvGiftsValue.setText(String.format(getString(R.string.cos_value), badgeValue));
            if (String.valueOf(WarplyManagerHelper.getLoyaltyBadge().getValue()).length() >= 3) {
                mTvGiftsValue.setTextSize(12);
            } else {
                mTvGiftsValue.setTextSize(14);
            }
            SpannableStringBuilder sBuilderSecond = new SpannableStringBuilder();
            sBuilderSecond.append(String.format(getString(R.string.cos_deals_win_title), badgeValue));
            CalligraphyTypefaceSpan typefaceBoldSpanSecond = new CalligraphyTypefaceSpan(TypefaceUtils.load(getAssets(), "fonts/PeridotPE-Bold.ttf"));
            sBuilderSecond.setSpan(typefaceBoldSpanSecond, 15, 16 + badgeValue.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            mTvGiftsValueAll.setText(sBuilderSecond, TextView.BufferType.SPANNABLE);
            mFavValue += WarplyManagerHelper.getLoyaltyBadge().getValue();
        }

        // Third Expandable Banner
        if (WarplyManagerHelper.getMarketCoupons().size() > 0) {
            countValue = 0.0f;
            for (UnifiedCoupon unicou : WarplyManagerHelper.getMarketCoupons()) {
                if (unicou.getCoupons() != null && unicou.getCoupons().size() > 0) {
                    for (Coupon inncou : unicou.getCoupons()) {
                        if (inncou.getStatus() == 0) {
                            countValue += Float.valueOf(inncou.getDiscount());
                        }
                    }
                }
            }
            mFavValue += countValue;
            String badgeValue = String.format("%.02f", countValue);
            mTvMarketValue.setText(String.format(getString(R.string.cos_value), badgeValue));
            if (String.valueOf(countValue).length() >= 3) {
                mTvMarketValue.setTextSize(12);
            } else {
                mTvMarketValue.setTextSize(14);
            }
            SpannableStringBuilder sBuilderThird = new SpannableStringBuilder();
            sBuilderThird.append(String.format(getString(R.string.cos_supermarket_win), badgeValue));
            CalligraphyTypefaceSpan typefaceBoldSpanThird = new CalligraphyTypefaceSpan(TypefaceUtils.load(getAssets(), "fonts/PeridotPE-Bold.ttf"));
            sBuilderThird.setSpan(typefaceBoldSpanThird, 15, 16 + badgeValue.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
            mTvMarketAll.setText(sBuilderThird, TextView.BufferType.SPANNABLE);
        } else {
            String badgeValue = String.format("%.02f", 0.0f);
            mTvMarketValue.setText(String.format(getString(R.string.cos_value), badgeValue));
        }

        // Sum Expandable Banner
        String allValue = String.format("%.02f", mFavValue);
        mTvFavValue.setText(String.format(getString(R.string.cos_value), allValue));
        if (String.valueOf(mFavValue).length() >= 3) {
            mTvFavValue.setTextSize(12);
        } else {
            mTvFavValue.setTextSize(14);
        }
        SpannableStringBuilder sBuilderExp = new SpannableStringBuilder();
        sBuilderExp.append(String.format(getString(R.string.cos_for_you_all), allValue));
        CalligraphyTypefaceSpan typefaceBoldExp = new CalligraphyTypefaceSpan(TypefaceUtils.load(getAssets(), "fonts/PeridotPE-Bold.ttf"));
        sBuilderExp.setSpan(typefaceBoldExp, 26, 27 + allValue.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
        mTvFavValueAll.setText(sBuilderExp, TextView.BufferType.SPANNABLE);
        mClExp.setVisibility(View.VISIBLE);

        if (WarplyManagerHelper.getActiveDFYCoupons() != null && WarplyManagerHelper.getActiveDFYCoupons().size() > 0) {
            String codes = "";
            if (WarplyManagerHelper.getActiveDFYCoupons().size() == 1) {
                codes = WarplyManagerHelper.getActiveDFYCoupons().get(0).getCode();
                mTvActiveTitle.setText(String.format(getString(R.string.cos_active_deals), String.valueOf(1)));

                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                String date1 = WarplyManagerHelper.getActiveDFYCoupons().get(0).getDate();
                String date2 = dateFormat.format(new Date());

                mTvActiveCode.setText(codes);

                try {
                    Date toDate = dateFormat.parse(date2);
                    Date fromDate = dateFormat.parse(date1);
                    long diff = TimeUnit.MILLISECONDS.toDays(fromDate.getTime() - toDate.getTime()) + 1;
                    mTvActiveDate.setText(String.format(getString(R.string.cos_active_coupon_date), String.valueOf(diff)));
                    mTvActiveDate.setVisibility(View.VISIBLE);
                } catch (ParseException e) {
                    e.printStackTrace();
                }
            } else {
//                for (ActiveDFYCouponModel coupon : WarplyManagerHelper.getActiveDFYCoupons()) {
//                    codes = codes + coupon.getCode() + ",";
//                }
//                codes = codes.substring(0, codes.length() - 1);

                mTvActiveTitle.setText(String.format(getString(R.string.cos_active_deals_plural), String.valueOf(WarplyManagerHelper.getActiveDFYCoupons().size())));
                mTvActiveCode.setVisibility(View.GONE);

//                Collections.reverse(WarplyManagerHelper.getActiveDFYCoupons());
                for (int i = 0; i < WarplyManagerHelper.getActiveDFYCoupons().size(); i++) {
                    LayoutInflater vi = (LayoutInflater) getApplicationContext().getSystemService(Context.LAYOUT_INFLATER_SERVICE);
                    LinearLayout v = (LinearLayout) vi.inflate(R.layout.item_selectable, null);
                    TextView textView = (TextView) v.findViewById(R.id.tv_code_copy);
                    TextView textViewComma = (TextView) v.findViewById(R.id.tv_code_comma);
                    CalligraphyTypefaceSpan typefaceBoldSpanDFY = new CalligraphyTypefaceSpan(TypefaceUtils.load(getAssets(), "fonts/PeridotPE-Bold.ttf"));
                    SpannableStringBuilder sBuilderDFY = new SpannableStringBuilder(WarplyManagerHelper.getActiveDFYCoupons().get(i).getCode());
                    SpannableStringBuilder sBuilderComma = new SpannableStringBuilder(getString(R.string.cos_comma));
                    sBuilderDFY.setSpan(typefaceBoldSpanDFY, 0, sBuilderDFY.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                    sBuilderComma.setSpan(typefaceBoldSpanDFY, 0, sBuilderComma.length(), Spanned.SPAN_EXCLUSIVE_EXCLUSIVE);
                    textView.setText(sBuilder, TextView.BufferType.SPANNABLE);
                    textView.setTextIsSelectable(true);
                    textViewComma.setText(sBuilderComma, TextView.BufferType.SPANNABLE);
                    mLlActiveCodesView.addView(v, 0, new ViewGroup.LayoutParams(
                            ViewGroup.LayoutParams.WRAP_CONTENT,
                            ViewGroup.LayoutParams.WRAP_CONTENT));
                }

                mScActiveCodes.setVisibility(View.VISIBLE);
                mLlActiveCodesView.setVisibility(View.VISIBLE);
            }
//            mTvActiveCode.setText(codes);
            mLlDeals.setVisibility(View.VISIBLE);
        } else {
            mLlDeals.setVisibility(View.GONE);
        }

        if (WarplyManagerHelper.getConsumer() != null) {
            mTvUsername.setText(String.format(getResources().getString(R.string.cos_profile_loyalty_name),
                    WarplyManagerHelper.getConsumer().getFirstName(), WarplyManagerHelper.getConsumer().getLastName()));

            if (!TextUtils.isEmpty(WarplyManagerHelper.getConsumer().getImageUrl()) && !WarplyManagerHelper.getConsumer().getImageUrl().equals("null")) {
                Glide.with(this)
                        .load(WarplyManagerHelper.getConsumer().getImageUrl())
                        .diskCacheStrategy(DiskCacheStrategy.DATA)
                        .into(mIvProfilePhoto);
            } else {
                Glide.with(this)
                        .load(R.drawable.ic_default_photo)
                        .into(mIvProfilePhoto);
            }

            if (!TextUtils.isEmpty(WarplyManagerHelper.getUserTag(this))) {
                mTvUserBadge.setText(WarplyManagerHelper.getUserTag(this));
                mLlQuestionnaire.setVisibility(View.GONE);
                mLlUserBadge.setVisibility(View.VISIBLE);
            } else {
                mLlUserBadge.setVisibility(View.GONE);
                mLlQuestionnaire.setVisibility(View.VISIBLE);
            }
        }

        if (mLlMarketView.getVisibility() == View.GONE
                && WarplyManagerHelper.getDealsCouponsSum() == 0
                && (WarplyManagerHelper.getLoyaltyBadge() != null && WarplyManagerHelper.getLoyaltyBadge().getCouponCount() == 0)
                && countValue == 0) {
            mIvExpArrow.setVisibility(View.GONE);
//            mLlEmptyWallet.setVisibility(View.VISIBLE);
            mIsStayCollapsed = true;
        } else {
            mIvExpArrow.setVisibility(View.VISIBLE);
            mIsStayCollapsed = false;
        }

        mIvBack.setOnClickListener(this);
        mLlQuestionnaire.setOnClickListener(this);
        mLlUserBadge.setOnClickListener(this);
        mClDealsBanner.setOnClickListener(this);
        mClGiftsBanner.setOnClickListener(this);
        mClDealsView.setOnClickListener(this);
        mSvLoyaltyWallet.setOnScrollChangeListener(this);
        mClExp.setOnClickListener(this);
        mClMarket.setOnClickListener(this);
    }

    private void nonTelcoDialog() {
        if (!isFinishing()) {
            mAlertDialogNonTelco = new AlertDialog.Builder(this)
                    .setTitle(R.string.cos_dlg_non_telco_title)
                    .setMessage(R.string.cos_dlg_non_telco)
                    .setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                        dialogPositive.dismiss();
                        onBackPressed();
                    })
                    .setCancelable(false)
                    .show();
        }
    }

    private final CallbackReceiver<ArrayList<UnifiedCoupon>> mUnifiedCallback = new CallbackReceiver<ArrayList<UnifiedCoupon>>() {
        @Override
        public void onSuccess(ArrayList<UnifiedCoupon> result) {
            mUnifiedCoupons = result;
            initViews();
        }

        @Override
        public void onFailure(int errorCode) {
            initViews();
        }
    };

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================

}
