package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.io.models.LoyaltyContextualOfferModel;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.MergedMore;
import ly.warp.sdk.services.EventCampaignService;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import ly.warp.sdk.views.adapters.MoreCampaignAdapter;
import ly.warp.sdk.views.adapters.MoreContextualAdapter;


public class MoreForYouActivity extends Activity implements View.OnClickListener {

    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================

    private ImageView mIvBack, mIvPopupClose;
    private RecyclerView mRecyclerMore;
    private TextView mTvTitle;
    private LinearLayout mLlMorePopup;
    private ArrayList<Campaign> mValuesList = new ArrayList<>();
    private ArrayList<LoyaltyContextualOfferModel> mContextualList = new ArrayList<>();
    private ArrayList<MergedMore> mData = new ArrayList();

    /**
     * New Implementation
     */
    private Map<String, ArrayList<Campaign>> mUniqueSectionList = new HashMap<>();
    private RecyclerView mResearchItems;
    private TextView mTvResearchSection;
    private LinearLayout mLlResearchItems;
    private RecyclerView mExclusiveItems;
    private TextView mTvExclusiveSection;
    private LinearLayout mLlExclusiveItems;
    private RecyclerView mContestItems;
    private TextView mTvContestSection;
    private LinearLayout mLlContestItems;
    private MoreCampaignAdapter mAdapterResearch, mAdapterExclusive, mAdapterContest;
    private RecyclerView mContextualItems;
    private TextView mTvContextualSection;
    private LinearLayout mLlContextualItems;
    private MoreContextualAdapter mAdapterContextual;
    private int mTimer = 0;
    private Handler mSecondsHandler;

    /**
     * New Implementation
     */

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_more_for_you);
        mSecondsHandler = new Handler();

        mIvBack = findViewById(R.id.iv_list_close);
        mTvTitle = findViewById(R.id.textView3);
        mIvPopupClose = findViewById(R.id.iv_popup_more_close);
        mLlMorePopup = findViewById(R.id.ll_more_popup);

        mRecyclerMore = findViewById(R.id.rv_more_items);

        /** New Implementation */
        mTvResearchSection = findViewById(R.id.tv_research_section);
        mLlResearchItems = findViewById(R.id.ll_research_items);
        mResearchItems = findViewById(R.id.rv_research_items);
        mTvExclusiveSection = findViewById(R.id.tv_exclusive_section);
        mLlExclusiveItems = findViewById(R.id.ll_exclusive_items);
        mExclusiveItems = findViewById(R.id.rv_exclusive_items);
        mTvContestSection = findViewById(R.id.tv_contest_section);
        mLlContestItems = findViewById(R.id.ll_contest_items);
        mContestItems = findViewById(R.id.rv_contest_items);
        mTvContextualSection = findViewById(R.id.tv_contextual_section);
        mLlContextualItems = findViewById(R.id.ll_contextual_items);
        mContextualItems = findViewById(R.id.rv_contextual_items);
        /** New Implementation */

        /** New Implementation */
        filterItemsNew();
        /** New Implementation */

        if (WarplyManagerHelper.getCCMSLoyaltyCampaigns() != null && WarplyManagerHelper.getCCMSLoyaltyCampaigns().size() > 0) {
            mContextualList.clear();
            for (LoyaltyContextualOfferModel ccmsItem : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                if ((TextUtils.isEmpty(ccmsItem.getLoyaltyCampaignId()) || ccmsItem.getLoyaltyCampaignId().equals("NA"))
                        && ccmsItem.getZone().equals("COSMOTE_APP_MORE4U"))
                    mContextualList.add(ccmsItem);
            }
        }

        /** New Implementation */
        initViewsNew();
        /** New Implementation */
    }

    @Override
    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent(this, "screen", "MoreForYouScreen");
        mTimer = 0;
        mSecondsHandler.post(new Runnable() {
            @Override
            public void run() {
                mTimer++;
                mSecondsHandler.postDelayed(this, 1000);
            }
        });
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    @Override
    public void onPause() {
        super.onPause();
        if (mSecondsHandler != null) {
            mSecondsHandler.removeCallbacksAndMessages(null);

            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("time_spent_on_loyalty_sdk");
            analyticsEvent.setParameter("name", "MoreForYou");
            analyticsEvent.setParameter("seconds", String.valueOf(mTimer));
            EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));
        }
    }

    @Override
    protected void onStart() {
        super.onStart();
        EventBus.getDefault().register(this);
    }

    @Override
    protected void onStop() {
        super.onStop();
        EventBus.getDefault().unregister(this);
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.iv_list_close) {
            onBackPressed();
            return;
        }
        if (view.getId() == R.id.iv_popup_more_close) {
            mLlMorePopup.setVisibility(View.GONE);
            WarpUtils.setMorePopup(this, false);
        }
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(ViewPumpContextWrapper.wrap(newBase));
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1003) {
            OneTimeWorkRequest mywork = new OneTimeWorkRequest.Builder(EventCampaignService.class).build();
            WorkManager.getInstance(MoreForYouActivity.this).enqueue(mywork);
        }
    }

    @Subscribe()
    public void onMessageEvent(WarplyEventBusManager event) {
        if (event.getCcmsAdded() != null || event.getCampaignsAdded() != null) {
            /** New Implementation */
            filterItemsNew();
            /** New Implementation */

            if (WarplyManagerHelper.getCCMSLoyaltyCampaigns() != null && WarplyManagerHelper.getCCMSLoyaltyCampaigns().size() > 0) {
                mContextualList.clear();
                for (LoyaltyContextualOfferModel ccmsItem : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                    if ((TextUtils.isEmpty(ccmsItem.getLoyaltyCampaignId()) || ccmsItem.getLoyaltyCampaignId().equals("NA"))
                            && ccmsItem.getZone().equals("COSMOTE_APP_MORE4U"))
                        mContextualList.add(ccmsItem);
                }
            }
            /** New Implementation */
            runOnUiThread(this::initViewsNew2);
            /** New Implementation */
        }
    }

    // ===========================================================
    // Methods
    // ===========================================================

    private void initViewsNew() {
        mIvBack.setOnClickListener(this);
        mIvPopupClose.setOnClickListener(this);

        if (mUniqueSectionList != null) {
            try {
                String firstKey = (String) mUniqueSectionList.keySet().toArray()[0];
                if (mUniqueSectionList.get(firstKey) != null && mUniqueSectionList.get(firstKey).size() > 0) {
                    mTvResearchSection.setText(firstKey.substring(1));
                    mResearchItems.setNestedScrollingEnabled(false);
                    mResearchItems.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
                    mAdapterResearch = new MoreCampaignAdapter(this, mUniqueSectionList.get(firstKey));
                    mResearchItems.setAdapter(mAdapterResearch);
                    mAdapterResearch.getPositionClicks()
                            .doOnNext(this::handleMoreItemClick)
                            .doOnError(error -> {
                            })
                            .subscribe();

                    mLlResearchItems.setVisibility(View.VISIBLE);
                }
            } catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }

            try {
                String secondKey = (String) mUniqueSectionList.keySet().toArray()[1];
                if (mUniqueSectionList.get(secondKey) != null && mUniqueSectionList.get(secondKey).size() > 0) {
                    mTvExclusiveSection.setText(secondKey.substring(1));
                    mExclusiveItems.setNestedScrollingEnabled(false);
                    mExclusiveItems.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
                    mAdapterExclusive = new MoreCampaignAdapter(this, mUniqueSectionList.get(secondKey));
                    mExclusiveItems.setAdapter(mAdapterExclusive);
                    mAdapterExclusive.getPositionClicks()
                            .doOnNext(this::handleMoreItemClick)
                            .doOnError(error -> {
                            })
                            .subscribe();

                    mLlExclusiveItems.setVisibility(View.VISIBLE);
                }
            } catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }

            try {
                String thirdKey = (String) mUniqueSectionList.keySet().toArray()[2];
                if (mUniqueSectionList.get(thirdKey) != null && mUniqueSectionList.get(thirdKey).size() > 0) {
                    mTvContestSection.setText(thirdKey.substring(1));
                    mContestItems.setNestedScrollingEnabled(false);
                    mContestItems.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
                    mAdapterContest = new MoreCampaignAdapter(this, mUniqueSectionList.get(thirdKey));
                    mContestItems.setAdapter(mAdapterContest);
                    mAdapterContest.getPositionClicks()
                            .doOnNext(this::handleMoreItemClick)
                            .doOnError(error -> {
                            })
                            .subscribe();

                    mLlContestItems.setVisibility(View.VISIBLE);
                }
            } catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }

            if (mContextualList != null && mContextualList.size() > 0) {
                mTvContextualSection.setText(getString(R.string.cos_mfy_other));
                mContextualItems.setNestedScrollingEnabled(false);
                mContextualItems.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));
                mAdapterContextual = new MoreContextualAdapter(this, mContextualList);
                mContextualItems.setAdapter(mAdapterContextual);
                mAdapterContextual.getPositionClicks()
                        .doOnNext(this::handleMoreContextualItemClick)
                        .doOnError(error -> {
                        })
                        .subscribe();

                mLlContextualItems.setVisibility(View.VISIBLE);
            }
        }
    }

    private void initViewsNew2() {
        mIvBack.setOnClickListener(this);
        mIvPopupClose.setOnClickListener(this);

        if (mUniqueSectionList != null) {
            try {
                String firstKey = (String) mUniqueSectionList.keySet().toArray()[0];
                if (mUniqueSectionList.get(firstKey) != null && mUniqueSectionList.get(firstKey).size() > 0) {
                    mTvResearchSection.setText(firstKey.substring(1));
//                    mResearchItems.setNestedScrollingEnabled(false);
//                    mAdapterResearch = new MoreCampaignAdapter(this, mUniqueSectionList.get(firstKey));
//                    mResearchItems.setItemAnimator(null);
//                    mAdapterResearch.setHasStableIds(true);
//                    mResearchItems.setAdapter(mAdapterResearch);
//                    mAdapterResearch.getPositionClicks()
//                            .doOnNext(this::handleMoreItemClick)
//                            .doOnError(error -> {
//                            })
//                            .subscribe();
//                    mAdapterResearch.notifyDataSetChanged();

                    mAdapterResearch.updateData(mUniqueSectionList.get(firstKey));

                    mLlResearchItems.setVisibility(View.VISIBLE);
                }
            } catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }

            try {
                String secondKey = (String) mUniqueSectionList.keySet().toArray()[1];
                if (mUniqueSectionList.get(secondKey) != null && mUniqueSectionList.get(secondKey).size() > 0) {
                    mTvExclusiveSection.setText(secondKey.substring(1));
//                    mExclusiveItems.setNestedScrollingEnabled(false);
//                    mAdapterExclusive = new MoreCampaignAdapter(this, mUniqueSectionList.get(secondKey));
//                    mExclusiveItems.setItemAnimator(null);
//                    mAdapterExclusive.setHasStableIds(true);
//                    mExclusiveItems.setAdapter(mAdapterExclusive);
//                    mAdapterExclusive.getPositionClicks()
//                            .doOnNext(this::handleMoreItemClick)
//                            .doOnError(error -> {
//                            })
//                            .subscribe();
//                    mAdapterExclusive.notifyDataSetChanged();

                    mAdapterExclusive.updateData(mUniqueSectionList.get(secondKey));

                    mLlExclusiveItems.setVisibility(View.VISIBLE);
                }
            } catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }

            try {
                String thirdKey = (String) mUniqueSectionList.keySet().toArray()[2];
                if (mUniqueSectionList.get(thirdKey) != null && mUniqueSectionList.get(thirdKey).size() > 0) {
                    mTvContestSection.setText(thirdKey.substring(1));
//                    mContestItems.setNestedScrollingEnabled(false);
//                    mAdapterContest = new MoreCampaignAdapter(this, mUniqueSectionList.get(thirdKey));
//                    mContestItems.setItemAnimator(null);
//                    mAdapterContest.setHasStableIds(true);
//                    mContestItems.setAdapter(mAdapterContest);
//                    mAdapterContest.getPositionClicks()
//                            .doOnNext(this::handleMoreItemClick)
//                            .doOnError(error -> {
//                            })
//                            .subscribe();
//                    mAdapterContest.notifyDataSetChanged();

                    mAdapterContest.updateData(mUniqueSectionList.get(thirdKey));

                    mLlContestItems.setVisibility(View.VISIBLE);
                }
            } catch (IndexOutOfBoundsException ex) {
                ex.printStackTrace();
            }

            if (mContextualList != null && mContextualList.size() > 0) {
                mTvContextualSection.setText(getString(R.string.cos_mfy_other));
//                mContextualItems.setNestedScrollingEnabled(false);
//                mAdapterContextual = new MoreContextualAdapter(this, mContextualList);
//                mContextualItems.setItemAnimator(null);
//                mAdapterContextual.setHasStableIds(true);
//                mContextualItems.setAdapter(mAdapterContextual);
//                mAdapterContextual.getPositionClicks()
//                        .doOnNext(this::handleMoreContextualItemClick)
//                        .doOnError(error -> {
//                        })
//                        .subscribe();
//                mAdapterContextual.notifyDataSetChanged();

                mAdapterContextual.updateData(mContextualList);

                mLlContextualItems.setVisibility(View.VISIBLE);
            }
        }
    }

    private void handleMoreItemClick(Campaign moreItem) {
        try {
            JSONObject extraFields = WarpJSONParser.getJSONFromString(moreItem.getExtraFields());
            if (extraFields != null) {
                if (extraFields.has("type") && extraFields.optString("type").equals("telco")) {
                    for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                        if (ccms.getLoyaltyCampaignId().equals(moreItem.getSessionUUID())) {
                            WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Telco").concat(":").concat(ccms.getSessionId()));

                            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                            analyticsEvent.setEventName("loyalty_sdk_offer_selected");
                            analyticsEvent.setParameter("name", ccms.getTitle());
                            analyticsEvent.setParameter("type", "gift");
                            EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));

                            WarplyManager.getSingleCampaign(moreItem.getSessionUUID());
                            Intent intent = new Intent(MoreForYouActivity.this, TelcoActivity.class);
                            intent.putExtra("ccms", ccms);
                            intent.putExtra("loyalty", (Serializable) moreItem);
                            startActivityForResult(intent, 1003);
                            break;
                        }
                    }
                    return;
                }
                if (extraFields.has("ccms_offer") && extraFields.optString("ccms_offer").equals("true")) {
                    for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                        if (ccms.getLoyaltyCampaignId().equals(moreItem.getSessionUUID())) {
                            WarpUtils.log("CCMS_CLICK " + ccms.toString());
                            WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Contextual").concat(":").concat(ccms.getSessionId()));
                            startActivityForResult(WarpViewActivity.createIntentFromURL(this, WarplyManagerHelper.constructCcmsUrl(moreItem, ccms)), 1003);
                            break;
                        }
                    }
                } else {
                    WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Loyalty").concat(":").concat(moreItem.getSessionUUID()));
                    startActivityForResult(WarpViewActivity.createIntentFromURL(this, WarplyManagerHelper.constructCampaignUrl(moreItem)), 1003);
                }
            }
        } catch (Exception exception) {
            WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Loyalty").concat(":").concat(moreItem.getSessionUUID()));
            startActivityForResult(WarpViewActivity.createIntentFromURL(this, WarplyManagerHelper.constructCampaignUrl(moreItem)), 1003);
        }
    }

    private void handleMoreContextualItemClick(LoyaltyContextualOfferModel ccmsItem) {
        LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
        analyticsEvent.setEventName("loyalty_sdk_offer_selected");
        analyticsEvent.setParameter("name", ccmsItem.getTitle());
        analyticsEvent.setParameter("type", "gift");
        EventBus.getDefault().post(new WarplyEventBusManager(analyticsEvent));

        WarplyAnalyticsManager.logTrackersEvent(this, "click", ("Contextual").concat(":").concat(ccmsItem.getSessionId()));
        Intent intent = new Intent(MoreForYouActivity.this, ContextualActivity.class);
        intent.putExtra("ccms", ccmsItem);
        startActivity(intent);
    }

    /**
     * New Implementation
     */
    private void filterItemsNew() {
        mUniqueSectionList.clear();
        ArrayList<Campaign> mfyList = new ArrayList<>();
        if (WarplyManagerHelper.getCampaignListAll() != null && WarplyManagerHelper.getCampaignListAll().size() > 0) {
            final ArrayList<Campaign> customs = new ArrayList<Campaign>();
            for (Campaign campaignItem : WarplyManagerHelper.getCampaignListAll()) {
                if (!customs.contains(campaignItem)) {
                    customs.add(campaignItem);
                }
            }

            if (WarplyManagerHelper.getCCMSLoyaltyCampaigns() == null || WarplyManagerHelper.getCCMSLoyaltyCampaigns().size() == 0) {
                for (Campaign camp : customs) {
                    if (camp.getOfferCategory().equals("more_for_you")) {
                        try {
                            JSONObject extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
                            if (extraFields != null) {
                                if (extraFields.length() == 0 || !(extraFields.has("ccms_offer") || extraFields.has("type"))) {
                                    mfyList.add(camp);
                                }
                            }
                        } catch (Exception exception) {
                            mfyList.add(camp);
                        }
                    }
                }
            } else {
                for (Campaign camp : customs) {
                    if (camp.getOfferCategory().equals("more_for_you")) {
                        try {
                            JSONObject extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
                            if (extraFields != null) {
                                if (extraFields.has("ccms_offer") && extraFields.optString("ccms_offer").equals("true")) {
                                    for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                                        if (ccms.getLoyaltyCampaignId().equals(camp.getSessionUUID())) {
                                            mfyList.add(camp);
                                            break;
                                        }
                                    }
                                } else {
                                    mfyList.add(camp);
                                }
                            }
                        } catch (Exception exception) {
                            mfyList.add(camp);
                        }
                    }
                }
            }

            if (mfyList != null && mfyList.size() > 0) {
                for (Campaign campaignItem : mfyList) {
                    JSONObject extraFields = WarpJSONParser.getJSONFromString(campaignItem.getExtraFields());
                    if (extraFields != null && extraFields.has("category_title")) {
                        String categoryTitle = extraFields.optString("category_title");

                        if (mUniqueSectionList.containsKey(categoryTitle.trim())) {
                            CampaignList tempCampaignList = (CampaignList) mUniqueSectionList.get(categoryTitle.trim());
                            tempCampaignList.add(campaignItem);
                            mUniqueSectionList.put(categoryTitle.trim(), tempCampaignList);
                        } else {
                            CampaignList tempCampaignList = new CampaignList();
                            tempCampaignList.add(campaignItem);
                            mUniqueSectionList.put(categoryTitle.trim(), tempCampaignList);
                        }
                    }
                }
            }

            Map<String, ArrayList<Campaign>> treeMap = new TreeMap<String, ArrayList<Campaign>>(mUniqueSectionList);
            mUniqueSectionList.clear();
            mUniqueSectionList = treeMap;
        }
    }
    /** New Implementation */

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================

}
