package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.EAN13Writer;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;

import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import ly.warp.sdk.R;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.UnifiedCoupon;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.views.adapters.ActiveCouponAdapter;


public class UnifiedCouponInfoActivity extends Activity implements View.OnClickListener {

    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================

    private ImageView mIvBack, mIvBarcode, mIvMarketExpand;
    private TextView mTvTerms, mTvCouponCode, mTvCouponDate, mTvMarketExpand,
            mTvTermsValue, mTvFullBarcode;
    private LinearLayout mLlShops, mLlBarcodeContainer, mLlTerms, mLlMarketCoupons, mLlMarketExpand;
    private UnifiedCoupon mCoupon;
    private boolean mIsBarcodeShown = false, mIsTermsShown = false, mIsFromWallet = false,
            mIsMarketExpand = true, mShopsPressed = false, mCouponPressed = false;
    private RecyclerView mRecyclerCoupons;
    private ActiveCouponAdapter mAdapterCoupons;

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_unified_coupon_info);

        UnifiedCoupon tempCoupon = (UnifiedCoupon) getIntent().getSerializableExtra("coupon");
        if (tempCoupon != null) {
            for (UnifiedCoupon couponItem : WarplyManagerHelper.getMarketCoupons()) {
                if (couponItem.getBarcode().equals(tempCoupon.getBarcode())) {
                    mCoupon = couponItem;
                    break;
                }
            }
        }
//        mIsFromWallet = getIntent().getBooleanExtra("isFromWallet", false);

        mIvBack = findViewById(R.id.iv_coupon_info_back);
        mTvTerms = findViewById(R.id.tv_terms);
        mTvCouponCode = findViewById(R.id.textView16);
        mTvCouponDate = findViewById(R.id.textView17);
        mIvBarcode = findViewById(R.id.iv_barcode);
        mLlShops = findViewById(R.id.ll_shops);
        mLlBarcodeContainer = findViewById(R.id.ll_barcode_container_items);
        mLlTerms = findViewById(R.id.ll_terms_inner);
        mTvTermsValue = findViewById(R.id.tv_terms_value);
        mTvFullBarcode = findViewById(R.id.tv_full_barcode);
        mLlMarketCoupons = findViewById(R.id.ll_market_coupons);
        mLlMarketExpand = findViewById(R.id.ll_market_expand);
        mTvMarketExpand = findViewById(R.id.tv_market_expand);
        mIvMarketExpand = findViewById(R.id.iv_market_expand);
        mRecyclerCoupons = findViewById(R.id.rv_active_market_coupons);
        mRecyclerCoupons.setNestedScrollingEnabled(false);
        mRecyclerCoupons.setLayoutManager(new LinearLayoutManager(this, LinearLayoutManager.VERTICAL, false));

        initViews();
    }

    @Override
    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent(this, "screen", "UnifiedCouponScreen");
        mShopsPressed = false;
        mCouponPressed = false;
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.iv_coupon_info_back) {
            onBackPressed();
            return;
        }
        if (view.getId() == R.id.ll_shops) {
            if (!mShopsPressed) {
                mShopsPressed = true;
                WarplyAnalyticsManager.logTrackersEvent(this, "click", "SeeShops");
                if (GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable(UnifiedCouponInfoActivity.this) == ConnectionResult.SUCCESS) {
                    Intent intent = new Intent(UnifiedCouponInfoActivity.this, ShopsActivity.class);
                    startActivity(intent);
                    return;
                } else {
                    Intent intent = new Intent(UnifiedCouponInfoActivity.this, ShopsHuaweiActivity.class);
                    startActivity(intent);
                    return;
                }
            }
        }
        if (view.getId() == R.id.ll_terms_inner) {
            if (mIsTermsShown) {
                mTvTermsValue.setVisibility(View.GONE);
                ImageView termsButtonArrow = mLlTerms.findViewById(R.id.iv_terms_arrow);
                termsButtonArrow.setImageDrawable(ContextCompat.getDrawable(this, R.drawable.ic_down_dark_new));
                mIsTermsShown = false;
            } else {
                mTvTermsValue.setVisibility(View.VISIBLE);
                ImageView termsButtonArrow = mLlTerms.findViewById(R.id.iv_terms_arrow);
                termsButtonArrow.setImageDrawable(ContextCompat.getDrawable(this, R.drawable.ic_up_dark_new));
                mIsTermsShown = true;
            }
            return;
        }
        if (view.getId() == R.id.ll_market_expand) {
            if (mIsMarketExpand) {
                mLlMarketCoupons.setVisibility(View.GONE);
                mTvMarketExpand.setText(getString(R.string.cos_show_market_coupons));
                mIvMarketExpand.setImageDrawable(ContextCompat.getDrawable(this, R.drawable.ic_down_dark_new));
                mIsMarketExpand = false;
            } else {
                mLlMarketCoupons.setVisibility(View.VISIBLE);
                mTvMarketExpand.setText(getString(R.string.cos_hide_market_coupons));
                mIvMarketExpand.setImageDrawable(ContextCompat.getDrawable(this, R.drawable.ic_up_dark_new));
                mIsMarketExpand = true;
            }
        }
    }

    @Override
    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext(ViewPumpContextWrapper.wrap(newBase));
    }

    // ===========================================================
    // Methods
    // ===========================================================

    private void initViews() {
        mTvCouponCode.setText(mCoupon.getBarcode());

        mLlMarketCoupons.setVisibility(View.GONE);
        mTvMarketExpand.setText(getString(R.string.cos_show_market_coupons));
        mIvMarketExpand.setImageDrawable(ContextCompat.getDrawable(this, R.drawable.ic_down_dark_new));
        mIsMarketExpand = false;

        if (mCoupon.getCoupons() != null && mCoupon.getCoupons().size() > 0) {
            CouponList cpnlist = new CouponList();
            for (Coupon cpn : mCoupon.getCoupons()) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                Date newDate = new Date();
                try {
                    newDate = simpleDateFormat.parse(cpn.getExpiration());
                } catch (ParseException e) {
                    e.printStackTrace();
                }
                cpn.setExpirationDate(newDate);
                cpnlist.add(cpn);
            }

            Collections.sort(cpnlist, (coupon1, coupon2) -> coupon1.getExpirationDate().compareTo(coupon2.getExpirationDate()));
            for (Coupon tempItem : cpnlist) {
                if (tempItem.getStatus() == 1) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                    Date newDate = new Date();
                    try {
                        newDate = simpleDateFormat.parse(cpnlist.get(0).getExpiration());
                    } catch (ParseException e) {
                        e.printStackTrace();
                    }
                    simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
                    mTvCouponDate.setText(String.format(getResources().getString(R.string.cos_mycoupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));
                    break;
                }
            }

            mAdapterCoupons = new ActiveCouponAdapter(this, cpnlist, false, true);
            mRecyclerCoupons.setAdapter(mAdapterCoupons);
            mAdapterCoupons.getPositionClicks()
                    .doOnNext(coupon -> {
                        if (!mCouponPressed) {
                            mCouponPressed = true;
                            WarplyAnalyticsManager.logTrackersEvent(this, "click", ("MarketCoupon").concat(":").concat(coupon.getName()));
                            Intent intent = new Intent(UnifiedCouponInfoActivity.this, CouponInfoActivity.class);
                            intent.putExtra("coupon", (Serializable) coupon);
                            intent.putExtra("isFromWallet", true);
                            intent.putExtra("isUnified", true);
                            startActivity(intent);
                        }
                    })
                    .doOnError(error -> {
                    })
                    .subscribe();
        }

        mIvBack.setOnClickListener(this);
        mLlShops.setOnClickListener(this);
        mLlTerms.setOnClickListener(this);
        mLlMarketExpand.setOnClickListener(this);

        String tempCoupon = "";
        int result = 0;
        try {
            tempCoupon = mCoupon.getBarcode();
            for (int i = 0; i < (12 - mCoupon.getBarcode().length()); i++) {
                tempCoupon += "0";
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        try {
            for (int i = mCoupon.getBarcode().length() - 1; i >= 0; i--) {
                result = result + Integer.parseInt(String.valueOf((mCoupon.getBarcode()).charAt(i))) * (1 + (2 * (i % 2)));
            }
        } catch (Exception e) {
            e.printStackTrace();
        }

        tempCoupon = tempCoupon + (10 - (result % 10)) % 10;
        createBarcodeBitmap(mCoupon.getBarcode()); //tempCoupon
    }

    private void createBarcodeBitmap(String barcodeString) {
        EAN13Writer writer = new EAN13Writer();
        try {
            BitMatrix bitMatrix = writer.encode(barcodeString, BarcodeFormat.EAN_13, 1024, 512);
            int width = bitMatrix.getWidth();
            int height = bitMatrix.getHeight();
            Bitmap bmp = Bitmap.createBitmap(width, height, Bitmap.Config.RGB_565);
            for (int x = 0; x < width; x++) {
                for (int y = 0; y < height; y++) {
                    bmp.setPixel(x, y, bitMatrix.get(x, y) ? Color.BLACK : Color.WHITE);
                }
            }
            mIvBarcode.setImageBitmap(bmp);
            mTvFullBarcode.setText(barcodeString);

        } catch (Exception e) {
            e.printStackTrace();
            mLlBarcodeContainer.setVisibility(View.GONE);
            mIvBarcode.setVisibility(View.GONE);
        }
    }

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================

}
