/*
 * Copyright (C) 2015 Karumi.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ly.warp.sdk.dexter;

/**
 * Utility class to let clients show the user how is the permission going to be used
 * Clients of this class must call one of the two methods and only once
 */
public interface PermissionToken {

  /**
   * Continues with the permission request process
   */
  void continuePermissionRequest();

  /**
   * Cancels the permission request process
   */
  void cancelPermissionRequest();
}
