/*
 * Copyright (C) 2015 Karumi.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package ly.warp.sdk.dexter.listener.single;


import ly.warp.sdk.dexter.PermissionToken;
import ly.warp.sdk.dexter.listener.PermissionDeniedResponse;
import ly.warp.sdk.dexter.listener.PermissionGrantedResponse;
import ly.warp.sdk.dexter.listener.PermissionRequest;

/**
 * Base implementation of {@link PermissionListener} to allow extensions to implement only the
 * required methods
 */
public class BasePermissionListener implements PermissionListener {

  @Override public void onPermissionGranted(PermissionGrantedResponse response) {

  }

  @Override public void onPermissionDenied(PermissionDeniedResponse response) {

  }

  @Override public void onPermissionRationaleShouldBeShown(PermissionRequest permission,
      PermissionToken token) {
    token.continuePermissionRequest();
  }
}
