package ly.warp.sdk.fragments;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;

import java.util.ArrayList;

import ly.warp.sdk.R;
import ly.warp.sdk.activities.ActiveCouponsActivity;
import ly.warp.sdk.activities.TelematicsActivity;
import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.request.WarplyGetCampaignsRequest;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyManager;
import ly.warp.sdk.views.adapters.HomeCampaignAdapter;

public class HomeFragment extends Fragment implements View.OnClickListener, SwipeRefreshLayout.OnRefreshListener {

    private RelativeLayout mOptionOne, mOptionTwo, mOptionThree, mRlDriving;
    private LinearLayout mLlBillPayment;
    private TextView mTvUsername, mTvActiveCoupons;
    private ConstraintLayout mClActiveCoupons;
    private ImageView mIvStepsActivity;
    private SwipeRefreshLayout mSwipeRefresh;

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_home, container, false);
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        mSwipeRefresh = view.findViewById(R.id.sw_refresh);
        mSwipeRefresh.setOnRefreshListener(this);
        mOptionOne = view.findViewById(R.id.info_button);
        TextView mOptionOneText = mOptionOne.findViewById(R.id.option_text);
        ImageView mOptionOneImage = mOptionOne.findViewById(R.id.option_icon);
        mOptionOneText.setText("2");
        mOptionOneImage.setImageResource(R.drawable.mobile_option);

        mOptionTwo = view.findViewById(R.id.info_button2);
        TextView mOptionTwoText = mOptionTwo.findViewById(R.id.option_text);
        ImageView mOptionTwoImage = mOptionTwo.findViewById(R.id.option_icon);
        mOptionTwoText.setText("1");
        mOptionTwoImage.setImageResource(R.drawable.phone_option);

        mOptionThree = view.findViewById(R.id.info_button3);
        TextView mOptionThreeText = mOptionThree.findViewById(R.id.option_text);
        ImageView mOptionThreeImage = mOptionThree.findViewById(R.id.option_icon);
        mOptionThreeText.setText("1");
        mOptionThreeImage.setImageResource(R.drawable.tv_option);

        mClActiveCoupons = view.findViewById(R.id.cl_coupon);
        mTvActiveCoupons = mClActiveCoupons.findViewById(R.id.tv_active_coupons);
        mTvActiveCoupons.setText(String.format(getResources().getString(R.string.cos_active_coupons), String.valueOf(WarplyManagerHelper.getCouponList().size())));
        mClActiveCoupons.setOnClickListener(this);

        mLlBillPayment = view.findViewById(R.id.ll_bill_payment);
        mLlBillPayment.setOnClickListener(this);

        mIvStepsActivity = view.findViewById(R.id.iv_settings);
        mIvStepsActivity.setOnClickListener(this);

        mTvUsername = view.findViewById(R.id.welcome_user_txt);
        if (WarplyManagerHelper.getConsumer() != null)
            mTvUsername.setText(String.format(getResources().getString(R.string.welcome_user),
                    WarplyManagerHelper.getConsumer().getFirstName() + " " + WarplyManagerHelper.getConsumer().getLastName()));

        mRlDriving = view.findViewById(R.id.rl_driving);
        mRlDriving.setOnClickListener(this);
    }

    @Override
    public void onDestroyView() {
        super.onDestroyView();
    }

    @Override
    public void onRefresh() {
        WarplyManager.getUserCouponsWithCouponsets(mUserCouponsReceiver);
        WarplyManager.getCampaigns(new WarplyGetCampaignsRequest().setLanguage("en"), mCampaignsCallback);
        mSwipeRefresh.setRefreshing(false);
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.cl_coupon) {
            Intent intent = new Intent(getContext(), ActiveCouponsActivity.class);
            intent.putExtra("couponlist", WarplyManagerHelper.getCouponList());
            startActivity(intent);
            return;
        }
        if (view.getId() == R.id.rl_driving) {
            Intent intent = new Intent(getContext(), TelematicsActivity.class);
            startActivity(intent);
        }
    }

    public static Fragment newInstance() {
        HomeFragment homeFragment = new HomeFragment();
        return homeFragment;
    }

    private final CallbackReceiver<ArrayList<Campaign>> mCampaignsCallback = new CallbackReceiver<ArrayList<Campaign>>() {
        @Override
        public void onSuccess(ArrayList<Campaign> result) {
            Toast.makeText(getActivity(), "Campaigns Success", Toast.LENGTH_SHORT).show();
        }

        @Override
        public void onFailure(int errorCode) {
            Toast.makeText(getActivity(), "Campaigns Error", Toast.LENGTH_SHORT).show();
        }
    };


    private final CallbackReceiver<CouponList> mUserCouponsReceiver = new CallbackReceiver<CouponList>() {
        @Override
        public void onSuccess(CouponList result) {
            Toast.makeText(getActivity(), "Coupons Success " + String.valueOf(result.size()), Toast.LENGTH_SHORT).show();
        }

        @Override
        public void onFailure(int errorCode) {
            Toast.makeText(getActivity(), "Coupons Error", Toast.LENGTH_SHORT).show();
        }
    };
}