package ly.warp.sdk.fragments;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;

import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import org.json.JSONObject;

import ly.warp.sdk.R;
import ly.warp.sdk.activities.GiftsForYouActivity;
import ly.warp.sdk.activities.LoyaltyWallet;
import ly.warp.sdk.activities.MoreForYouActivity;
import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.views.adapters.ProfileCampaignAdapter;

public class LoyaltyFragment extends Fragment implements View.OnClickListener {

    // ===========================================================
    // Constants
    // ===========================================================

    // ===========================================================
    // Fields
    // ===========================================================

    private RecyclerView mRecyclerDeals, mRecyclerGifts, mRecyclerMore;
    private ProfileCampaignAdapter mAdapterDeals, mAdapterGifts, mAdapterMore;
    private ImageView mIvMoreDeals, mIvMoreGifts, mIvMore;
    private ConstraintLayout mClRewardsWallet, mClDealsOuter, mClGiftsOuter, mClMoreOuter;
    private TextView mTvUsername;

    // ===========================================================
    // Methods for/from SuperClass/Interfaces
    // ===========================================================

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_loyalty, container, false);
    }

    @Override
    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);

        mClRewardsWallet = view.findViewById(R.id.cl_rewards_wallet);
        mClRewardsWallet.setOnClickListener(this);

        mTvUsername = view.findViewById(R.id.tv_name);
        if (WarplyManagerHelper.getConsumer() != null)
            mTvUsername.setText(String.format(getResources().getString(R.string.cos_profile_name),
                    WarplyManagerHelper.getConsumer().getFirstName() + " " + WarplyManagerHelper.getConsumer().getLastName()));

        mIvMoreDeals = view.findViewById(R.id.iv_more);
        mIvMoreDeals.setOnClickListener(this);
        mIvMoreGifts = view.findViewById(R.id.iv_more2);
        mIvMoreGifts.setOnClickListener(this);
        mIvMore = view.findViewById(R.id.iv_more3);
        mIvMore.setOnClickListener(this);

//        mClDealsOuter = view.findViewById(R.id.cl_recycler_inner);
//        mRecyclerDeals = view.findViewById(R.id.rv_deals);
//        if (WarplyManagerHelper.getUniqueCampaignList().get("deals_for_you") != null && WarplyManagerHelper.getUniqueCampaignList().get("deals_for_you").size() > 0) {
//            mRecyclerDeals.setLayoutManager(new LinearLayoutManager(getContext(), LinearLayoutManager.HORIZONTAL, false));
//            mAdapterDeals = new ProfileCampaignAdapter(getContext(), WarplyManagerHelper.getUniqueCampaignList().get("deals_for_you"));
//            mRecyclerDeals.setAdapter(mAdapterDeals);
//            mAdapterDeals.getPositionClicks()
//                    .doOnNext(deal -> {
//                        startActivity(WarpViewActivity.createIntentFromURL(getContext(), WarplyManagerHelper.constructCampaignUrl(deal)));
//                    })
//                    .doOnError(error -> {
//                    })
//                    .subscribe();
//        } else {
//            mClDealsOuter.setVisibility(View.GONE);
//        }

        mClGiftsOuter = view.findViewById(R.id.cl_recycler_inner2);
        mRecyclerGifts = view.findViewById(R.id.rv_gifts);
        if (WarplyManagerHelper.getCampaignList() != null && WarplyManagerHelper.getCampaignList().size() > 0) {
            CampaignList gfyList = new CampaignList();
            for (Campaign camp : WarplyManagerHelper.getCampaignList()) {
                if (camp.getOfferCategory().equals("gifts_for_you")) {
                    gfyList.add(camp);
                }
            }

            mRecyclerGifts.setLayoutManager(new LinearLayoutManager(getContext(), LinearLayoutManager.HORIZONTAL, false));
            mAdapterGifts = new ProfileCampaignAdapter(getContext(), gfyList);
            mRecyclerGifts.setAdapter(mAdapterGifts);
            mAdapterGifts.getPositionClicks()
                    .doOnNext(gift -> {
                        try {
                            JSONObject extraFields = WarpJSONParser.getJSONFromString(gift.getExtraFields());
                            if (extraFields != null) {
                                if (extraFields.has("type") && extraFields.optString("type").equals("telco")) {
                                    WarplyManagerHelper.openTelco(getContext(), gift);
                                    return;
                                }
                            }
                        } catch (Exception exception) {
                            startActivity(WarpViewActivity.createIntentFromURL(getContext(), WarplyManagerHelper.constructCampaignUrl(gift)));
                            return;
                        }

                        if (gift.getType().equals("coupon")) {
                            WarplyManagerHelper.openCouponset(getContext(), gift);
                        } else
                            startActivity(WarpViewActivity.createIntentFromURL(getContext(), WarplyManagerHelper.constructCampaignUrl(gift)));
                    })
                    .doOnError(error -> {
                    })
                    .subscribe();
        } else {
            mClGiftsOuter.setVisibility(View.GONE);
        }

        mClMoreOuter = view.findViewById(R.id.cl_recycler_inner3);
        mRecyclerMore = view.findViewById(R.id.rv_more);
        if (WarplyManagerHelper.getCampaignList() != null && WarplyManagerHelper.getCampaignList().size() > 0) {
            CampaignList mfyList = new CampaignList();
            for (Campaign camp : WarplyManagerHelper.getCampaignList()) {
                if (camp.getOfferCategory().equals("more_for_you")) {
                    mfyList.add(camp);
                }
            }

            mRecyclerMore.setLayoutManager(new LinearLayoutManager(getContext(), LinearLayoutManager.HORIZONTAL, false));
            mAdapterMore = new ProfileCampaignAdapter(getContext(), mfyList);
            mRecyclerMore.setAdapter(mAdapterMore);
            mAdapterMore.getPositionClicks()
                    .doOnNext(more -> {
                        try {
                            JSONObject extraFields = WarpJSONParser.getJSONFromString(more.getExtraFields());
                            if (extraFields != null) {
                                if (extraFields.has("type") && extraFields.optString("type").equals("telco")) {
                                    WarplyManagerHelper.openTelco(getContext(), more);
                                    return;
                                }
                            }
                        } catch (Exception exception) {
                            startActivity(WarpViewActivity.createIntentFromURL(getContext(), WarplyManagerHelper.constructCampaignUrl(more)));
                            return;
                        }

                        if (more.getType().equals("coupon")) {
                            WarplyManagerHelper.openCouponset(getContext(), more);
                        } else
                            startActivity(WarpViewActivity.createIntentFromURL(getContext(), WarplyManagerHelper.constructCampaignUrl(more)));
                    })
                    .doOnError(error -> {
                    })
                    .subscribe();
        } else {
            mClMoreOuter.setVisibility(View.GONE);
        }
    }

    @Override
    public void onClick(View view) {
        if (view.getId() == R.id.cl_rewards_wallet) {
            Intent intent = new Intent(getContext(), LoyaltyWallet.class);
            startActivity(intent);
            return;
        }
        if (view.getId() == R.id.iv_more2) {
            Intent intent = new Intent(getContext(), GiftsForYouActivity.class);
            startActivity(intent);
            return;
        }
        if (view.getId() == R.id.iv_more3) {
            Intent intent = new Intent(getContext(), MoreForYouActivity.class);
            startActivity(intent);
        }
    }

    // ===========================================================
    // Methods
    // ===========================================================

    public static Fragment newInstance() {
        LoyaltyFragment loyaltyFragment = new LoyaltyFragment();
        return loyaltyFragment;
    }

    // ===========================================================
    // Inner and Anonymous Classes
    // ===========================================================

}
